/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.statetransfer.StateTransferFunctionalTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.DelayedMarshallingPojo;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferCacheLoaderFunctionalTest")
public class StateTransferCacheLoaderFunctionalTest
extends StateTransferFunctionalTest {
    int id;
    ThreadLocal<Boolean> sharedCacheLoader = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public StateTransferCacheLoaderFunctionalTest() {
        super("nbst-with-loader");
    }

    @Override
    protected EmbeddedCacheManager createCacheManager(String cacheName) {
        this.configurationBuilder.persistence().clearStores();
        DummyInMemoryStoreConfigurationBuilder dimcs = new DummyInMemoryStoreConfigurationBuilder(this.configurationBuilder.persistence());
        dimcs.storeName("store number " + this.id++);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)dimcs.fetchPersistentState(true)).shared(this.sharedCacheLoader.get())).preload(true);
        this.configurationBuilder.persistence().addStore((StoreConfigurationBuilder)dimcs);
        this.configurationBuilder.persistence();
        return super.createCacheManager(cacheName);
    }

    @Override
    protected void writeInitialData(Cache<Object, Object> c) {
        super.writeInitialData(c);
        c.evict((Object)"a_b_name");
        c.evict((Object)"a_b_age");
        c.evict((Object)"a_c_name");
        c.evict((Object)"a_c_age");
        c.evict((Object)"a_d_age");
        c.evict((Object)"a_d_age");
    }

    protected void verifyInitialDataOnLoader(Cache<Object, Object> c) throws Exception {
        DummyInMemoryStore l = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
        assert (l.contains("a_b_age"));
        assert (l.contains("a_b_name"));
        assert (l.contains("a_c_age"));
        assert (l.contains("a_c_name"));
        assert (l.loadEntry("a_b_age").getValue().equals(TWENTY));
        assert (l.loadEntry("a_b_name").getValue().equals("JOE"));
        assert (l.loadEntry("a_c_age").getValue().equals(FORTY));
        assert (l.loadEntry("a_c_name").getValue().equals("BOB"));
    }

    protected void verifyNoData(Cache<Object, Object> c) {
        assert (c.isEmpty()) : "Cache should be empty!";
    }

    protected void verifyNoDataOnLoader(Cache<Object, Object> c) throws Exception {
        DummyInMemoryStore l = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
        assert (!l.contains("a_b_age"));
        assert (!l.contains("a_b_name"));
        assert (!l.contains("a_c_age"));
        assert (!l.contains("a_c_name"));
        assert (!l.contains("a_d_age"));
        assert (!l.contains("a_d_age"));
    }

    public void testSharedLoader() throws Exception {
        try {
            this.sharedCacheLoader.set(true);
            Cache c1 = this.createCacheManager(this.cacheName).getCache(this.cacheName);
            this.writeInitialData((Cache<Object, Object>)c1);
            Cache c2 = this.createCacheManager(this.cacheName).getCache(this.cacheName);
            TestingUtil.blockUntilViewsReceived(60000L, c1, c2);
            TestingUtil.waitForNoRebalance(c1, c2);
            this.verifyInitialDataOnLoader((Cache<Object, Object>)c1);
            this.verifyInitialData((Cache<Object, Object>)c1);
            this.verifyNoDataOnLoader((Cache<Object, Object>)c2);
            this.verifyNoData((Cache<Object, Object>)c2.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL));
        }
        finally {
            this.sharedCacheLoader.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitialSlowPreload() throws Exception {
        try {
            this.sharedCacheLoader.set(true);
            EmbeddedCacheManager cm1 = this.createCacheManager(this.cacheName);
            Cache cache1 = cm1.getCache(this.cacheName);
            this.verifyNoDataOnLoader((Cache<Object, Object>)cache1);
            this.verifyNoData((Cache<Object, Object>)cache1);
            cache1.put((Object)"A", (Object)new DelayedMarshallingPojo(0, 2000));
            cache1.put((Object)"B", (Object)new DelayedMarshallingPojo(0, 2000));
            cache1.put((Object)"C", (Object)new DelayedMarshallingPojo(0, 2000));
            Assert.assertEquals((int)cache1.size(), (int)3);
            cm1.stop();
            ConfigurationBuilder defaultConfigurationBuilder = StateTransferCacheLoaderFunctionalTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
            EmbeddedCacheManager cm2 = super.createCacheManager(this.cacheName);
            cm2.defineConfiguration("initialCache", defaultConfigurationBuilder.build());
            cm2.startCaches(new String[]{"initialCache"});
            EmbeddedCacheManager cm3 = super.createCacheManager(this.cacheName);
            cm3.defineConfiguration("initialCache", defaultConfigurationBuilder.build());
            cm3.startCaches(new String[]{"initialCache"});
            TestingUtil.blockUntilViewsReceived(60000L, cm2.getCache("initialCache"), cm3.getCache("initialCache"));
            Future<Void> future = this.fork(() -> {
                cm2.startCaches(new String[]{this.cacheName});
                return null;
            });
            TestingUtil.sleepThread(1000L);
            future.get(10L, TimeUnit.SECONDS);
            cm3.startCaches(new String[]{this.cacheName});
            Assert.assertEquals((int)cm3.getCache(this.cacheName).size(), (int)3);
        }
        finally {
            this.sharedCacheLoader.set(false);
        }
    }
}

