/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.lang.reflect.Method;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferFetchOnlyPersistentStateTest")
public class StateTransferFetchOnlyPersistentStateTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() {
        ConfigurationBuilder cfg = this.createConfiguration(1);
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        cm.defineConfiguration("onlyFetchPersistent", cfg.build());
    }

    private ConfigurationBuilder createConfiguration(int id) {
        ConfigurationBuilder cfg = StateTransferFetchOnlyPersistentStateTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        cfg.clustering().stateTransfer().fetchInMemoryState(false);
        DummyInMemoryStoreConfigurationBuilder dimcs = new DummyInMemoryStoreConfigurationBuilder(cfg.persistence());
        dimcs.storeName("store id: " + id);
        ((DummyInMemoryStoreConfigurationBuilder)dimcs.fetchPersistentState(true)).shared(false);
        cfg.persistence().addStore((StoreConfigurationBuilder)dimcs);
        return cfg;
    }

    public void test000(Method m) {
        String theKey = "k-" + m.getName();
        String theValue = "v-" + m.getName();
        Cache cache1 = this.cache(0, "onlyFetchPersistent");
        assert (!cache1.getCacheConfiguration().clustering().stateTransfer().fetchInMemoryState());
        cache1.put((Object)theKey, (Object)theValue);
        ConfigurationBuilder cfg2 = this.createConfiguration(2);
        EmbeddedCacheManager cm2 = this.addClusterEnabledCacheManager();
        cm2.defineConfiguration("onlyFetchPersistent", cfg2.build());
        Cache cache2 = this.cache(1, "onlyFetchPersistent");
        assert (!cache2.getCacheConfiguration().clustering().stateTransfer().fetchInMemoryState());
        assert (cache2.containsKey((Object)theKey));
        assert (cache2.get((Object)theKey).equals(theValue));
    }
}

