/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.HashSet;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.distribution.BlockingInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestBlocking;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferPessimisticTest")
@CleanupAfterMethod
public class StateTransferPessimisticTest
extends MultipleCacheManagersTest {
    public static final int NUM_KEYS = 100;
    public static final int CLUSTER_SIZE = 2;
    private ConfigurationBuilder dccc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dccc = StateTransferPessimisticTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true, true);
        this.dccc.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC);
        this.dccc.clustering().hash().numOwners(1).l1().disable();
        this.dccc.locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createCluster(TestDataSCI.INSTANCE, this.dccc, 2);
        this.waitForClusterToForm();
    }

    public void testStateTransfer() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(2);
        this.blockDataContainerIteration(this.cache(0), barrier);
        HashSet<Object> keys = new HashSet<Object>();
        for (int i = 0; i < 100; ++i) {
            Object key = this.getKeyForCache(0);
            if (!keys.add(key)) continue;
            this.cache(0).put(key, key);
        }
        log.trace((Object)"State transfer happens here");
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.dccc);
        this.waitForClusterToForm();
        barrier.await(10L, TimeUnit.SECONDS);
        log.trace((Object)"Checking the values from caches...");
        for (Object key : keys) {
            AssertJUnit.assertEquals((int)1, (int)this.checkKey(key, this.cache(0)));
        }
        barrier.await(10L, TimeUnit.SECONDS);
        this.cache(0).getAdvancedCache().getAsyncInterceptorChain().removeInterceptor(BlockingInterceptor.class);
        for (Object key : keys) {
            this.eventuallyEquals(1, () -> this.checkKey(key, this.cache(0), this.cache(1), this.cache(2)));
        }
    }

    public int checkKey(Object key, Cache ... caches) {
        log.tracef("Checking key: %s", key);
        int c = 0;
        for (Cache cache : caches) {
            InternalCacheEntry e = cache.getAdvancedCache().getDataContainer().get(key);
            if (e == null) continue;
            AssertJUnit.assertEquals((Object)key, (Object)e.getValue());
            ++c;
        }
        for (Cache cache : caches) {
            AssertJUnit.assertEquals((Object)key, (Object)cache.get(key));
        }
        return c;
    }

    protected void blockDataContainerIteration(Cache<?, ?> cache, CyclicBarrier barrier) {
        InternalDataContainer dataContainer = TestingUtil.extractComponent(cache, InternalDataContainer.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)dataContainer);
        InternalDataContainer mockContainer = (InternalDataContainer)Mockito.mock(InternalDataContainer.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((InternalDataContainer)Mockito.doAnswer(invocation -> {
            TestBlocking.await(barrier, 10L, TimeUnit.SECONDS);
            TestBlocking.await(barrier, 10L, TimeUnit.SECONDS);
            return forwardedAnswer.answer(invocation);
        }).when((Object)mockContainer)).removeSegments((IntSet)ArgumentMatchers.any());
        TestingUtil.replaceComponent(cache, InternalDataContainer.class, mockContainer, true);
    }
}

