/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="statetransfer.StateTransferTimestampsTest", groups={"functional"})
public class StateTransferTimestampsTest
extends MultipleCacheManagersTest {
    public static final String CACHE_NAME = "cache";
    private ControlledTimeService timeService;

    @Override
    public Object[] factory() {
        return new Object[]{new StateTransferTimestampsTest().cacheMode(CacheMode.DIST_SYNC), new StateTransferTimestampsTest().cacheMode(CacheMode.REPL_SYNC), new StateTransferTimestampsTest().cacheMode(CacheMode.SCATTERED_SYNC), new StateTransferTimestampsTest().cacheMode(CacheMode.DIST_SYNC).storageType(StorageType.OFF_HEAP), new StateTransferTimestampsTest().cacheMode(CacheMode.DIST_SYNC).storageType(StorageType.BINARY)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(new ConfigurationBuilder(), 2);
        this.timeService = new ControlledTimeService();
        ConfigurationBuilder replConfig = new ConfigurationBuilder();
        replConfig.clustering().cacheMode(this.cacheMode).hash().numSegments(4);
        if (this.storageType != null) {
            replConfig.memory().storage(this.storageType);
        }
        for (EmbeddedCacheManager manager : this.managers()) {
            TestingUtil.replaceComponent((CacheContainer)manager, TimeService.class, this.timeService, true);
            manager.defineConfiguration(CACHE_NAME, replConfig.build());
        }
    }

    public void testStateTransfer() {
        AdvancedCache cache0 = this.advancedCache(0, CACHE_NAME);
        cache0.put((Object)"lifespan", (Object)"value", 2L, TimeUnit.SECONDS);
        cache0.put((Object)"maxidle", (Object)"value", -1L, TimeUnit.SECONDS, 2L, TimeUnit.SECONDS);
        cache0.put((Object)"lifespan+maxidle", (Object)"value", 10L, TimeUnit.SECONDS, 2L, TimeUnit.SECONDS);
        long created = this.timeService.wallClockTime();
        if (!this.cacheMode.isScattered()) {
            this.assertTimestamps(cache0, created, created);
        }
        this.timeService.advance(TimeUnit.SECONDS.toMillis(1L));
        AdvancedCache cache1 = this.advancedCache(1, CACHE_NAME);
        long accessed = this.timeService.wallClockTime();
        this.assertTimestamps(cache1, created, accessed);
        this.timeService.advance(TimeUnit.SECONDS.toMillis(2L));
        AssertJUnit.assertNull((Object)cache1.getCacheEntry((Object)"lifespan"));
        AssertJUnit.assertNotNull((Object)cache1.getCacheEntry((Object)"maxidle"));
        AssertJUnit.assertNotNull((Object)cache1.getCacheEntry((Object)"lifespan+maxidle"));
        this.timeService.advance(TimeUnit.SECONDS.toMillis(3L));
        AssertJUnit.assertNull((Object)cache1.getCacheEntry((Object)"maxidle"));
        AssertJUnit.assertNull((Object)cache1.getCacheEntry((Object)"lifespan+maxidle"));
    }

    private void assertTimestamps(AdvancedCache<Object, Object> cache, long created, long accessed) {
        CacheEntry lifespanEntry = cache.getCacheEntry((Object)"lifespan");
        AssertJUnit.assertEquals((long)created, (long)lifespanEntry.getCreated());
        AssertJUnit.assertEquals((long)-1L, (long)lifespanEntry.getLastUsed());
        CacheEntry maxIdleEntry = cache.getCacheEntry((Object)"maxidle");
        AssertJUnit.assertEquals((long)-1L, (long)maxIdleEntry.getCreated());
        AssertJUnit.assertEquals((long)accessed, (long)maxIdleEntry.getLastUsed());
        CacheEntry lifespanMaxIdleEntry = cache.getCacheEntry((Object)"lifespan+maxidle");
        AssertJUnit.assertEquals((long)created, (long)lifespanMaxIdleEntry.getCreated());
        AssertJUnit.assertEquals((long)accessed, (long)lifespanMaxIdleEntry.getLastUsed());
    }
}

