/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import java.util.stream.IntStream;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.eviction.EvictionType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.SingleStatsTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.ClusteredStatsTest")
public class ClusteredStatsTest
extends SingleStatsTest {
    protected final int CLUSTER_SIZE = 3;
    protected final String CACHE_NAME = ClusteredStatsTest.class.getSimpleName();
    protected ClusterCacheStats stats;

    @Override
    public Object[] factory() {
        return new Object[]{new ClusteredStatsTest().withStorage(StorageType.OBJECT).withEvictionType(EvictionType.COUNT), new ClusteredStatsTest().withStorage(StorageType.OFF_HEAP).withEvictionType(EvictionType.COUNT)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder global = this.defaultGlobalConfigurationBuilder();
        global.metrics().accurateSize(true);
        ConfigurationBuilder configBuilder = ClusteredStatsTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        this.configure(configBuilder);
        Configuration config = configBuilder.build();
        this.createCluster(global, new ConfigurationBuilder(), 3);
        for (int i2 = 0; i2 < 2; ++i2) {
            ((EmbeddedCacheManager)this.cacheManagers.get(i2)).createCache(this.CACHE_NAME, config);
        }
        TestingUtil.blockUntilViewsReceived(30000, this.cacheManagers);
        TestingUtil.waitForNoRebalance((Cache[])IntStream.range(0, 2).mapToObj(i -> this.cache(i, this.CACHE_NAME)).toArray(Cache[]::new));
        this.cache = this.cache(0, this.CACHE_NAME);
        this.refreshStats();
    }

    public void testClusteredStats() {
        for (int i = 0; i < 5; ++i) {
            this.cache.put((Object)("key" + i), (Object)("value" + i));
        }
        this.eventuallyEquals(4, () -> {
            this.refreshClusterStats();
            return (int)this.stats.getPassivations();
        });
    }

    protected void refreshClusterStats() {
        this.stats = (ClusterCacheStats)this.cache.getAdvancedCache().getComponentRegistry().getComponent(ClusterCacheStats.class);
    }
}

