/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.context.Flag;
import org.infinispan.eviction.EvictionType;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.stats.Stats;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stats.SingleStatsTest")
public class SingleStatsTest
extends MultipleCacheManagersTest {
    private static final int OFF_HEAP_KEY_SIZE = 6;
    private static final int OFF_HEAP_VALUE_SIZE = 8;
    private static final long OFF_HEAP_SIZE = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)UnpooledOffHeapMemoryAllocator.offHeapEntrySize((boolean)true, (boolean)false, (int)6, (int)8));
    protected final int EVICTION_MAX_ENTRIES = 3;
    protected final int TOTAL_ENTRIES = 5;
    protected StorageType storageType;
    protected EvictionType evictionType;
    protected Cache cache;
    protected Stats stats;

    @Override
    public Object[] factory() {
        return new Object[]{new SingleStatsTest().withStorage(StorageType.BINARY).withEvictionType(EvictionType.MEMORY), new SingleStatsTest().withStorage(StorageType.BINARY).withEvictionType(EvictionType.COUNT), new SingleStatsTest().withStorage(StorageType.OBJECT).withEvictionType(EvictionType.COUNT), new SingleStatsTest().withStorage(StorageType.OFF_HEAP).withEvictionType(EvictionType.COUNT), new SingleStatsTest().withStorage(StorageType.OFF_HEAP).withEvictionType(EvictionType.MEMORY)};
    }

    @Override
    protected String[] parameterNames() {
        return SingleStatsTest.concat(super.parameterNames(), "StorageType", "EvictionType");
    }

    @Override
    protected Object[] parameterValues() {
        return SingleStatsTest.concat(super.parameterValues(), this.storageType, this.evictionType);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfg = SingleStatsTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        this.configure(cfg);
        GlobalConfigurationBuilder global = this.defaultGlobalConfigurationBuilder();
        global.metrics().accurateSize(true);
        this.addClusterEnabledCacheManager(global, cfg);
        this.cache = this.cache(0);
        this.refreshStats();
    }

    protected void configure(ConfigurationBuilder cfg) {
        long size = 3L;
        if (this.evictionType == EvictionType.MEMORY) {
            if (this.storageType == StorageType.BINARY) {
                size *= 128L;
            } else {
                size = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)(size * OFF_HEAP_SIZE));
                size += UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)2048L);
            }
        }
        ((DummyInMemoryStoreConfigurationBuilder)cfg.statistics().enable().memory().storageType(this.storageType).evictionType(this.evictionType).size(size).persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).purgeOnStartup(true);
    }

    public SingleStatsTest withStorage(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public SingleStatsTest withEvictionType(EvictionType evictionType) {
        this.evictionType = evictionType;
        return this;
    }

    @AfterMethod
    public void cleanCache() {
        this.cache.clear();
        this.cache.getAdvancedCache().getStats().reset();
    }

    public void testStats() {
        for (int i = 0; i < 5; ++i) {
            this.cache.put((Object)("key" + i), (Object)("value" + i));
        }
        this.refreshStats();
        AssertJUnit.assertEquals((int)5, (int)this.stats.getCurrentNumberOfEntries());
        AssertJUnit.assertEquals((int)3, (int)this.stats.getCurrentNumberOfEntriesInMemory());
        this.eventuallyEquals(2L, () -> {
            this.refreshStats();
            return this.stats.getEvictions();
        });
        int additionalMisses = 0;
        for (int i = 0; i < 5; ++i) {
            String key;
            AdvancedCache skipLoaderCache = this.cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD);
            if (skipLoaderCache.containsKey((Object)(key = "key" + i))) {
                this.cache.evict((Object)key);
                break;
            }
            ++additionalMisses;
        }
        this.refreshStats();
        AssertJUnit.assertEquals((long)3L, (long)this.stats.getEvictions());
        AssertJUnit.assertEquals((Object)"value1", (Object)this.cache.get((Object)"key1"));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache.get((Object)"key2"));
        AssertJUnit.assertEquals((Object)"value1", (Object)this.cache.remove((Object)"key1"));
        AssertJUnit.assertEquals((Object)"value2", (Object)this.cache.remove((Object)"key2"));
        AssertJUnit.assertNull((Object)this.cache.remove((Object)"non-existing"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key1"));
        AssertJUnit.assertNull((Object)this.cache.get((Object)"key2"));
        this.refreshStats();
        AssertJUnit.assertEquals((long)3L, (long)this.stats.getHits());
        AssertJUnit.assertEquals((long)(2 + additionalMisses), (long)this.stats.getMisses());
        AssertJUnit.assertEquals((long)2L, (long)this.stats.getRemoveHits());
        AssertJUnit.assertEquals((long)1L, (long)this.stats.getRemoveMisses());
        AssertJUnit.assertEquals((long)(5 + additionalMisses), (long)this.stats.getRetrievals());
        AssertJUnit.assertEquals((long)5L, (long)this.stats.getStores());
        this.cache.put((Object)"other-key", (Object)"value");
        this.refreshStats();
        AssertJUnit.assertEquals((long)6L, (long)this.stats.getTotalNumberOfEntries());
        AssertJUnit.assertTrue((this.stats.getAverageReadTime() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageRemoveTime() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageWriteTime() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageReadTimeNanos() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageRemoveTimeNanos() >= 0L ? 1 : 0) != 0);
        AssertJUnit.assertTrue((this.stats.getAverageWriteTimeNanos() >= 0L ? 1 : 0) != 0);
        if (this.evictionType == EvictionType.COUNT) {
            AssertJUnit.assertEquals((long)0L, (long)this.stats.getDataMemoryUsed());
        } else {
            AssertJUnit.assertTrue((this.stats.getDataMemoryUsed() > 0L ? 1 : 0) != 0);
        }
        if (this.storageType == StorageType.OFF_HEAP) {
            AssertJUnit.assertTrue((this.stats.getOffHeapMemoryUsed() > 0L ? 1 : 0) != 0);
        }
    }

    protected void refreshStats() {
        this.stats = this.cache.getAdvancedCache().getStats();
    }
}

