/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.stream.BaseSetupStreamIteratorTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.BaseStreamIteratorEvictionTest")
public abstract class BaseStreamIteratorEvictionTest
extends BaseSetupStreamIteratorTest {
    public BaseStreamIteratorEvictionTest(boolean tx, CacheMode mode) {
        super(tx, mode);
    }

    public void testExpiredEntryNotReturned() throws InterruptedException {
        Map results;
        Cache cache = this.cache(0, "testCache");
        LinkedHashMap<Integer, String> valuesInserted = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < 5; ++i) {
            Integer key = i;
            String value = key + " stay in cache";
            cache.put((Object)key, (Object)value);
            valuesInserted.put(key, value);
        }
        int expectedTime = 2;
        cache.put((Object)"expired", (Object)"this shouldn't be returned", (long)expectedTime, TimeUnit.SECONDS);
        Thread.sleep(TimeUnit.SECONDS.toMillis(expectedTime) + 50L);
        try (CacheStream stream = cache.getAdvancedCache().cacheEntrySet().stream();){
            results = BaseStreamIteratorEvictionTest.mapFromStream(stream);
        }
        AssertJUnit.assertEquals(valuesInserted, results);
    }
}

