/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.SerializeWith;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stream.CacheAware;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableBinaryOperator;
import org.infinispan.util.function.SerializableComparator;
import org.infinispan.util.function.SerializableConsumer;
import org.infinispan.util.function.SerializableDoubleBinaryOperator;
import org.infinispan.util.function.SerializableDoubleConsumer;
import org.infinispan.util.function.SerializableDoubleFunction;
import org.infinispan.util.function.SerializableDoublePredicate;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.SerializableIntBinaryOperator;
import org.infinispan.util.function.SerializableIntConsumer;
import org.infinispan.util.function.SerializableIntFunction;
import org.infinispan.util.function.SerializableIntPredicate;
import org.infinispan.util.function.SerializableLongBinaryOperator;
import org.infinispan.util.function.SerializableLongConsumer;
import org.infinispan.util.function.SerializableLongFunction;
import org.infinispan.util.function.SerializableLongPredicate;
import org.infinispan.util.function.SerializableObjDoubleConsumer;
import org.infinispan.util.function.SerializableObjIntConsumer;
import org.infinispan.util.function.SerializableObjLongConsumer;
import org.infinispan.util.function.SerializablePredicate;
import org.infinispan.util.function.SerializableSupplier;
import org.infinispan.util.function.SerializableToDoubleFunction;
import org.infinispan.util.function.SerializableToIntFunction;
import org.infinispan.util.function.SerializableToLongFunction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseStreamTest
extends MultipleCacheManagersTest {
    protected final String CACHE_NAME = "testCache";
    protected ConfigurationBuilder builderUsed;
    static final Map<Integer, Object> forEachStructure = new ConcurrentHashMap<Integer, Object>();
    static final AtomicInteger forEachOffset = new AtomicInteger();
    static final SerializableToIntFunction<Map.Entry<Integer, String>> toInt = Map.Entry::getKey;
    static final SerializableToLongFunction<Map.Entry<Long, String>> toLong = Map.Entry::getKey;
    static final SerializableToDoubleFunction<Map.Entry<Double, String>> toDouble = Map.Entry::getKey;

    static int populateNextForEachStructure(Object obj) {
        int offset = forEachOffset.getAndIncrement();
        forEachStructure.put(offset, obj);
        return offset;
    }

    static <R> R getForEachObject(int offset) {
        return (R)forEachStructure.get(offset);
    }

    static void clearForEachObject(int offset) {
        forEachStructure.remove(offset);
    }

    public BaseStreamTest(boolean tx) {
        this.transactional = tx;
    }

    protected void enhanceConfiguration(ConfigurationBuilder builder) {
    }

    protected abstract <E> CacheStream<E> createStream(CacheCollection<E> var1);

    @Override
    protected void createCacheManagers() throws Throwable {
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(this.cacheMode);
        if (this.transactional.booleanValue()) {
            this.builderUsed.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        if (this.cacheMode.isClustered()) {
            this.builderUsed.clustering().stateTransfer().chunkSize(50);
            this.enhanceConfiguration(this.builderUsed);
            this.createClusteredCaches(3, "testCache", this.builderUsed);
        } else {
            this.enhanceConfiguration(this.builderUsed);
            EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(this.builderUsed);
            this.cacheManagers.add(cm);
            cm.defineConfiguration("testCache", this.builderUsed.build());
        }
    }

    protected <K, V> Cache<K, V> getCache(int index) {
        return this.cache(index, "testCache");
    }

    public void testObjAllMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).allMatch((SerializablePredicate & Serializable)e -> ((String)e.getValue()).endsWith("-value")));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).allMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() % 2 == 0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).allMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() < 10 && (Integer)e.getKey() >= 0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).allMatch((SerializablePredicate & Serializable)e -> ((Integer)e.getKey()).toString().equals(((String)e.getValue()).substring(0, 1))));
    }

    public void testObjAnyMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).anyMatch((SerializablePredicate & Serializable)e -> ((String)e.getValue()).endsWith("-value")));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).anyMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() % 2 == 0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).anyMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() < 10 && (Integer)e.getKey() >= 0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).anyMatch((SerializablePredicate & Serializable)e -> ((String)e.getValue()).equals("4-value")));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).anyMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() > 12));
    }

    public void testObjCollectorIntAverager() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)4.5, (Object)this.createStream((CacheCollection)entrySet).collect((SerializableSupplier & Serializable)() -> Collectors.averagingInt(Map.Entry::getKey)));
    }

    public void testObjCollectorIntStatistics() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        IntSummaryStatistics stats = (IntSummaryStatistics)this.createStream((CacheCollection)entrySet).collect((SerializableSupplier & Serializable)() -> Collectors.summarizingInt(Map.Entry::getKey));
        AssertJUnit.assertEquals((long)10L, (long)stats.getCount());
        AssertJUnit.assertEquals((Object)4.5, (Object)stats.getAverage());
        AssertJUnit.assertEquals((int)0, (int)stats.getMin());
        AssertJUnit.assertEquals((int)9, (int)stats.getMax());
        AssertJUnit.assertEquals((long)45L, (long)stats.getSum());
    }

    public void testObjCollectorGroupBy() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        ConcurrentMap grouped = (ConcurrentMap)this.createStream((CacheCollection)entrySet).collect((SerializableSupplier & Serializable)() -> Collectors.groupingByConcurrent(k -> (Integer)k.getKey() % 2 == 0));
        ((List)grouped.get(true)).parallelStream().forEach(e -> AssertJUnit.assertTrue(((Integer)e.getKey() % 2 == 0 ? 1 : 0) != 0));
        ((List)grouped.get(false)).parallelStream().forEach(e -> AssertJUnit.assertTrue(((Integer)e.getKey() % 2 == 1 ? 1 : 0) != 0));
    }

    public void testObjCollect() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        List list = (List)this.createStream((CacheCollection)entrySet).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        AssertJUnit.assertEquals((int)cache.size(), (int)list.size());
        list.parallelStream().forEach(e -> AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue())));
    }

    public void testObjSortedCollector() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        List list = (List)this.createStream((CacheCollection)entrySet).sorted((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).collect(Collectors::toList);
        AssertJUnit.assertEquals((int)cache.size(), (int)list.size());
        AtomicInteger i2 = new AtomicInteger();
        list.forEach(e -> {
            AssertJUnit.assertEquals((int)i2.getAndIncrement(), (int)((Integer)e.getKey()));
            AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue()));
        });
    }

    public void testObjCount() {
        Cache cache = this.getCache(0);
        int range = 12;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)range, (long)this.createStream((CacheCollection)entrySet).count());
    }

    public void testObjFindAny() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).filter((SerializablePredicate & Serializable)e -> ((String)e.getValue()).endsWith("-value")).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).filter((SerializablePredicate & Serializable)e -> (Integer)e.getKey() % 2 == 0).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).filter((SerializablePredicate & Serializable)e -> (Integer)e.getKey() < 10 && (Integer)e.getKey() >= 0).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).filter((SerializablePredicate & Serializable)e -> ((String)e.getValue()).equals("4-value")).findAny().isPresent());
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).filter((SerializablePredicate & Serializable)e -> (Integer)e.getKey() > 12).findAny().isPresent());
    }

    public void testObjFindFirst() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((int)0, (int)((Integer)((Map.Entry)this.createStream((CacheCollection)entrySet).sorted((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).findFirst().get()).getKey()));
    }

    public void testObjForEach() {
        Cache cache = this.getCache(0);
        int offset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).forEach((SerializableConsumer & Serializable)e -> {
                    AtomicInteger atomic = (AtomicInteger)BaseStreamTest.getForEachObject(offset);
                    atomic.addAndGet((Integer)e.getKey());
                });
                return ((AtomicInteger)BaseStreamTest.getForEachObject(offset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjForEachCacheInjected() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).forEach(new ForEachInjected(cacheOffset, atomicOffset, Map.Entry::getKey));
                return ((AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjForEachBiConsumer() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).forEach((SerializableBiConsumer & Serializable)(c, e) -> {
                    Cache localCache = (Cache)BaseStreamTest.getForEachObject(cacheOffset);
                    if (c != null && localCache != null && c.getName().equals(localCache.getName())) {
                        ((AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset)).addAndGet((Integer)e.getKey());
                    } else {
                        AssertJUnit.fail((String)"Did not receive correct cache!");
                    }
                });
                return ((AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjKeySetForEachCacheInjected() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream((CacheCollection)cache.keySet()).forEach(new ForEachInjected(cacheOffset, atomicOffset, Integer::intValue));
                return ((AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjValuesForEachCacheInjected() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream(cache.values()).forEach(new ForEachInjected(cacheOffset, atomicOffset, (SerializableToIntFunction & Serializable)e -> Integer.valueOf(e.substring(0, 1))));
                return ((AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjFlatMapForEach() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        int queueOffset = BaseStreamTest.populateNextForEachStructure(queue);
        try {
            this.createStream((CacheCollection)entrySet).distributedBatchSize(5).flatMap((SerializableFunction & Serializable)e -> Arrays.stream(((String)e.getValue()).split("a"))).forEach((SerializableConsumer & Serializable)e -> {
                Queue localQueue = (Queue)BaseStreamTest.getForEachObject(queueOffset);
                localQueue.add(e);
            });
            AssertJUnit.assertEquals((int)(range * 2), (int)queue.size());
            int lueCount = 0;
            for (String string : queue) {
                if (!string.equals("lue")) continue;
                ++lueCount;
            }
            AssertJUnit.assertEquals((int)10, (int)lueCount);
        }
        finally {
            BaseStreamTest.clearForEachObject(queueOffset);
        }
    }

    public void testObjForEachOrdered() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        ArrayList list = new ArrayList(range);
        this.createStream((CacheCollection)entrySet).sorted((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e2.getKey(), (Integer)e1.getKey())).forEachOrdered(list::add);
        AssertJUnit.assertEquals((int)range, (int)list.size());
        for (int i2 = 0; i2 < range; ++i2) {
            AssertJUnit.assertEquals((int)(range - i2 - 1), (int)((Integer)((Map.Entry)list.get(i2)).getKey()));
        }
    }

    public void testObjMax() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)9, ((Map.Entry)this.createStream((CacheCollection)entrySet).max((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).get()).getKey());
    }

    public void testObjMin() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)0, ((Map.Entry)this.createStream((CacheCollection)entrySet).min((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).get()).getKey());
    }

    public void testObjNoneMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).noneMatch((SerializablePredicate & Serializable)e -> ((String)e.getValue()).endsWith("-value")));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).noneMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() % 2 == 0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).noneMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() < 10 && (Integer)e.getKey() >= 0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).noneMatch((SerializablePredicate & Serializable)e -> ((Integer)e.getKey()).toString().equals(((String)e.getValue()).substring(0, 1))));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).noneMatch((SerializablePredicate & Serializable)e -> (Integer)e.getKey() > 12));
    }

    public void testObjReduce1() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Optional optional = this.createStream((CacheCollection)entrySet).reduce((SerializableBinaryOperator & Serializable)(e1, e2) -> new ImmortalCacheEntry((Object)((Integer)e1.getKey() + (Integer)e2.getKey()), (Object)((String)e1.getValue() + (String)e2.getValue())));
        AssertJUnit.assertTrue((boolean)optional.isPresent());
        Map.Entry result = (Map.Entry)optional.get();
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)((Integer)result.getKey()));
        AssertJUnit.assertEquals((int)(range * 7), (int)((String)result.getValue()).length());
    }

    public void testObjReduce2() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Map.Entry result = (Map.Entry)this.createStream((CacheCollection)entrySet).reduce((Object)new ImmortalCacheEntry((Object)0, (Object)""), (SerializableBinaryOperator & Serializable)(e1, e2) -> new ImmortalCacheEntry((Object)((Integer)e1.getKey() + (Integer)e2.getKey()), (Object)((String)e1.getValue() + (String)e2.getValue())));
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)((Integer)result.getKey()));
        AssertJUnit.assertEquals((int)(range * 7), (int)((String)result.getValue()).length());
    }

    public void testObjReduce2WithMap() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Integer result = (Integer)this.createStream((CacheCollection)entrySet).map(Map.Entry::getKey).reduce((Object)0, (SerializableBinaryOperator & Serializable)(e1, e2) -> e1 + e2);
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)result);
    }

    public void testObjReduce3() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Integer result = (Integer)this.createStream((CacheCollection)entrySet).reduce((Object)0, (SerializableBiFunction & Serializable)(e1, e2) -> e1 + (Integer)e2.getKey(), (SerializableBinaryOperator & Serializable)(i1, i2) -> i1 + i2);
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)result);
    }

    public void testObjIterator() {
        Cache cache = this.getCache(0);
        this.testIntOperation(() -> {
            Iterator iterator = this.createStream((CacheCollection)cache.entrySet()).iterator();
            AtomicInteger count = new AtomicInteger();
            iterator.forEachRemaining(e -> {
                AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue()));
                count.addAndGet((Integer)e.getKey());
            });
            return count.get();
        }, cache);
    }

    public void testObjSortedIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Iterator iterator = this.createStream((CacheCollection)entrySet).sorted((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).iterator();
        AtomicInteger i2 = new AtomicInteger();
        iterator.forEachRemaining(e -> {
            AssertJUnit.assertEquals((int)i2.getAndIncrement(), (int)((Integer)e.getKey()));
            AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue()));
        });
    }

    public void testObjMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Iterator iterator = this.createStream((CacheCollection)entrySet).map(Map.Entry::getValue).iterator();
        HashSet set = new HashSet(range);
        iterator.forEachRemaining(set::add);
        AssertJUnit.assertEquals((int)range, (int)set.size());
        IntStream.range(0, range).forEach(i -> AssertJUnit.assertTrue((boolean)set.contains(i + "-value")));
    }

    public void testObjFlatMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        TreeMap keysBySegment = log.isTraceEnabled() ? new TreeMap() : null;
        KeyPartitioner kp = TestingUtil.extractComponent(cache, KeyPartitioner.class);
        IntStream.range(0, range).boxed().forEach(i -> {
            if (keysBySegment != null) {
                int segment = kp.getSegment(i);
                IntSet keys = keysBySegment.computeIfAbsent(segment, IntSets::mutableEmptySet);
                keys.set(i.intValue());
            }
            cache.put(i, (Object)(i + "-value" + i));
        });
        if (keysBySegment != null) {
            log.tracef("Keys by segment are: " + keysBySegment, new Object[0]);
        }
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        StringJoiner stringJoiner = new StringJoiner(" ");
        int explosionCount = 293;
        for (int i2 = 0; i2 < explosionCount; ++i2) {
            stringJoiner.add("special-" + String.valueOf(i2));
        }
        String specialString = stringJoiner.toString();
        Iterator iterator = this.createStream((CacheCollection)entrySet).distributedBatchSize(1).flatMap((SerializableFunction & Serializable)e -> {
            if ((Integer)e.getKey() == 2) {
                return Stream.empty();
            }
            if ((Integer)e.getKey() == 5) {
                return Arrays.stream(specialString.split(" "));
            }
            return Arrays.stream(((String)e.getValue()).split("a"));
        }).iterator();
        ArrayList list = new ArrayList(range * 2);
        iterator.forEachRemaining(list::add);
        if (keysBySegment != null) {
            log.tracef("Returned values are: %s", list);
        }
        AssertJUnit.assertEquals((int)((range - 2) * 2 + explosionCount), (int)list.size());
    }

    public void testObjToArray1() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Object[] array = this.createStream((CacheCollection)entrySet).toArray();
        AssertJUnit.assertEquals((int)cache.size(), (int)array.length);
        Spliterator spliterator = Spliterators.spliterator(array, 257);
        StreamSupport.stream(spliterator, false).forEach(e -> AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue())));
    }

    public void testObjToArray2() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Object[] array = (Map.Entry[])this.createStream((CacheCollection)entrySet).toArray(Map.Entry[]::new);
        AssertJUnit.assertEquals((int)cache.size(), (int)array.length);
        Spliterator spliterator = Spliterators.spliterator(array, 257);
        StreamSupport.stream(spliterator, false).forEach(e -> AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue())));
    }

    public void testObjSortedSkipIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 0; i2 < range; ++i2) {
            Iterator iterator = this.createStream((CacheCollection)entrySet).sorted((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).skip((long)i2).iterator();
            AtomicInteger atomicInteger = new AtomicInteger(i2);
            iterator.forEachRemaining(e -> {
                AssertJUnit.assertEquals((int)atomicInteger.getAndIncrement(), (int)((Integer)e.getKey()));
                AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue()));
            });
            AssertJUnit.assertEquals((int)range, (int)atomicInteger.get());
        }
    }

    public void testObjSortedLimitIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 1; i2 < range; ++i2) {
            Iterator iterator = this.createStream((CacheCollection)entrySet).sorted((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).limit((long)i2).iterator();
            AtomicInteger atomicInteger = new AtomicInteger();
            iterator.forEachRemaining(e -> {
                AssertJUnit.assertEquals((int)atomicInteger.getAndIncrement(), (int)((Integer)e.getKey()));
                AssertJUnit.assertEquals((String)((String)cache.get(e.getKey())), (String)((String)e.getValue()));
            });
            AssertJUnit.assertEquals((int)i2, (int)atomicInteger.get());
        }
    }

    public void testObjPointlessSortMap() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        IntSummaryStatistics stats = this.createStream((CacheCollection)entrySet).sorted((SerializableComparator & Serializable)(e1, e2) -> Integer.compare((Integer)e1.getKey(), (Integer)e2.getKey())).mapToInt(Map.Entry::getKey).summaryStatistics();
        AssertJUnit.assertEquals((long)range, (long)stats.getCount());
        AssertJUnit.assertEquals((int)0, (int)stats.getMin());
        AssertJUnit.assertEquals((int)9, (int)stats.getMax());
    }

    public void testIntAllMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).allMatch((SerializableIntPredicate & Serializable)i -> i % 2 == 0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).allMatch((SerializableIntPredicate & Serializable)i -> i > 10 && i < 0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).allMatch((SerializableIntPredicate & Serializable)i -> i < 12));
    }

    public void testIntAnyMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).anyMatch((SerializableIntPredicate & Serializable)i -> i % 2 == 0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).anyMatch((SerializableIntPredicate & Serializable)i -> i > 10 && i < 0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).anyMatch((SerializableIntPredicate & Serializable)i -> i < 12));
    }

    public void testIntAverage() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)4.5, (Object)this.createStream((CacheCollection)entrySet).mapToInt(toInt).average().getAsDouble());
    }

    public void testIntCollect() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        HashSet set = (HashSet)this.createStream((CacheCollection)entrySet).mapToInt(toInt).collect(HashSet::new, Set::add, Set::addAll);
        AssertJUnit.assertEquals((int)10, (int)set.size());
    }

    public void testIntCount() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)10L, (long)this.createStream((CacheCollection)entrySet).mapToInt(toInt).count());
    }

    public void testIntFindAny() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).filter((SerializableIntPredicate & Serializable)e -> e % 2 == 0).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).filter((SerializableIntPredicate & Serializable)e -> e < 10 && e >= 0).findAny().isPresent());
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).filter((SerializableIntPredicate & Serializable)e -> e > 12).findAny().isPresent());
    }

    public void testIntFindFirst() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((int)0, (int)this.createStream((CacheCollection)entrySet).mapToInt(toInt).sorted().findFirst().getAsInt());
    }

    public void testIntForEach() {
        Cache cache = this.getCache(0);
        int offset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToInt(toInt).forEach((SerializableIntConsumer & Serializable)e -> {
                    AtomicInteger atomic = (AtomicInteger)BaseStreamTest.getForEachObject(offset);
                    atomic.addAndGet(e);
                });
                return ((AtomicInteger)BaseStreamTest.getForEachObject(offset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIntFlatMapForEach() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int offset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.createStream((CacheCollection)entrySet).distributedBatchSize(5).mapToInt(toInt).flatMap((SerializableIntFunction & Serializable)i -> IntStream.of(i, 2)).forEach((SerializableIntConsumer & Serializable)e -> {
                AtomicInteger atomic = (AtomicInteger)BaseStreamTest.getForEachObject(offset);
                atomic.addAndGet(e);
            });
            AtomicInteger atomic = (AtomicInteger)BaseStreamTest.getForEachObject(offset);
            AssertJUnit.assertEquals((int)((range - 1) * (range / 2) + 2 * range), (int)atomic.get());
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    public void testIntForEachOrdered() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        ArrayList list = new ArrayList(range);
        this.createStream((CacheCollection)entrySet).mapToInt(toInt).sorted().forEachOrdered(list::add);
        AssertJUnit.assertEquals((int)range, (int)list.size());
        for (int i2 = 0; i2 < range; ++i2) {
            AssertJUnit.assertEquals((int)i2, (int)((Integer)list.get(i2)));
        }
    }

    private void testIntOperation(Supplier<Integer> intSupplier, Cache<Integer, String> cache) {
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)intSupplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIntForEachCacheInjected() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToInt(toInt).forEach((IntConsumer)new ForEachIntInjected(cacheOffset, atomicOffset));
                return ((AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIntForEachBiConsumer() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.testIntOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToInt(toInt).forEach((SerializableObjIntConsumer & Serializable)(c, i) -> {
                    Cache localCache = (Cache)BaseStreamTest.getForEachObject(cacheOffset);
                    if (c != null && localCache != null && c.getName().equals(localCache.getName())) {
                        AtomicInteger atomicInteger = (AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset);
                        atomicInteger.addAndGet(i);
                    }
                });
                return ((AtomicInteger)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIntFlatMapObjConsumerForEach() {
        Cache cache = this.getCache(0);
        String cacheName = cache.getName();
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int offset = BaseStreamTest.populateNextForEachStructure(new AtomicInteger());
        try {
            this.createStream((CacheCollection)entrySet).distributedBatchSize(5).mapToInt(toInt).flatMap((SerializableIntFunction & Serializable)i -> IntStream.of(i, 2)).forEach((SerializableObjIntConsumer & Serializable)(c, e) -> {
                AssertJUnit.assertEquals((String)cacheName, (String)c.getName());
                AtomicInteger atomic = (AtomicInteger)BaseStreamTest.getForEachObject(offset);
                atomic.addAndGet(e);
            });
            AtomicInteger atomic = (AtomicInteger)BaseStreamTest.getForEachObject(offset);
            AssertJUnit.assertEquals((int)((range - 1) * (range / 2) + 2 * range), (int)atomic.get());
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    public void testIntIterator() {
        Cache cache = this.getCache(0);
        this.testIntOperation(() -> {
            PrimitiveIterator.OfInt iterator = this.createStream((CacheCollection)cache.entrySet()).mapToInt(toInt).iterator();
            AtomicInteger count = new AtomicInteger();
            iterator.forEachRemaining(e -> {
                AssertJUnit.assertTrue((boolean)cache.containsKey((Object)e));
                count.addAndGet(e);
            });
            return count.get();
        }, cache);
    }

    public void testIntSortedIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        PrimitiveIterator.OfInt iterator = this.createStream((CacheCollection)entrySet).mapToInt(toInt).sorted().iterator();
        AtomicLong i2 = new AtomicLong();
        iterator.forEachRemaining(e -> AssertJUnit.assertEquals((long)i2.getAndIncrement(), (long)e));
    }

    public void testIntFlatMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        PrimitiveIterator.OfInt iterator = this.createStream((CacheCollection)entrySet).flatMapToInt((SerializableFunction & Serializable)e -> IntStream.of((Integer)e.getKey(), ((String)e.getValue()).length())).iterator();
        int pos = 0;
        int halfCount = 0;
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            ++pos;
            if (next == 7) {
                ++halfCount;
            }
            AssertJUnit.assertTrue((boolean)cache.containsKey((Object)next));
        }
        AssertJUnit.assertEquals((int)(range + 1), (int)halfCount);
        AssertJUnit.assertEquals((int)(range * 2), (int)pos);
    }

    public void testIntNoneMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).noneMatch((SerializableIntPredicate & Serializable)i -> i % 2 == 0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).noneMatch((SerializableIntPredicate & Serializable)i -> i > 10 && i < 0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToInt(toInt).noneMatch((SerializableIntPredicate & Serializable)i -> i < 12));
    }

    public void testIntReduce1() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((int)0, (int)this.createStream((CacheCollection)entrySet).mapToInt(toInt).reduce(1, (SerializableIntBinaryOperator & Serializable)(i1, i2) -> i1 * i2));
        AssertJUnit.assertEquals((int)362880, (int)this.createStream((CacheCollection)entrySet).mapToInt(toInt).filter((SerializableIntPredicate & Serializable)i -> i != 0).reduce(1, (SerializableIntBinaryOperator & Serializable)(i1, i2) -> i1 * i2));
    }

    public void testIntReduce2() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((int)0, (int)this.createStream((CacheCollection)entrySet).mapToInt(toInt).reduce((SerializableIntBinaryOperator & Serializable)(i1, i2) -> i1 * i2).getAsInt());
        AssertJUnit.assertEquals((int)362880, (int)this.createStream((CacheCollection)entrySet).mapToInt(toInt).filter((SerializableIntPredicate & Serializable)i -> i != 0).reduce((SerializableIntBinaryOperator & Serializable)(i1, i2) -> i1 * i2).getAsInt());
    }

    public void testIntSummaryStatistics() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        IntSummaryStatistics statistics = this.createStream((CacheCollection)entrySet).mapToInt(toInt).summaryStatistics();
        AssertJUnit.assertEquals((int)0, (int)statistics.getMin());
        AssertJUnit.assertEquals((int)9, (int)statistics.getMax());
        AssertJUnit.assertEquals((Object)4.5, (Object)statistics.getAverage());
        AssertJUnit.assertEquals((long)((range - 1) * (range / 2)), (long)statistics.getSum());
        AssertJUnit.assertEquals((long)10L, (long)statistics.getCount());
    }

    public void testIntToArray() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int[] array = this.createStream((CacheCollection)entrySet).mapToInt(toInt).toArray();
        AssertJUnit.assertEquals((int)cache.size(), (int)array.length);
        Spliterator.OfInt spliterator = Spliterators.spliterator(array, 1);
        StreamSupport.intStream(spliterator, true).forEach(e -> AssertJUnit.assertTrue((boolean)cache.containsKey((Object)e)));
    }

    public void testIntSum() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int result = this.createStream((CacheCollection)entrySet).mapToInt(toInt).sum();
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)result);
    }

    public void testIntMax() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((int)9, (int)this.createStream((CacheCollection)entrySet).mapToInt(toInt).max().getAsInt());
    }

    public void testIntMin() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((int)0, (int)this.createStream((CacheCollection)entrySet).mapToInt(toInt).min().getAsInt());
    }

    public void testIntSortedSkip() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).forEach(i -> cache.put((Object)i, (Object)(i + "-value")));
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 0; i2 < range; ++i2) {
            IntSummaryStatistics stats = this.createStream((CacheCollection)entrySet).mapToInt(toInt).sorted().skip((long)i2).summaryStatistics();
            AssertJUnit.assertEquals((long)(range - i2), (long)stats.getCount());
            AssertJUnit.assertEquals((int)i2, (int)stats.getMin());
            AssertJUnit.assertEquals((int)(range - 1), (int)stats.getMax());
            AssertJUnit.assertEquals((long)IntStream.range(i2, range).sum(), (long)stats.getSum());
        }
    }

    public void testIntSortedLimit() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).forEach(i -> cache.put((Object)i, (Object)(i + "-value")));
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 1; i2 < range; ++i2) {
            IntSummaryStatistics stats = this.createStream((CacheCollection)entrySet).mapToInt(toInt).sorted().limit((long)i2).summaryStatistics();
            AssertJUnit.assertEquals((long)i2, (long)stats.getCount());
            AssertJUnit.assertEquals((int)0, (int)stats.getMin());
            AssertJUnit.assertEquals((int)(i2 - 1), (int)stats.getMax());
            AssertJUnit.assertEquals((long)IntStream.range(0, i2).sum(), (long)stats.getSum());
        }
    }

    public void testLongAllMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).allMatch((SerializableLongPredicate & Serializable)i -> i % 2L == 0L));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).allMatch((SerializableLongPredicate & Serializable)i -> i > 10L && i < 0L));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).allMatch((SerializableLongPredicate & Serializable)i -> i < 12L));
    }

    public void testLongAnyMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).anyMatch((SerializableLongPredicate & Serializable)i -> i % 2L == 0L));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).anyMatch((SerializableLongPredicate & Serializable)i -> i > 10L && i < 0L));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).anyMatch((SerializableLongPredicate & Serializable)i -> i < 12L));
    }

    public void testLongAverage() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)4.5, (Object)this.createStream((CacheCollection)entrySet).mapToLong(toLong).average().getAsDouble());
    }

    public void testLongCollect() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        HashSet set = (HashSet)this.createStream((CacheCollection)entrySet).mapToLong(toLong).collect(HashSet::new, Set::add, Set::addAll);
        AssertJUnit.assertEquals((int)10, (int)set.size());
    }

    public void testLongCount() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)10L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).count());
    }

    public void testLongFindAny() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).filter((SerializableLongPredicate & Serializable)e -> e % 2L == 0L).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).filter((SerializableLongPredicate & Serializable)e -> e < 10L && e >= 0L).findAny().isPresent());
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).filter((SerializableLongPredicate & Serializable)e -> e > 12L).findAny().isPresent());
    }

    public void testLongFindFirst() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)0L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).sorted().findFirst().getAsLong());
    }

    public void testLongForEach() {
        Cache cache = this.getCache(0);
        int offset = BaseStreamTest.populateNextForEachStructure(new AtomicLong());
        try {
            this.testLongOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToLong(toLong).forEach((SerializableLongConsumer & Serializable)e -> {
                    AtomicLong atomic = (AtomicLong)BaseStreamTest.getForEachObject(offset);
                    atomic.addAndGet(e);
                });
                return ((AtomicLong)BaseStreamTest.getForEachObject(offset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongFlatMapForEach() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int offset = BaseStreamTest.populateNextForEachStructure(new AtomicLong());
        try {
            this.createStream((CacheCollection)entrySet).distributedBatchSize(5).mapToLong(toLong).flatMap((SerializableLongFunction & Serializable)i -> LongStream.of(i, 2L)).forEach((SerializableLongConsumer & Serializable)e -> {
                AtomicLong atomic = (AtomicLong)BaseStreamTest.getForEachObject(offset);
                atomic.addAndGet(e);
            });
            AtomicLong atomic = (AtomicLong)BaseStreamTest.getForEachObject(offset);
            AssertJUnit.assertEquals((long)((range - 1) * (range / 2) + 2 * range), (long)atomic.get());
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    public void testLongForEachOrdered() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        ArrayList list = new ArrayList(range);
        this.createStream((CacheCollection)entrySet).mapToLong(toLong).sorted().forEachOrdered(list::add);
        AssertJUnit.assertEquals((int)range, (int)list.size());
        for (int i2 = 0; i2 < range; ++i2) {
            AssertJUnit.assertEquals((long)i2, (long)((Long)list.get(i2)));
        }
    }

    private void testLongOperation(Supplier<Long> longSupplier, Cache<Long, String> cache) {
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        AssertJUnit.assertEquals((long)((range - 1) * (range / 2)), (long)longSupplier.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongForEachCacheInjected() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicLong());
        try {
            this.testLongOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToLong(toLong).forEach((LongConsumer)new ForEachLongInjected(cacheOffset, atomicOffset));
                return ((AtomicLong)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongForEachBiConsumer() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int atomicOffset = BaseStreamTest.populateNextForEachStructure(new AtomicLong());
        try {
            this.testLongOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToLong(toLong).forEach((SerializableObjLongConsumer & Serializable)(c, i) -> {
                    Cache localCache = (Cache)BaseStreamTest.getForEachObject(cacheOffset);
                    if (c != null && localCache != null && c.getName().equals(localCache.getName())) {
                        AtomicLong atomicLong = (AtomicLong)BaseStreamTest.getForEachObject(atomicOffset);
                        atomicLong.addAndGet(i);
                    }
                });
                return ((AtomicLong)BaseStreamTest.getForEachObject(atomicOffset)).get();
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(atomicOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongFlatMapObjConsumerForEach() {
        Cache cache = this.getCache(0);
        String cacheName = cache.getName();
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int offset = BaseStreamTest.populateNextForEachStructure(new AtomicLong());
        try {
            this.createStream((CacheCollection)entrySet).distributedBatchSize(5).mapToLong(toLong).flatMap((SerializableLongFunction & Serializable)i -> LongStream.of(i, 2L)).forEach((SerializableObjLongConsumer & Serializable)(c, e) -> {
                AssertJUnit.assertEquals((String)cacheName, (String)c.getName());
                AtomicLong atomic = (AtomicLong)BaseStreamTest.getForEachObject(offset);
                atomic.addAndGet(e);
            });
            AtomicLong atomic = (AtomicLong)BaseStreamTest.getForEachObject(offset);
            AssertJUnit.assertEquals((long)((range - 1) * (range / 2) + 2 * range), (long)atomic.get());
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    public void testLongIterator() {
        Cache cache = this.getCache(0);
        this.testLongOperation(() -> {
            PrimitiveIterator.OfLong iterator = this.createStream((CacheCollection)cache.entrySet()).mapToLong(toLong).iterator();
            AtomicLong count = new AtomicLong();
            iterator.forEachRemaining(e -> {
                AssertJUnit.assertTrue((boolean)cache.containsKey((Object)e));
                count.addAndGet(e);
            });
            return count.get();
        }, cache);
    }

    public void testLongSortedIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        PrimitiveIterator.OfLong iterator = this.createStream((CacheCollection)entrySet).mapToLong(toLong).sorted().iterator();
        AtomicLong i2 = new AtomicLong();
        iterator.forEachRemaining(e -> AssertJUnit.assertEquals((long)i2.getAndIncrement(), (long)e));
    }

    public void testLongFlatMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        PrimitiveIterator.OfLong iterator = this.createStream((CacheCollection)entrySet).flatMapToLong((SerializableFunction & Serializable)e -> LongStream.of((Long)e.getKey(), ((String)e.getValue()).length())).iterator();
        int pos = 0;
        int halfCount = 0;
        while (iterator.hasNext()) {
            long next = iterator.nextLong();
            ++pos;
            if (next == 7L) {
                ++halfCount;
            }
            AssertJUnit.assertTrue((boolean)cache.containsKey((Object)next));
        }
        AssertJUnit.assertEquals((int)(range + 1), (int)halfCount);
        AssertJUnit.assertEquals((int)(range * 2), (int)pos);
    }

    public void testLongNoneMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).noneMatch((SerializableLongPredicate & Serializable)i -> i % 2L == 0L));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).noneMatch((SerializableLongPredicate & Serializable)i -> i > 10L && i < 0L));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToLong(toLong).noneMatch((SerializableLongPredicate & Serializable)i -> i < 12L));
    }

    public void testLongReduce1() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)0L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).reduce(1L, (SerializableLongBinaryOperator & Serializable)(i1, i2) -> i1 * i2));
        AssertJUnit.assertEquals((long)362880L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).filter((SerializableLongPredicate & Serializable)i -> i != 0L).reduce(1L, (SerializableLongBinaryOperator & Serializable)(i1, i2) -> i1 * i2));
    }

    public void testLongReduce2() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)0L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).reduce((SerializableLongBinaryOperator & Serializable)(i1, i2) -> i1 * i2).getAsLong());
        AssertJUnit.assertEquals((long)362880L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).filter((SerializableLongPredicate & Serializable)i -> i != 0L).reduce((SerializableLongBinaryOperator & Serializable)(i1, i2) -> i1 * i2).getAsLong());
    }

    public void testLongSummaryStatistics() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        LongSummaryStatistics statistics = this.createStream((CacheCollection)entrySet).mapToLong(toLong).summaryStatistics();
        AssertJUnit.assertEquals((long)0L, (long)statistics.getMin());
        AssertJUnit.assertEquals((long)9L, (long)statistics.getMax());
        AssertJUnit.assertEquals((Object)4.5, (Object)statistics.getAverage());
        AssertJUnit.assertEquals((long)((range - 1) * (range / 2)), (long)statistics.getSum());
        AssertJUnit.assertEquals((long)10L, (long)statistics.getCount());
    }

    public void testLongToArray() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        long[] array = this.createStream((CacheCollection)entrySet).mapToLong(toLong).toArray();
        AssertJUnit.assertEquals((int)cache.size(), (int)array.length);
        Spliterator.OfLong spliterator = Spliterators.spliterator(array, 1);
        StreamSupport.longStream(spliterator, true).forEach(e -> AssertJUnit.assertTrue((boolean)cache.containsKey((Object)e)));
    }

    public void testLongSum() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        long result = this.createStream((CacheCollection)entrySet).mapToLong(toLong).sum();
        AssertJUnit.assertEquals((long)((range - 1) * (range / 2)), (long)result);
    }

    public void testLongMax() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)9L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).max().getAsLong());
    }

    public void testLongMin() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)0L, (long)this.createStream((CacheCollection)entrySet).mapToLong(toLong).min().getAsLong());
    }

    public void testLongSortedSkip() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).forEach(i -> cache.put((Object)i, (Object)(i + "-value")));
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 0; i2 < range; ++i2) {
            LongSummaryStatistics stats = this.createStream((CacheCollection)entrySet).mapToLong(toLong).sorted().skip((long)i2).summaryStatistics();
            AssertJUnit.assertEquals((long)(range - i2), (long)stats.getCount());
            AssertJUnit.assertEquals((long)i2, (long)stats.getMin());
            AssertJUnit.assertEquals((long)(range - 1), (long)stats.getMax());
            AssertJUnit.assertEquals((long)IntStream.range(i2, range).sum(), (long)stats.getSum());
        }
    }

    public void testLongSortedLimit() {
        Cache cache = this.getCache(0);
        int range = 10;
        LongStream.range(0L, range).forEach(i -> cache.put((Object)i, (Object)(i + "-value")));
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 1; i2 < range; ++i2) {
            LongSummaryStatistics stats = this.createStream((CacheCollection)entrySet).mapToLong(toLong).sorted().limit((long)i2).summaryStatistics();
            AssertJUnit.assertEquals((long)i2, (long)stats.getCount());
            AssertJUnit.assertEquals((long)0L, (long)stats.getMin());
            AssertJUnit.assertEquals((long)(i2 - 1), (long)stats.getMax());
            AssertJUnit.assertEquals((long)IntStream.range(0, i2).sum(), (long)stats.getSum());
        }
    }

    public void testDoubleAllMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).allMatch((SerializableDoublePredicate & Serializable)i -> i % 2.0 == 0.0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).allMatch((SerializableDoublePredicate & Serializable)i -> i > 5.0 && i < 0.0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).allMatch((SerializableDoublePredicate & Serializable)i -> i < 5.0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).allMatch((SerializableDoublePredicate & Serializable)i -> Math.floor(i) == i));
    }

    public void testDoubleAnyMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).anyMatch((SerializableDoublePredicate & Serializable)i -> i % 2.0 == 0.0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).anyMatch((SerializableDoublePredicate & Serializable)i -> i > 5.0 && i < 0.0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).anyMatch((SerializableDoublePredicate & Serializable)i -> i < 5.0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).anyMatch((SerializableDoublePredicate & Serializable)i -> Math.floor(i) == i));
    }

    public void testDoubleAverage() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)2.25, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).average().getAsDouble());
    }

    public void testDoubleCollect() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        HashSet set = (HashSet)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).collect(HashSet::new, Set::add, Set::addAll);
        AssertJUnit.assertEquals((int)10, (int)set.size());
    }

    public void testDoubleCount() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((long)10L, (long)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).count());
    }

    public void testDoubleFindAny() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).filter((SerializableDoublePredicate & Serializable)e -> e % 2.0 == 0.0).findAny().isPresent());
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).filter((SerializableDoublePredicate & Serializable)e -> e < 5.0 && e >= 0.0).findAny().isPresent());
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).filter((SerializableDoublePredicate & Serializable)e -> e > 5.0).findAny().isPresent());
    }

    public void testDoubleFindFirst() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)0.0, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).sorted().findFirst().getAsDouble());
    }

    public void testDoubleForEach() {
        Cache cache = this.getCache(0);
        int offset = BaseStreamTest.populateNextForEachStructure(new DoubleSummaryStatistics());
        try {
            this.testDoubleOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToDouble(toDouble).forEach((SerializableDoubleConsumer & Serializable)e -> {
                    DoubleSummaryStatistics stats;
                    DoubleSummaryStatistics doubleSummaryStatistics = stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
                    synchronized (doubleSummaryStatistics) {
                        stats.accept(e);
                    }
                });
                return (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleFlatMapForEach() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int offset = BaseStreamTest.populateNextForEachStructure(new DoubleSummaryStatistics());
        try {
            this.createStream((CacheCollection)entrySet).distributedBatchSize(5).mapToDouble(toDouble).flatMap((SerializableDoubleFunction & Serializable)e -> DoubleStream.of(e, 2.25)).forEach((SerializableDoubleConsumer & Serializable)e -> {
                DoubleSummaryStatistics stats;
                DoubleSummaryStatistics doubleSummaryStatistics = stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
                synchronized (doubleSummaryStatistics) {
                    stats.accept(e);
                }
            });
            DoubleSummaryStatistics stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
            AssertJUnit.assertEquals((Object)2.25, (Object)stats.getAverage());
            AssertJUnit.assertEquals((Object)0.0, (Object)stats.getMin());
            AssertJUnit.assertEquals((Object)4.5, (Object)stats.getMax());
            AssertJUnit.assertEquals((long)20L, (long)stats.getCount());
            AssertJUnit.assertEquals((Object)45.0, (Object)stats.getSum());
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    public void testDoubleForEachOrdered() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        ArrayList list = new ArrayList(range);
        this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).sorted().forEachOrdered(list::add);
        AssertJUnit.assertEquals((int)range, (int)list.size());
        for (int i2 = 0; i2 < range; ++i2) {
            AssertJUnit.assertEquals((Object)((double)i2 / 2.0), list.get(i2));
        }
    }

    private void testDoubleOperation(Supplier<DoubleSummaryStatistics> statisticsSupplier, Cache<Double, String> cache) {
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        DoubleSummaryStatistics stats = statisticsSupplier.get();
        AssertJUnit.assertEquals((Object)2.25, (Object)stats.getAverage());
        AssertJUnit.assertEquals((Object)0.0, (Object)stats.getMin());
        AssertJUnit.assertEquals((Object)4.5, (Object)stats.getMax());
        AssertJUnit.assertEquals((long)10L, (long)stats.getCount());
        AssertJUnit.assertEquals((Object)22.5, (Object)stats.getSum());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleForEachCacheInjected() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int offset = BaseStreamTest.populateNextForEachStructure(new DoubleSummaryStatistics());
        try {
            this.testDoubleOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToDouble(toDouble).forEach(new ForEachDoubleInjected(cacheOffset, offset));
                return (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleForEachBiConsumer() {
        Cache cache = this.getCache(0);
        int cacheOffset = BaseStreamTest.populateNextForEachStructure(cache);
        int offset = BaseStreamTest.populateNextForEachStructure(new DoubleSummaryStatistics());
        try {
            this.testDoubleOperation(() -> {
                this.createStream((CacheCollection)cache.entrySet()).mapToDouble(toDouble).forEach((SerializableObjDoubleConsumer & Serializable)(c, d) -> {
                    Cache localCache = (Cache)BaseStreamTest.getForEachObject(cacheOffset);
                    if (c != null && localCache != null && c.getName().equals(localCache.getName())) {
                        DoubleSummaryStatistics stats;
                        DoubleSummaryStatistics doubleSummaryStatistics = stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
                        synchronized (doubleSummaryStatistics) {
                            stats.accept(d);
                        }
                    }
                });
                DoubleSummaryStatistics stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
                return stats;
            }, cache);
        }
        finally {
            BaseStreamTest.clearForEachObject(cacheOffset);
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleFlatMapObjConsumerForEach() {
        Cache cache = this.getCache(0);
        String cacheName = cache.getName();
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int offset = BaseStreamTest.populateNextForEachStructure(new DoubleSummaryStatistics());
        try {
            this.createStream((CacheCollection)entrySet).distributedBatchSize(5).mapToDouble(toDouble).flatMap((SerializableDoubleFunction & Serializable)e -> DoubleStream.of(e, 2.25)).forEach((SerializableObjDoubleConsumer & Serializable)(c, e) -> {
                DoubleSummaryStatistics stats;
                AssertJUnit.assertEquals((String)cacheName, (String)c.getName());
                DoubleSummaryStatistics doubleSummaryStatistics = stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
                synchronized (doubleSummaryStatistics) {
                    stats.accept(e);
                }
            });
            DoubleSummaryStatistics stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(offset);
            AssertJUnit.assertEquals((Object)2.25, (Object)stats.getAverage());
            AssertJUnit.assertEquals((Object)0.0, (Object)stats.getMin());
            AssertJUnit.assertEquals((Object)4.5, (Object)stats.getMax());
            AssertJUnit.assertEquals((long)20L, (long)stats.getCount());
            AssertJUnit.assertEquals((Object)45.0, (Object)stats.getSum());
        }
        finally {
            BaseStreamTest.clearForEachObject(offset);
        }
    }

    public void testDoubleIterator() {
        Cache cache = this.getCache(0);
        this.testDoubleOperation(() -> {
            PrimitiveIterator.OfDouble iterator = this.createStream((CacheCollection)cache.entrySet()).mapToDouble(toDouble).iterator();
            DoubleSummaryStatistics doubleSummaryStatistics = new DoubleSummaryStatistics();
            iterator.forEachRemaining(e -> {
                AssertJUnit.assertTrue((boolean)cache.containsKey((Object)e));
                doubleSummaryStatistics.accept(e);
            });
            return doubleSummaryStatistics;
        }, cache);
    }

    public void testDoubleSortedIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        PrimitiveIterator.OfDouble iterator = this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).sorted().iterator();
        AtomicInteger i2 = new AtomicInteger();
        iterator.forEachRemaining(e -> AssertJUnit.assertEquals((Object)((double)i2.getAndIncrement() / 2.0), (Object)e));
    }

    public void testDoubleFlatMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        PrimitiveIterator.OfDouble iterator = this.createStream((CacheCollection)entrySet).flatMapToDouble((SerializableFunction & Serializable)e -> DoubleStream.of((Double)e.getKey(), 0.5)).iterator();
        int pos = 0;
        int halfCount = 0;
        while (iterator.hasNext()) {
            double next = iterator.nextDouble();
            ++pos;
            if (next == 0.5) {
                ++halfCount;
            }
            AssertJUnit.assertTrue((boolean)cache.containsKey((Object)next));
        }
        AssertJUnit.assertEquals((int)(range + 1), (int)halfCount);
        AssertJUnit.assertEquals((int)(range * 2), (int)pos);
    }

    public void testDoubleNoneMatch() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).noneMatch((SerializableDoublePredicate & Serializable)i -> i % 2.0 == 0.0));
        AssertJUnit.assertTrue((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).noneMatch((SerializableDoublePredicate & Serializable)i -> i > 5.0 && i < 0.0));
        AssertJUnit.assertFalse((boolean)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).noneMatch((SerializableDoublePredicate & Serializable)i -> i < 5.0));
    }

    public void testDoubleReduce1() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)0.0, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).reduce(1.0, (SerializableDoubleBinaryOperator & Serializable)(i1, i2) -> i1 * i2));
        AssertJUnit.assertEquals((Object)708.75, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).filter((SerializableDoublePredicate & Serializable)i -> i != 0.0).reduce(1.0, (SerializableDoubleBinaryOperator & Serializable)(i1, i2) -> i1 * i2));
    }

    public void testDoubleReduce2() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)0.0, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).reduce((SerializableDoubleBinaryOperator & Serializable)(i1, i2) -> i1 * i2).getAsDouble());
        AssertJUnit.assertEquals((Object)708.75, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).filter((SerializableDoublePredicate & Serializable)i -> i != 0.0).reduce((SerializableDoubleBinaryOperator & Serializable)(i1, i2) -> i1 * i2).getAsDouble());
    }

    public void testDoubleSummaryStatistics() {
        Cache cache = this.getCache(0);
        this.testDoubleOperation(() -> this.createStream((CacheCollection)cache.entrySet()).mapToDouble(toDouble).summaryStatistics(), cache);
    }

    public void testDoubleToArray() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        double[] array = this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).toArray();
        AssertJUnit.assertEquals((int)cache.size(), (int)array.length);
        Spliterator.OfDouble spliterator = Spliterators.spliterator(array, 1);
        StreamSupport.doubleStream(spliterator, true).forEach(e -> AssertJUnit.assertTrue((boolean)cache.containsKey((Object)e)));
    }

    public void testDoubleSum() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        double result = this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).sum();
        AssertJUnit.assertEquals((Object)((double)(range - 1) * (double)(range / 2) / 2.0), (Object)result);
    }

    public void testDoubleMax() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)4.5, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).max().getAsDouble());
    }

    public void testDoubleMin() {
        Cache cache = this.getCache(0);
        int range = 10;
        DoubleStream.iterate(0.0, d -> d + 0.5).limit(10L).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        AssertJUnit.assertEquals((Object)0.0, (Object)this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).min().getAsDouble());
    }

    public void testDoubleSortedSkip() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).mapToDouble(value -> value).forEach(i -> cache.put((Object)i, (Object)(i + "-value")));
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 0; i2 < range; ++i2) {
            DoubleSummaryStatistics stats = this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).sorted().skip((long)i2).summaryStatistics();
            AssertJUnit.assertEquals((long)(range - i2), (long)stats.getCount());
            AssertJUnit.assertEquals((Object)i2, (Object)stats.getMin());
            AssertJUnit.assertEquals((Object)((double)range - 1.0), (Object)stats.getMax());
            AssertJUnit.assertEquals((Object)IntStream.range(i2, range).sum(), (Object)stats.getSum());
        }
    }

    public void testDoubleSortedLimit() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).mapToDouble(value -> value).forEach(i -> cache.put((Object)i, (Object)(i + "-value")));
        CacheSet entrySet = cache.entrySet();
        for (int i2 = 1; i2 < range; ++i2) {
            DoubleSummaryStatistics stats = this.createStream((CacheCollection)entrySet).mapToDouble(toDouble).sorted().limit((long)i2).summaryStatistics();
            AssertJUnit.assertEquals((long)i2, (long)stats.getCount());
            AssertJUnit.assertEquals((Object)0.0, (Object)stats.getMin());
            AssertJUnit.assertEquals((Object)((double)i2 - 1.0), (Object)stats.getMax());
            AssertJUnit.assertEquals((Object)IntStream.range(0, i2).sum(), (Object)stats.getSum());
        }
    }

    public void testObjKeySetMax() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet keySet = cache.keySet();
        AssertJUnit.assertEquals((int)9, (int)((Integer)this.createStream((CacheCollection)keySet).max(Integer::compare).get()));
    }

    public void testKeySetIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet keySet = cache.keySet();
        Iterator iterator = this.createStream((CacheCollection)keySet).iterator();
        AtomicInteger count = new AtomicInteger();
        iterator.forEachRemaining(e -> {
            AssertJUnit.assertTrue((boolean)cache.containsKey(e));
            count.addAndGet((int)e);
        });
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)count.get());
    }

    public void testKeySetMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet keySet = cache.keySet();
        Iterator iterator = this.createStream((CacheCollection)keySet).map((SerializableFunction & Serializable)i -> i + "-value").iterator();
        AtomicInteger count = new AtomicInteger();
        iterator.forEachRemaining(e -> {
            Integer key = Integer.valueOf(e.substring(0, 1));
            AssertJUnit.assertEquals((String)((String)cache.get((Object)key)), (String)e);
            count.addAndGet(key);
        });
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)count.get());
    }

    public void testKeySetFlatMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet keySet = cache.keySet();
        PrimitiveIterator.OfInt iterator = this.createStream((CacheCollection)keySet).flatMapToInt((SerializableFunction & Serializable)i -> IntStream.of(i, 3)).iterator();
        int pos = 0;
        int halfCount = 0;
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (next == 3) {
                ++halfCount;
            }
            ++pos;
            AssertJUnit.assertTrue((boolean)cache.containsKey((Object)next));
        }
        AssertJUnit.assertEquals((int)(range + 1), (int)halfCount);
        AssertJUnit.assertEquals((int)(range * 2), (int)pos);
    }

    public void testObjValuesMax() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheCollection keySet = cache.values();
        AssertJUnit.assertEquals((String)"9-value", (String)((String)this.createStream(keySet).max((SerializableComparator & Serializable)(e1, e2) -> Integer.compare(Integer.valueOf(e1.substring(0, 1)), Integer.valueOf(e2.substring(0, 1)))).get()));
    }

    public void testObjMaxEmpty() {
        Cache cache = this.getCache(0);
        AssertJUnit.assertEquals((int)0, (int)cache.size());
        CacheCollection keySet = cache.values();
        AssertJUnit.assertFalse((boolean)this.createStream(keySet).max((SerializableComparator & Serializable)(e1, e2) -> Integer.compare(Integer.valueOf(e1.substring(0, 1)), Integer.valueOf(e2.substring(0, 1)))).isPresent());
    }

    public void testObjValuesIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheCollection values = cache.values();
        Iterator iterator = this.createStream(values).iterator();
        AtomicInteger count = new AtomicInteger();
        iterator.forEachRemaining(e -> {
            Integer key = Integer.valueOf(e.substring(0, 1));
            AssertJUnit.assertEquals((String)((String)cache.get((Object)key)), (String)e);
            count.addAndGet(key);
        });
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)count.get());
    }

    public void testValuesMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheCollection values = cache.values();
        PrimitiveIterator.OfInt iterator = this.createStream(values).mapToInt((SerializableToIntFunction & Serializable)e -> Integer.valueOf(e.substring(0, 1))).iterator();
        AtomicInteger count = new AtomicInteger();
        iterator.forEachRemaining(e -> {
            AssertJUnit.assertTrue((boolean)cache.containsKey((Object)e));
            count.addAndGet(e);
        });
        AssertJUnit.assertEquals((int)((range - 1) * (range / 2)), (int)count.get());
    }

    public void testValuesFlatMapIterator() {
        Cache cache = this.getCache(0);
        int range = 10;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheCollection values = cache.values();
        PrimitiveIterator.OfInt iterator = this.createStream(values).flatMapToInt((SerializableFunction & Serializable)e -> IntStream.of(Integer.valueOf(e.substring(0, 1)), e.length())).iterator();
        int pos = 0;
        int halfCount = 0;
        while (iterator.hasNext()) {
            int next = iterator.nextInt();
            if (next == 7) {
                ++halfCount;
            }
            ++pos;
            AssertJUnit.assertTrue((boolean)cache.containsKey((Object)next));
        }
        AssertJUnit.assertEquals((int)(range + 1), (int)halfCount);
        AssertJUnit.assertEquals((int)(range * 2), (int)pos);
    }

    public void testKeySegmentFilter() {
        Cache cache = this.getCache(0);
        int range = 12;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        int segments = cache.getCacheConfiguration().clustering().hash().numSegments() / 2;
        AtomicInteger realCount = new AtomicInteger();
        KeyPartitioner keyPartitioner = (KeyPartitioner)cache.getAdvancedCache().getComponentRegistry().getComponent(KeyPartitioner.class);
        cache.forEach((k, v) -> {
            if (segments >= keyPartitioner.getSegment(k)) {
                realCount.incrementAndGet();
            }
        });
        AssertJUnit.assertEquals((long)realCount.get(), (long)this.createStream((CacheCollection)entrySet).filterKeySegments(IntStream.range(0, segments).boxed().collect(Collectors.toSet())).count());
    }

    public void testKeyFilter() {
        Cache cache = this.getCache(0);
        int range = 12;
        IntStream.range(0, range).boxed().forEach(i -> cache.put(i, (Object)(i + "-value")));
        AssertJUnit.assertEquals((int)range, (int)cache.size());
        CacheSet entrySet = cache.entrySet();
        Set keys = IntStream.of(2, 5, 8, 3, 1, range + 2).boxed().collect(Collectors.toSet());
        AssertJUnit.assertEquals((long)(keys.size() - 1), (long)this.createStream((CacheCollection)entrySet).filterKeys(keys).count());
    }

    @SerializeWith(value=Externalizer.class)
    public static class ForEachDoubleInjected<E>
    implements DoubleConsumer,
    CacheAware<Double, String> {
        private Cache<?, ?> cache;
        private final int cacheOffset;
        private final int atomicOffset;

        private ForEachDoubleInjected(int cacheOffset, int atomicOffset) {
            this.cacheOffset = cacheOffset;
            this.atomicOffset = atomicOffset;
        }

        public void injectCache(Cache<Double, String> cache) {
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(double value) {
            Cache cache = (Cache)BaseStreamTest.getForEachObject(this.cacheOffset);
            if (cache != null && this.cache != null && cache.getName().equals(this.cache.getName())) {
                DoubleSummaryStatistics stats;
                DoubleSummaryStatistics doubleSummaryStatistics = stats = (DoubleSummaryStatistics)BaseStreamTest.getForEachObject(this.atomicOffset);
                synchronized (doubleSummaryStatistics) {
                    stats.accept(value);
                }
            } else {
                AssertJUnit.fail((String)"Did not receive correct cache!");
            }
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<ForEachDoubleInjected> {
            public void writeObject(ObjectOutput output, ForEachDoubleInjected object) throws IOException {
                output.writeInt(object.cacheOffset);
                output.writeInt(object.atomicOffset);
            }

            public ForEachDoubleInjected readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                int cacheOffset = input.readInt();
                int atomicOffset = input.readInt();
                return new ForEachDoubleInjected(cacheOffset, atomicOffset);
            }
        }
    }

    @SerializeWith(value=Externalizer.class)
    public static class ForEachLongInjected
    implements LongConsumer,
    CacheAware<Long, String> {
        private Cache<?, ?> cache;
        private final int cacheOffset;
        private final int atomicOffset;

        private ForEachLongInjected(int cacheOffset, int atomicOffset) {
            this.cacheOffset = cacheOffset;
            this.atomicOffset = atomicOffset;
        }

        public void injectCache(Cache<Long, String> cache) {
            this.cache = cache;
        }

        @Override
        public void accept(long value) {
            Cache cache = (Cache)BaseStreamTest.getForEachObject(this.cacheOffset);
            if (cache != null && this.cache != null && cache.getName().equals(this.cache.getName())) {
                ((AtomicLong)BaseStreamTest.getForEachObject(this.atomicOffset)).addAndGet(value);
            } else {
                AssertJUnit.fail((String)"Did not receive correct cache!");
            }
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<ForEachLongInjected> {
            public void writeObject(ObjectOutput output, ForEachLongInjected object) throws IOException {
                output.writeInt(object.cacheOffset);
                output.writeInt(object.atomicOffset);
            }

            public ForEachLongInjected readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                int cacheOffset = input.readInt();
                int atomicOffset = input.readInt();
                return new ForEachLongInjected(cacheOffset, atomicOffset);
            }
        }
    }

    @SerializeWith(value=Externalizer.class)
    public static class ForEachIntInjected
    implements IntConsumer,
    CacheAware<Integer, String> {
        private Cache<?, ?> cache;
        private final int cacheOffset;
        private final int atomicOffset;

        private ForEachIntInjected(int cacheOffset, int atomicOffset) {
            this.cacheOffset = cacheOffset;
            this.atomicOffset = atomicOffset;
        }

        public void injectCache(Cache<Integer, String> cache) {
            this.cache = cache;
        }

        @Override
        public void accept(int value) {
            Cache cache = (Cache)BaseStreamTest.getForEachObject(this.cacheOffset);
            if (cache != null && this.cache != null && cache.getName().equals(this.cache.getName())) {
                ((AtomicInteger)BaseStreamTest.getForEachObject(this.atomicOffset)).addAndGet(value);
            } else {
                AssertJUnit.fail((String)"Did not receive correct cache!");
            }
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<ForEachIntInjected> {
            public void writeObject(ObjectOutput output, ForEachIntInjected object) throws IOException {
                output.writeInt(object.cacheOffset);
                output.writeInt(object.atomicOffset);
            }

            public ForEachIntInjected readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                int cacheOffset = input.readInt();
                int atomicOffset = input.readInt();
                return new ForEachIntInjected(cacheOffset, atomicOffset);
            }
        }
    }

    @SerializeWith(value=Externalizer.class)
    public static class ForEachInjected<E>
    implements Consumer<E>,
    CacheAware<Integer, String> {
        private Cache<?, ?> cache;
        private final int cacheOffset;
        private final int atomicOffset;
        private final ToIntFunction<? super E> function;

        private ForEachInjected(int cacheOffset, int atomicOffset, SerializableToIntFunction<? super E> function) {
            this.cacheOffset = cacheOffset;
            this.atomicOffset = atomicOffset;
            this.function = function;
        }

        public void injectCache(Cache<Integer, String> cache) {
            this.cache = cache;
        }

        @Override
        public void accept(E entry) {
            Cache cache = (Cache)BaseStreamTest.getForEachObject(this.cacheOffset);
            if (cache != null && this.cache != null && cache.getName().equals(this.cache.getName())) {
                ((AtomicInteger)BaseStreamTest.getForEachObject(this.atomicOffset)).addAndGet(this.function.applyAsInt(entry));
            } else {
                AssertJUnit.fail((String)"Did not receive correct cache!");
            }
        }

        public static class Externalizer
        implements org.infinispan.commons.marshall.Externalizer<ForEachInjected> {
            public void writeObject(ObjectOutput output, ForEachInjected object) throws IOException {
                output.writeInt(object.cacheOffset);
                output.writeInt(object.atomicOffset);
                output.writeObject(object.function);
            }

            public ForEachInjected readObject(ObjectInput input) throws IOException, ClassNotFoundException {
                int cacheOffset = input.readInt();
                int atomicOffset = input.readInt();
                SerializableToIntFunction f = (SerializableToIntFunction)input.readObject();
                return new ForEachInjected(cacheOffset, atomicOffset, f);
            }
        }
    }
}

