/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.MagicKey;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.CompositeKeyValueFilterConverter;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.stream.BaseSetupStreamIteratorTest;
import org.infinispan.stream.DistributedStreamIteratorTest;
import org.infinispan.util.function.SerializablePredicate;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="stream.DistributedStreamIteratorRepeatableReadTxTest")
public class DistributedStreamIteratorRepeatableReadTxTest
extends DistributedStreamIteratorTest {
    public DistributedStreamIteratorRepeatableReadTxTest() {
        super(true, CacheMode.DIST_SYNC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheCollectionsIncludesEntriesNotYetCommitted() throws Exception {
        Cache cache = this.cache(0, "testCache");
        TransactionManager tm = this.tm(cache);
        tm.begin();
        try {
            LinkedHashMap<MagicKey, String> inserted = new LinkedHashMap<MagicKey, String>();
            for (int i = 0; i < 3; ++i) {
                MagicKey key = new MagicKey(this.cache(i, "testCache"));
                cache.put((Object)key, (Object)((Object)key).toString());
                inserted.put(key, ((Object)key).toString());
            }
            Set expectedKeys = inserted.keySet();
            HashSet keySetResults = new HashSet(cache.keySet());
            AssertJUnit.assertEquals(expectedKeys, keySetResults);
            HashSet expectedValues = new HashSet(inserted.values());
            HashSet valuesResults = new HashSet(cache.values());
            AssertJUnit.assertEquals(expectedValues, valuesResults);
            Set expectedEntries = inserted.entrySet();
            HashSet entrySetResults = new HashSet(cache.entrySet());
            AssertJUnit.assertEquals(expectedEntries, entrySetResults);
        }
        finally {
            tm.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFilterWithExistingTransaction() throws Exception {
        Map<Object, String> values = this.putValueInEachCache(3);
        Cache cache = this.cache(0, "testCache");
        TransactionManager tm = this.tm(cache);
        tm.begin();
        try {
            String key = "filtered-key";
            cache.put((Object)key, (Object)"filtered-value");
            Iterator iterator = cache.getAdvancedCache().cacheEntrySet().stream().filter((SerializablePredicate & Serializable)entry -> !Objects.equals(key, entry.getKey())).iterator();
            Map results = DistributedStreamIteratorRepeatableReadTxTest.mapFromIterator(iterator);
            AssertJUnit.assertEquals(values, results);
        }
        finally {
            tm.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConverterWithExistingTransaction() throws NotSupportedException, SystemException {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TransactionManager tm = this.tm(cache);
        tm.begin();
        try {
            String key = "converted-key";
            String value = "converted-value";
            values.put(key, value);
            cache.put((Object)key, (Object)"converted-value");
            try (CacheStream stream = cache.getAdvancedCache().cacheEntrySet().stream().filter(CacheFilters.predicate((KeyValueFilter)AcceptAllKeyValueFilter.getInstance())).map(CacheFilters.function((Converter)new BaseSetupStreamIteratorTest.StringTruncator(2, 5)));){
                Map results = DistributedStreamIteratorRepeatableReadTxTest.mapFromStream(stream);
                AssertJUnit.assertEquals((int)values.size(), (int)results.size());
                for (Map.Entry<Object, String> entry : values.entrySet()) {
                    AssertJUnit.assertEquals((String)entry.getValue().substring(2, 7), (String)((String)results.get(entry.getKey())));
                }
            }
        }
        finally {
            tm.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKeyFilterConverterWithExistingTransaction() throws NotSupportedException, SystemException {
        Map<Object, String> values = this.putValuesInCache();
        Cache cache = this.cache(0, "testCache");
        TransactionManager tm = this.tm(cache);
        tm.begin();
        try {
            Iterator<Map.Entry<Object, String>> iter = values.entrySet().iterator();
            Map.Entry<Object, String> extraEntry = iter.next();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            String key = "converted-key";
            String value = "converted-value";
            values.put(key, value);
            cache.put((Object)key, (Object)"converted-value");
            ArrayList<Object> acceptedKeys = new ArrayList<Object>();
            acceptedKeys.add(key);
            acceptedKeys.add(extraEntry.getKey());
            Serializable filter = (KeyValueFilter & Serializable)(k, v, m) -> acceptedKeys.contains(k);
            CompositeKeyValueFilterConverter<Object, String, String> filterConverter = new CompositeKeyValueFilterConverter<Object, String, String>((KeyValueFilter<Object, String>)filter, new BaseSetupStreamIteratorTest.StringTruncator(2, 5));
            try (CacheStream stream = CacheFilters.filterAndConvert((CacheStream)cache.getAdvancedCache().cacheEntrySet().stream(), filterConverter);){
                Map results = DistributedStreamIteratorRepeatableReadTxTest.mapFromStream(stream);
                AssertJUnit.assertEquals((int)values.size(), (int)results.size());
                for (Map.Entry<Object, String> entry : values.entrySet()) {
                    AssertJUnit.assertEquals((String)entry.getValue().substring(2, 7), (String)((String)results.get(entry.getKey())));
                }
            }
        }
        finally {
            tm.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamWithMissedKeyInTransaction() throws Exception {
        AdvancedCache cache = this.advancedCache(0, "testCache");
        TransactionManager tm = this.tm((Cache<?, ?>)cache);
        tm.begin();
        try {
            MagicKey localMissingKey = new MagicKey("key1", (Cache<?, ?>)cache);
            MagicKey remoteMissingKey = new MagicKey("key2", this.cache(1, "testCache"));
            AssertJUnit.assertFalse((boolean)cache.containsKey((Object)localMissingKey));
            AssertJUnit.assertFalse((boolean)cache.containsKey((Object)remoteMissingKey));
            Iterator iterator = cache.getAdvancedCache().cacheEntrySet().stream().iterator();
            Map results = DistributedStreamIteratorRepeatableReadTxTest.mapFromIterator(iterator);
            AssertJUnit.assertEquals(Collections.emptyMap(), results);
            AssertJUnit.assertEquals((int)0, (int)cache.size());
        }
        finally {
            tm.rollback();
        }
    }
}

