/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.MagicKey;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.stream.BaseSetupStreamIteratorTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.util.concurrent.CompletionStages;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.DistributedStreamIteratorWithPassivationTest")
public class DistributedStreamIteratorWithPassivationTest
extends BaseSetupStreamIteratorTest {
    public DistributedStreamIteratorWithPassivationTest() {
        this(false, CacheMode.DIST_SYNC);
    }

    protected DistributedStreamIteratorWithPassivationTest(boolean tx, CacheMode mode) {
        super(tx, mode);
    }

    @Override
    protected void enhanceConfiguration(ConfigurationBuilder builder) {
        builder.clustering().hash().numOwners(1);
        ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(true).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.getTestName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, description="This requires supporting concurrent activation in cache loader interceptor")
    public void testConcurrentActivation() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache0 = this.cache(0, "testCache");
        Cache cache1 = this.cache(1, "testCache");
        Cache cache2 = this.cache(2, "testCache");
        HashMap<MagicKey, String> originalValues = new HashMap<MagicKey, String>();
        originalValues.put(new MagicKey(cache0), "cache0");
        originalValues.put(new MagicKey(cache1), "cache1");
        originalValues.put(new MagicKey(cache2), "cache2");
        MagicKey loaderKey = new MagicKey(cache0);
        String loaderValue = "loader0";
        cache0.putAll(originalValues);
        originalValues.put(loaderKey, "loader0");
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache0, PersistenceManager.class);
        DummyInMemoryStore store = (DummyInMemoryStore)persistenceManager.getStores(DummyInMemoryStore.class).iterator().next();
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        PersistenceManager pm = null;
        try {
            store.write(MarshalledEntryUtil.create(loaderKey, "loader0", (Marshaller)sm));
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache0, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((String)"loader0", (String)((String)cache0.get((Object)loaderKey)));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Iterator iterator = cache0.entrySet().stream().iterator();
            int count = 0;
            HashMap<MagicKey, String> results = new HashMap<MagicKey, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                results.put((MagicKey)entry.getKey(), (String)entry.getValue());
                ++count;
            }
            AssertJUnit.assertEquals((int)count, (int)4);
            AssertJUnit.assertEquals(originalValues, results);
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache0, PersistenceManager.class, pm, true, true);
            }
            sm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, description="This requires supporting concurrent activation in cache loader interceptor")
    public void testConcurrentActivationWithFilter() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache0 = this.cache(0, "testCache");
        Cache cache1 = this.cache(1, "testCache");
        Cache cache2 = this.cache(2, "testCache");
        HashMap<MagicKey, String> originalValues = new HashMap<MagicKey, String>();
        originalValues.put(new MagicKey(cache0), "cache0");
        originalValues.put(new MagicKey(cache1), "cache1");
        originalValues.put(new MagicKey(cache2), "cache2");
        MagicKey loaderKey = new MagicKey(cache0);
        String loaderValue = "loader0";
        cache0.putAll(originalValues);
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache0, PersistenceManager.class);
        DummyInMemoryStore store = (DummyInMemoryStore)persistenceManager.getStores(DummyInMemoryStore.class).iterator().next();
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        PersistenceManager pm = null;
        try {
            store.write(MarshalledEntryUtil.create(loaderKey, "loader0", (Marshaller)sm));
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache0, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((String)"loader0", (String)((String)cache0.get((Object)loaderKey)));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Serializable filter = (KeyValueFilter & Serializable)(k, v, m) -> originalValues.containsKey(k);
            Iterator iterator = cache0.getAdvancedCache().cacheEntrySet().stream().filter(CacheFilters.predicate((KeyValueFilter)filter)).iterator();
            int count = 0;
            HashMap<MagicKey, String> results = new HashMap<MagicKey, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                results.put((MagicKey)entry.getKey(), (String)entry.getValue());
                ++count;
            }
            AssertJUnit.assertEquals((int)count, (int)3);
            AssertJUnit.assertEquals(originalValues, results);
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache0, PersistenceManager.class, pm, true, true);
            }
            sm.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(enabled=false, description="This requires supporting concurrent activation in cache loader interceptor")
    public void testConcurrentActivationWithConverter() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache0 = this.cache(0, "testCache");
        Cache cache1 = this.cache(1, "testCache");
        Cache cache2 = this.cache(2, "testCache");
        HashMap<MagicKey, String> originalValues = new HashMap<MagicKey, String>();
        originalValues.put(new MagicKey(cache0), "cache0");
        originalValues.put(new MagicKey(cache1), "cache1");
        originalValues.put(new MagicKey(cache2), "cache2");
        MagicKey loaderKey = new MagicKey(cache0);
        String loaderValue = "loader0";
        cache0.putAll(originalValues);
        originalValues.put(loaderKey, "loader0");
        PersistenceManager persistenceManager = TestingUtil.extractComponent(cache0, PersistenceManager.class);
        DummyInMemoryStore store = (DummyInMemoryStore)persistenceManager.getStores(DummyInMemoryStore.class).iterator().next();
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller();
        PersistenceManager pm = null;
        try {
            store.write(MarshalledEntryUtil.create(loaderKey, "loader0", (Marshaller)sm));
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache0, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((String)"loader0", (String)((String)cache0.get((Object)loaderKey)));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Iterator iterator = cache0.getAdvancedCache().cacheEntrySet().stream().map(CacheFilters.function((Converter)new BaseSetupStreamIteratorTest.StringTruncator(1, 3))).iterator();
            int count = 0;
            HashMap<MagicKey, String> results = new HashMap<MagicKey, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                results.put((MagicKey)entry.getKey(), (String)entry.getValue());
                ++count;
            }
            AssertJUnit.assertEquals((int)count, (int)4);
            for (Map.Entry entry : originalValues.entrySet()) {
                AssertJUnit.assertEquals((String)((String)entry.getValue()).substring(1, 4), (String)((String)results.get(entry.getKey())));
            }
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache0, PersistenceManager.class, pm, true, true);
            }
            sm.stop();
        }
    }

    protected PersistenceManager waitUntilAboutToProcessStoreTask(Cache<?, ?> cache, CheckPoint checkPoint) {
        PersistenceManager pm = TestingUtil.extractComponent(cache, PersistenceManager.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)pm);
        PersistenceManager mockManager = (PersistenceManager)Mockito.mock(PersistenceManager.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((PersistenceManager)Mockito.doAnswer(invocation -> {
            checkPoint.trigger("pre_process_on_all_stores_invoked");
            checkPoint.awaitStrict("pre_process_on_all_stores_released", 10L, TimeUnit.SECONDS);
            return forwardedAnswer.answer(invocation);
        }).when((Object)mockManager)).publishEntries((IntSet)ArgumentMatchers.any(), (Predicate)ArgumentMatchers.any(), Matchers.anyBoolean(), Matchers.anyBoolean(), (Predicate)ArgumentMatchers.any());
        TestingUtil.replaceComponent(cache, PersistenceManager.class, mockManager, true);
        return pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConcurrentPassivation() throws InterruptedException, ExecutionException, TimeoutException {
        Cache cache0 = this.cache(0, "testCache");
        Cache cache1 = this.cache(1, "testCache");
        Cache cache2 = this.cache(2, "testCache");
        HashMap<MagicKey, String> originalValues = new HashMap<MagicKey, String>();
        originalValues.put(new MagicKey(cache0), "cache0");
        originalValues.put(new MagicKey(cache1), "cache1");
        originalValues.put(new MagicKey(cache2), "cache2");
        MagicKey loaderKey = new MagicKey(cache0);
        String loaderValue = "loader0";
        originalValues.put(loaderKey, "loader0");
        cache0.putAll(originalValues);
        PersistenceManager pm = null;
        try {
            CheckPoint checkPoint = new CheckPoint();
            pm = this.waitUntilAboutToProcessStoreTask(cache0, checkPoint);
            Future<Void> future = this.fork(() -> {
                checkPoint.awaitStrict("pre_process_on_all_stores_invoked", 10L, TimeUnit.SECONDS);
                CompletionStages.join((CompletionStage)TestingUtil.extractComponent(cache0, PassivationManager.class).passivateAsync((InternalCacheEntry)new ImmortalCacheEntry((Object)loaderKey, (Object)"loader0")));
                checkPoint.triggerForever("pre_process_on_all_stores_released");
                return null;
            });
            Iterator iterator = cache1.entrySet().stream().iterator();
            HashMap<MagicKey, String> results = new HashMap<MagicKey, String>();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String prev = results.put((MagicKey)entry.getKey(), (String)entry.getValue());
                AssertJUnit.assertNull((String)("Entry " + entry + " replaced an existing value of " + prev), (Object)prev);
            }
            AssertJUnit.assertEquals(originalValues, results);
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            if (pm != null) {
                TestingUtil.replaceComponent(cache0, PersistenceManager.class, pm, true, true);
            }
        }
    }
}

