/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.reactive.publisher.impl.commands.batch.InitialPublisherCommand;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.stream.BaseSetupStreamIteratorTest;
import org.infinispan.test.Mocks;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="iteration.DistributedWriteBehindStreamIteratorTest")
public class DistributedWriteBehindStreamIteratorTest
extends BaseSetupStreamIteratorTest {
    private boolean asyncStore;
    private boolean sharedStore;

    public DistributedWriteBehindStreamIteratorTest() {
        super(false, null);
    }

    DistributedWriteBehindStreamIteratorTest async(boolean asyncStore) {
        this.asyncStore = asyncStore;
        return this;
    }

    DistributedWriteBehindStreamIteratorTest shared(boolean sharedStore) {
        this.sharedStore = sharedStore;
        return this;
    }

    @Override
    public Object[] factory() {
        return new Object[]{new DistributedWriteBehindStreamIteratorTest().async(true).shared(true).cacheMode(CacheMode.REPL_SYNC), new DistributedWriteBehindStreamIteratorTest().async(false).shared(true).cacheMode(CacheMode.REPL_SYNC), new DistributedWriteBehindStreamIteratorTest().async(true).shared(false).cacheMode(CacheMode.REPL_SYNC), new DistributedWriteBehindStreamIteratorTest().async(false).shared(false).cacheMode(CacheMode.REPL_SYNC), new DistributedWriteBehindStreamIteratorTest().async(true).shared(true).cacheMode(CacheMode.DIST_SYNC), new DistributedWriteBehindStreamIteratorTest().async(false).shared(true).cacheMode(CacheMode.DIST_SYNC), new DistributedWriteBehindStreamIteratorTest().async(true).shared(false).cacheMode(CacheMode.DIST_SYNC), new DistributedWriteBehindStreamIteratorTest().async(false).shared(false).cacheMode(CacheMode.DIST_SYNC)};
    }

    @Override
    protected Object[] parameterValues() {
        return DistributedWriteBehindStreamIteratorTest.concat(super.parameterValues(), this.asyncStore, this.sharedStore);
    }

    @Override
    protected String[] parameterNames() {
        return DistributedWriteBehindStreamIteratorTest.concat(super.parameterNames(), "asyncStore", "sharedStore");
    }

    @Override
    protected void enhanceConfiguration(ConfigurationBuilder builder) {
        DummyInMemoryStoreConfigurationBuilder dimscb = (DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class);
        if (this.sharedStore) {
            dimscb.shared(true);
        }
        if (this.asyncStore) {
            dimscb.storeName(this.getTestName()).async().enable();
        }
    }

    @DataProvider(name="rehashAware")
    public Object[][] dataProvider() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @Test(dataProvider="rehashAware")
    public void testBackupSegmentsOptimizationWithWriteBehindStore(boolean rehashAware) {
        int invocationCount;
        Map entries;
        Cache cache1 = this.cache(1, "testCache");
        RpcManager rpcManager = Mocks.replaceComponentWithSpy(cache1, RpcManager.class);
        for (Cache cache : this.caches("testCache")) {
            MagicKey key = new MagicKey(cache);
            cache.put((Object)key, (Object)key.toString());
        }
        CacheStream stream = cache1.entrySet().stream();
        if (!rehashAware) {
            stream = stream.disableRehashAware();
        }
        if (this.cacheMode.isReplicated()) {
            entries = DistributedWriteBehindStreamIteratorTest.mapFromIterator(stream.iterator());
            AssertJUnit.assertEquals((int)this.caches("testCache").size(), (int)entries.size());
            invocationCount = this.cacheManagers.size() - 1;
        } else {
            entries = DistributedWriteBehindStreamIteratorTest.mapFromIterator(stream.filterKeySegments(IntSets.immutableSet((int)2)).iterator());
            AssertJUnit.assertEquals((int)1, (int)entries.size());
            invocationCount = 1;
        }
        if (this.asyncStore && this.sharedStore) {
            ((RpcManager)Mockito.verify((Object)rpcManager, (VerificationMode)Mockito.times((int)invocationCount))).invokeCommand((Address)ArgumentMatchers.any(Address.class), (ReplicableCommand)ArgumentMatchers.any(InitialPublisherCommand.class), (ResponseCollector)ArgumentMatchers.any(), (RpcOptions)ArgumentMatchers.any());
        } else {
            ((RpcManager)Mockito.verify((Object)rpcManager, (VerificationMode)Mockito.never())).invokeCommand((Address)ArgumentMatchers.any(Address.class), (ReplicableCommand)ArgumentMatchers.any(InitialPublisherCommand.class), (ResponseCollector)ArgumentMatchers.any(), (RpcOptions)ArgumentMatchers.any());
        }
    }
}

