/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@CleanupAfterTest
@Test(groups={"stress"}, testName="stress.LargeClusterStressTest", timeOut=900000L)
public class LargeClusterStressTest
extends MultipleCacheManagersTest {
    private static final int NUM_NODES = 40;
    private static final int NUM_CACHES = 20;
    private static final int NUM_THREADS = 40;
    private static final int NUM_SEGMENTS = 256;
    private static final EnumSet<CacheMode> cacheModes = EnumSet.of(CacheMode.LOCAL, CacheMode.INVALIDATION_SYNC, CacheMode.DIST_SYNC, CacheMode.REPL_SYNC);

    @Override
    protected void createCacheManagers() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargeClusterStart() throws Exception {
        HashMap<CacheMode, Configuration> configurations = new HashMap<CacheMode, Configuration>();
        configurations.put(CacheMode.DIST_SYNC, new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).clustering().stateTransfer().awaitInitialTransfer(false).clustering().hash().numSegments(256).build());
        configurations.put(CacheMode.REPL_SYNC, new ConfigurationBuilder().clustering().cacheMode(CacheMode.REPL_SYNC).clustering().hash().numSegments(256).clustering().stateTransfer().awaitInitialTransfer(false).build());
        configurations.put(CacheMode.INVALIDATION_SYNC, new ConfigurationBuilder().clustering().cacheMode(CacheMode.INVALIDATION_SYNC).build());
        configurations.put(CacheMode.LOCAL, new ConfigurationBuilder().clustering().cacheMode(CacheMode.LOCAL).build());
        ExecutorService executor = Executors.newFixedThreadPool(40, this.getTestThreadFactory("Worker"));
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(executor);
        try {
            int i;
            for (i = 0; i < 40; ++i) {
                String nodeName = TestResourceTracker.getNameForIndex((int)i);
                completionService.submit(() -> {
                    GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
                    gcb.transport().defaultTransport().nodeName(nodeName);
                    DefaultCacheManager cm = new DefaultCacheManager(gcb.build());
                    try {
                        int j;
                        for (j = 0; j < 20; ++j) {
                            for (CacheMode mode : cacheModes) {
                                cm.defineConfiguration(this.cacheName(mode, j), (Configuration)configurations.get(mode));
                            }
                        }
                        for (j = 0; j < 20; ++j) {
                            for (CacheMode mode : cacheModes) {
                                Cache cache = cm.getCache(this.cacheName(mode, j));
                                cache.put((Object)cm.getAddress(), (Object)"bla");
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.registerCacheManager(new CacheContainer[]{cm});
                        throw throwable;
                    }
                    this.registerCacheManager(new CacheContainer[]{cm});
                    log.infof("Started cache manager %s", (Object)cm.getAddress());
                    return null;
                });
            }
            for (i = 0; i < 40; ++i) {
                completionService.take();
            }
        }
        finally {
            executor.shutdownNow();
        }
        log.infof("All %d cache managers started, waiting for state transfer to finish for each cache", (Object)40);
        for (int j = 0; j < 20; ++j) {
            for (CacheMode mode : cacheModes) {
                if (!mode.isClustered()) continue;
                this.waitForClusterToForm(this.cacheName(mode, j));
            }
        }
    }

    private String cacheName(CacheMode mode, int index) {
        return mode.toString().toLowerCase() + "-cache-" + index;
    }

    @Test(dependsOnMethods={"testLargeClusterStart"})
    public void testLargeClusterStop() {
        for (int i = 0; i < 40; ++i) {
            int j;
            int killIndex = -1;
            for (j = 0; j < this.cacheManagers.size(); ++j) {
                if (!this.address(j).equals(this.manager(0).getCoordinator())) continue;
                killIndex = j;
                break;
            }
            log.debugf("Killing coordinator %s", (Object)this.address(killIndex));
            this.manager(killIndex).stop();
            this.cacheManagers.remove(killIndex);
            if (this.cacheManagers.size() <= 0) continue;
            TestingUtil.blockUntilViewsReceived(60000, false, this.cacheManagers);
            for (j = 0; j < 20; ++j) {
                for (CacheMode mode : cacheModes) {
                    if (!mode.isClustered()) continue;
                    TestingUtil.waitForNoRebalance(this.caches(this.cacheName(mode, j)));
                }
            }
        }
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
    }
}

