/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.transaction.TransactionManager;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.commons.test.ExceptionRunnable;
import org.infinispan.commons.test.TestNGLongTestsHook;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.time.TimeService;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.test.FeaturesListener;
import org.infinispan.test.fwk.ChainMethodInterceptor;
import org.infinispan.test.fwk.FakeTestClass;
import org.infinispan.test.fwk.NamedTestMethod;
import org.infinispan.test.fwk.TestSelector;
import org.infinispan.util.EmbeddedTimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.stack.Protocol;
import org.testng.AssertJUnit;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Listeners;
import org.testng.internal.MethodInstance;

@Listeners(value={ChainMethodInterceptor.class, TestNGLongTestsHook.class, FeaturesListener.class})
@TestSelector(interceptors={OrderByInstance.class})
public abstract class AbstractInfinispanTest {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final ThreadFactory defaultThreadFactory = this.getTestThreadFactory("ForkThread");
    private final ThreadPoolExecutor testExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.defaultThreadFactory);
    public static final TimeService TIME_SERVICE = new EmbeddedTimeService();

    public static String defaultParametersString(String[] names, Object[] params) {
        if (names == null || params == null) {
            return null;
        }
        assert (names.length == params.length);
        boolean[] last = new boolean[params.length];
        boolean none = true;
        for (int i = params.length - 1; i >= 0; --i) {
            last[i] = none;
            none &= params[i] == null;
        }
        if (none) {
            return null;
        }
        StringBuilder sb = new StringBuilder().append('[');
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) continue;
            if (names[i] != null) {
                sb.append(names[i]).append('=');
            }
            sb.append(params[i]);
            if (last[i]) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    protected String parameters() {
        return null;
    }

    @BeforeClass(alwaysRun=true)
    protected void testClassStarted(ITestContext context) {
        TestResourceTracker.testStarted((String)this.getTestName());
    }

    @AfterClass(alwaysRun=true)
    protected void testClassFinished(ITestContext context) {
        this.killSpawnedThreads();
        this.nullOutFields();
        TestResourceTracker.testFinished((String)this.getTestName());
    }

    public String getTestName() {
        String className = this.getClass().getName();
        String parameters = this.parameters();
        return parameters == null ? className : className + parameters;
    }

    protected void killSpawnedThreads() {
        List<Runnable> runnables = this.testExecutor.shutdownNow();
        if (!runnables.isEmpty()) {
            log.errorf("There were runnables %s left uncompleted in test %s", runnables, (Object)this.getClass().getSimpleName());
        }
    }

    @AfterMethod
    protected final void checkThreads() {
        int activeTasks = this.testExecutor.getActiveCount();
        if (activeTasks != 0) {
            log.errorf("There were %d active tasks found in the test executor service for class %s", (Object)activeTasks, (Object)this.getClass().getSimpleName());
        }
    }

    protected <T> void eventuallyEquals(T expected, Supplier<T> supplier) {
        AbstractInfinispanTest.eventually(() -> "expected:<" + expected + ">, got:<" + supplier.get() + ">", () -> Objects.equals(expected, supplier.get()));
    }

    protected static <T> void eventuallyEquals(String message, T expected, Supplier<T> supplier) {
        AbstractInfinispanTest.eventually(() -> message + " expected:<" + expected + ">, got:<" + supplier.get() + ">", () -> Objects.equals(expected, supplier.get()));
    }

    protected static void eventually(Supplier<String> messageSupplier, Condition condition) {
        AbstractInfinispanTest.eventually(messageSupplier, condition, 30L, TimeUnit.SECONDS);
    }

    protected static void eventually(Supplier<String> messageSupplier, Condition condition, long timeout, TimeUnit timeUnit) {
        try {
            long initialSleepNanos;
            long timeoutNanos = timeUnit.toNanos(timeout);
            int loops = 30;
            int progressionSum = loops * (loops + 1) / 2;
            long sleepNanos = initialSleepNanos = timeoutNanos / (long)progressionSum;
            long expectedEndTime = System.nanoTime() + timeoutNanos;
            while (expectedEndTime - System.nanoTime() > 0L) {
                if (condition.isSatisfied()) {
                    return;
                }
                LockSupport.parkNanos(sleepNanos);
                sleepNanos += initialSleepNanos;
            }
            if (!condition.isSatisfied()) {
                AssertJUnit.fail((String)messageSupplier.get());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected!", e);
        }
    }

    protected void eventually(Condition ec, long timeoutMillis) {
        this.eventually(ec, timeoutMillis, TimeUnit.MILLISECONDS);
    }

    protected void eventually(Condition ec, long timeout, TimeUnit unit) {
        AbstractInfinispanTest.eventually(() -> "Condition is still false after " + timeout + " " + (Object)((Object)unit), ec, timeout, unit);
    }

    protected void eventually(String message, Condition ec, long timeout, TimeUnit unit) {
        AbstractInfinispanTest.eventually(() -> message, ec, unit.toMillis(timeout), TimeUnit.MILLISECONDS);
    }

    protected Thread inNewThread(Runnable r) {
        Thread t = this.defaultThreadFactory.newThread(new RunnableWrapper(r));
        log.tracef("About to start thread '%s' as child of thread '%s'", (Object)t.getName(), (Object)Thread.currentThread().getName());
        t.start();
        return t;
    }

    protected Future<Void> fork(ExceptionRunnable r) {
        return this.testExecutor.submit(new CallableWrapper<Void>(() -> {
            r.run();
            return null;
        }));
    }

    protected <T> Future<T> fork(Callable<T> c) {
        return this.testExecutor.submit(new CallableWrapper<T>(c));
    }

    protected ThreadFactory getTestThreadFactory(final String prefix) {
        final String className = this.getClass().getSimpleName();
        return new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                String threadName = prefix + "-" + this.counter.incrementAndGet() + "," + className;
                Thread thread = new Thread(r, threadName);
                TestResourceTracker.addResource((String)AbstractInfinispanTest.this.getTestName(), (TestResourceTracker.Cleaner)new ThreadCleaner(thread));
                return thread;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected void runConcurrently(long timeout, TimeUnit timeUnit, ExceptionRunnable ... tasks) throws Exception {
        void var11_11;
        if (tasks == null || tasks.length < 2) {
            throw new IllegalArgumentException("Need at least 2 tasks to run concurrently");
        }
        long deadlineNanos = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, timeUnit);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(tasks.length);
        CyclicBarrier barrier = new CyclicBarrier(tasks.length);
        ExceptionRunnable[] exceptionRunnableArray = tasks;
        int n = exceptionRunnableArray.length;
        boolean bl = false;
        while (var11_11 < n) {
            ExceptionRunnable task = exceptionRunnableArray[var11_11];
            futures.add(this.testExecutor.submit(new ConcurrentCallable(task, barrier)));
            ++var11_11;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Future future : futures) {
            try {
                future.get(deadlineNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
            }
            catch (Exception e) {
                futures.forEach(f -> f.cancel(true));
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            Exception exception = (Exception)exceptions.remove(0);
            for (Exception e : exceptions) {
                exception.addSuppressed(e);
            }
            throw exception;
        }
    }

    protected void runConcurrently(long timeout, TimeUnit timeUnit, Callable<?> ... tasks) throws Exception {
        this.runConcurrently(timeout, timeUnit, (ExceptionRunnable[])Arrays.stream(tasks).map(task -> task::call).toArray(ExceptionRunnable[]::new));
    }

    protected void runConcurrently(ExceptionRunnable ... tasks) throws Exception {
        this.runConcurrently(30L, TimeUnit.SECONDS, tasks);
    }

    protected void runConcurrently(Callable<?> ... tasks) throws Exception {
        this.runConcurrently((ExceptionRunnable[])Arrays.stream(tasks).map(task -> task::call).toArray(ExceptionRunnable[]::new));
    }

    protected void eventually(Condition ec) {
        this.eventually(ec, 10000L, TimeUnit.MILLISECONDS);
    }

    protected void eventually(String message, Condition ec) {
        this.eventually(message, ec, 10000L, TimeUnit.MILLISECONDS);
    }

    public void safeRollback(TransactionManager transactionManager) {
        try {
            transactionManager.rollback();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void nullOutFields() {
        for (Field field : this.getAllFields()) {
            if (Modifier.isFinal(field.getModifiers()) || !this.fieldIsMemoryHog(field)) continue;
            field.setAccessible(true);
            try {
                field.set(this, null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.error((Object)e);
            }
        }
    }

    private boolean fieldIsMemoryHog(Field field) {
        Class[] memoryHogs = new Class[]{BasicCacheContainer.class, BasicCache.class, FunctionalMap.class, Protocol.class, AsyncInterceptor.class, RequestRepository.class, BasePartitionHandlingTest.Partition.class};
        return Stream.of(memoryHogs).anyMatch(clazz -> this.fieldIsMemoryHog(field, (Class<?>)clazz));
    }

    private boolean fieldIsMemoryHog(Field field, Class<?> clazz) {
        if (clazz.isAssignableFrom(field.getType())) {
            return true;
        }
        if (field.getType().isArray()) {
            return clazz.isAssignableFrom(field.getType().getComponentType());
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            Type fieldType = field.getGenericType();
            if (fieldType instanceof Class) {
                return clazz.isAssignableFrom((Class)fieldType);
            }
            if (fieldType instanceof ParameterizedType) {
                ParameterizedType collectionType = (ParameterizedType)fieldType;
                Type elementType = collectionType.getActualTypeArguments()[0];
                if (elementType instanceof ParameterizedType) {
                    return clazz.isAssignableFrom((Class)((ParameterizedType)elementType).getRawType());
                }
                if (elementType instanceof Class) {
                    return clazz.isAssignableFrom((Class)elementType);
                }
            }
            return false;
        }
        return false;
    }

    private Collection<Field> getAllFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = this.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        return fields;
    }

    protected ExecutorService testExecutor() {
        return this.testExecutor;
    }

    private class CallableWrapper<T>
    implements Callable<T> {
        private final Callable<? extends T> c;

        CallableWrapper(Callable<? extends T> c) {
            this.c = c;
        }

        @Override
        public T call() throws Exception {
            try {
                log.trace((Object)"Started fork callable..");
                T result = this.c.call();
                log.debug((Object)"Exiting fork callable.");
                return result;
            }
            catch (Exception e) {
                log.warn((Object)"Exiting fork callable due to exception", (Throwable)e);
                throw e;
            }
        }
    }

    public final class RunnableWrapper
    implements Runnable {
        final Runnable realOne;

        RunnableWrapper(Runnable realOne) {
            this.realOne = realOne;
        }

        @Override
        public void run() {
            try {
                log.trace((Object)"Started fork runnable..");
                this.realOne.run();
                log.debug((Object)"Exiting fork runnable.");
            }
            catch (Throwable e) {
                log.warn((Object)"Exiting fork runnable due to exception", e);
                throw e;
            }
        }
    }

    public final class ConcurrentCallable
    implements Callable<Void> {
        private final ExceptionRunnable task;
        private final CyclicBarrier barrier;

        ConcurrentCallable(ExceptionRunnable task, CyclicBarrier barrier) {
            this.task = task;
            this.barrier = barrier;
        }

        @Override
        public Void call() throws Exception {
            try {
                log.trace((Object)"Started concurrent callable");
                this.barrier.await(10L, TimeUnit.SECONDS);
                log.trace((Object)"Synchronized with the other concurrent runnables");
                this.task.run();
                log.debug((Object)"Exiting fork runnable.");
                return null;
            }
            catch (Throwable e) {
                log.warn((Object)"Exiting fork runnable due to exception", e);
                throw e;
            }
        }
    }

    private class ThreadCleaner
    extends TestResourceTracker.Cleaner<Thread> {
        public ThreadCleaner(Thread thread) {
            super((Object)thread);
        }

        public void close() {
            if (((Thread)this.ref).isAlive() && !((Thread)this.ref).isInterrupted()) {
                log.warnf("There was a thread %s still alive after test completion - interrupted it", this.ref);
                ((Thread)this.ref).interrupt();
            }
        }
    }

    public static class OrderByInstance
    implements IMethodInterceptor {
        public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
            IdentityHashMap<Object, List> methodsByInstance = new IdentityHashMap<Object, List>();
            HashMap instancesByName = new HashMap();
            for (IMethodInstance method : methods) {
                methodsByInstance.computeIfAbsent(method.getInstance(), k -> new ArrayList()).add(method);
            }
            ArrayList<IMethodInstance> newOrder = new ArrayList<IMethodInstance>(methods.size());
            for (Map.Entry instanceAndMethods : methodsByInstance.entrySet()) {
                Object instance = instanceAndMethods.getKey();
                if (instance instanceof AbstractInfinispanTest) {
                    String parameters;
                    String instanceName = ((AbstractInfinispanTest)instance).getTestName();
                    Object otherInstance = instancesByName.putIfAbsent(instanceName, instance);
                    if (otherInstance != null) {
                        String message = String.format("Duplicate test name: %s, classes %s and %s", instanceName, instance.getClass().getName(), otherInstance.getClass().getName());
                        MethodInstance methodInstance = FakeTestClass.newFailureMethodInstance((Exception)new TestNGException(message), context.getCurrentXmlTest(), context, instance);
                        newOrder.add((IMethodInstance)methodInstance);
                    }
                    if ((parameters = ((AbstractInfinispanTest)instance).parameters()) != null) {
                        for (IMethodInstance method : (List)instanceAndMethods.getValue()) {
                            if (method.getMethod() instanceof NamedTestMethod) {
                                newOrder.add(method);
                                continue;
                            }
                            newOrder.add((IMethodInstance)new MethodInstance((ITestNGMethod)new NamedTestMethod(method.getMethod(), method.getMethod().getMethodName() + parameters)));
                        }
                        continue;
                    }
                }
                newOrder.addAll((Collection)instanceAndMethods.getValue());
            }
            return newOrder;
        }
    }

    protected static interface Condition {
        public boolean isSatisfied() throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FeatureCondition {
        public String feature();
    }
}

