/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import io.reactivex.rxjava3.core.Flowable;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.manager.CacheContainer;
import org.infinispan.reactive.publisher.impl.SegmentCompletionPublisher;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.util.concurrent.CompletableFutures;
import org.mockito.AdditionalAnswers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.Stubber;
import org.reactivestreams.Publisher;

public class Mocks {
    public static final String BEFORE_INVOCATION = "before_invocation";
    public static final String BEFORE_RELEASE = "before_release";
    public static final String AFTER_INVOCATION = "after_invocation";
    public static final String AFTER_RELEASE = "after_release";
    public static final Answer<Void> EXECUTOR_RUN_ANSWER = invocation -> {
        Runnable runnable = (Runnable)invocation.getArgument(0);
        runnable.run();
        return null;
    };

    private Mocks() {
    }

    public static Answer<Void> justRunExecutorAnswer() {
        return EXECUTOR_RUN_ANSWER;
    }

    public static Answer<Void> runWithExecutorAnswer(Executor executor) {
        return invocation -> {
            Runnable runnable = (Runnable)invocation.getArgument(0);
            executor.execute(runnable);
            return null;
        };
    }

    public static <T, R> R invokeAndReturnMock(InvocationOnMock i, T target) throws IllegalAccessException, InvocationTargetException {
        Object returnValue = i.getMethod().invoke(target, i.getArguments());
        return (R)(returnValue == target ? i.getMock() : returnValue);
    }

    public static <T> T callRealMethod(InvocationOnMock invocation) {
        try {
            return (T)invocation.callRealMethod();
        }
        catch (Throwable throwable) {
            throw CompletableFutures.asCompletionException((Throwable)throwable);
        }
    }

    public static <T> T callAnotherAnswer(Answer<?> answer, InvocationOnMock invocation) {
        try {
            return (T)answer.answer(invocation);
        }
        catch (Throwable throwable) {
            throw CompletableFutures.asCompletionException((Throwable)throwable);
        }
    }

    public static <Mock> Mock blockingMock(CheckPoint checkPoint, Class<? extends Mock> componentClass, Cache<?, ?> cache, BiConsumer<? super Stubber, ? super Mock> mockStubConsumer, Class<?> ... extraInterfaces) {
        return (Mock)Mocks.interceptComponent(componentClass, cache, (realObject, mock) -> mockStubConsumer.accept((Stubber)Mockito.doAnswer(Mocks.blockingAnswer(AdditionalAnswers.delegatesTo((Object)realObject), checkPoint)), (Object)mock), extraInterfaces);
    }

    public static <Mock> Mock interceptComponent(Class<? extends Mock> componentClass, Cache<?, ?> cache, BiConsumer<? super Mock, ? super Mock> methodInterceptor, Class<?> ... extraInterfaces) {
        Mock realObject = TestingUtil.extractComponent(cache, componentClass);
        Answer forwardingAnswer = AdditionalAnswers.delegatesTo(realObject);
        MockSettings mockSettings = Mockito.withSettings().defaultAnswer(forwardingAnswer);
        if (extraInterfaces != null && extraInterfaces.length > 0) {
            mockSettings.extraInterfaces((Class[])extraInterfaces);
        }
        Object mock = Mockito.mock(componentClass, (MockSettings)mockSettings);
        methodInterceptor.accept(realObject, mock);
        TestingUtil.replaceComponent(cache, componentClass, mock, true);
        return realObject;
    }

    public static <T> Answer<T> blockingAnswer(Answer<T> answer, CheckPoint checkPoint) {
        return invocation -> {
            checkPoint.trigger(BEFORE_INVOCATION);
            checkPoint.awaitStrict(BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
            try {
                Object object = answer.answer(invocation);
                return object;
            }
            finally {
                checkPoint.trigger(AFTER_INVOCATION);
                checkPoint.awaitStrict(AFTER_RELEASE, 20L, TimeUnit.SECONDS);
            }
        };
    }

    public static <V> Callable<CompletableFuture<V>> blockingCompletableFuture(Callable<CompletableFuture<V>> completableFutureCallable, CheckPoint checkPoint, Executor executor) {
        return () -> {
            checkPoint.trigger(BEFORE_INVOCATION);
            try {
                checkPoint.awaitStrict(BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            CompletableFuture completableFuture = (CompletableFuture)completableFutureCallable.call();
            return completableFuture.thenCompose(v -> {
                checkPoint.trigger(AFTER_INVOCATION);
                return checkPoint.future(AFTER_RELEASE, 20L, TimeUnit.SECONDS, executor).thenApply(ignore -> v);
            });
        };
    }

    public static <E> Publisher<E> blockingPublisher(Publisher<E> publisher, CheckPoint checkPoint) {
        return Flowable.fromPublisher(publisher).doOnSubscribe(s -> {
            checkPoint.trigger(BEFORE_INVOCATION);
            checkPoint.awaitStrict(BEFORE_RELEASE, 20L, TimeUnit.SECONDS);
        }).doOnComplete(() -> {
            checkPoint.trigger(AFTER_INVOCATION);
            checkPoint.awaitStrict(AFTER_RELEASE, 20L, TimeUnit.SECONDS);
        });
    }

    public static <E> SegmentCompletionPublisher<E> blockingPublisher(SegmentCompletionPublisher<E> publisher, CheckPoint checkPoint) {
        return (s, complete) -> Mocks.blockingPublisher(innerSubscriber -> publisher.subscribe(innerSubscriber, complete), checkPoint).subscribe(s);
    }

    public static AbstractDelegatingHandler blockInboundCacheRpcCommand(Cache<?, ?> cache, final CheckPoint checkPoint, final Predicate<? super CacheRpcCommand> predicate) {
        final Executor executor = TestingUtil.extractGlobalComponent((CacheContainer)cache.getCacheManager(), ExecutorService.class, "org.infinispan.executors.non-blocking");
        return TestingUtil.wrapInboundInvocationHandler(cache, handler -> new AbstractDelegatingHandler((PerCacheInboundInvocationHandler)handler){

            public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
                if (!predicate.test(command)) {
                    this.delegate.handle(command, reply, order);
                    return;
                }
                checkPoint.trigger(Mocks.BEFORE_INVOCATION);
                ((CompletableFuture)checkPoint.future(Mocks.BEFORE_RELEASE, 20L, TimeUnit.SECONDS, executor).thenRun(() -> this.delegate.handle(command, reply, order))).thenCompose(ignored -> {
                    checkPoint.trigger(Mocks.AFTER_INVOCATION);
                    return checkPoint.future(Mocks.AFTER_RELEASE, 20L, TimeUnit.SECONDS, executor);
                });
            }
        });
    }

    public static <C> C replaceComponentWithSpy(Cache<?, ?> cache, Class<C> componentClass) {
        C component = TestingUtil.extractComponent(cache, componentClass);
        Object spiedComponent = Mockito.spy(component);
        TestingUtil.replaceComponent(cache, componentClass, spiedComponent, true);
        Mockito.reset((Object[])new Object[]{spiedComponent});
        return (C)spiedComponent;
    }
}

