/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.BiasAcquisition;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.MagicKey;
import org.infinispan.distribution.rehash.XAResourceAdapter;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.ReplListener;
import org.infinispan.test.SecurityActions;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.InCacheMode;
import org.infinispan.test.fwk.InTransactionMode;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TestFrameworkFailure;
import org.infinispan.test.fwk.TestSelector;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.IMethodInstance;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Factory;

@TestSelector(filters={CacheModeFilter.class, TransactionalModeFilter.class, LockingModeFilter.class, IsolationLevelFilter.class})
public abstract class MultipleCacheManagersTest
extends AbstractCacheTest {
    protected List<EmbeddedCacheManager> cacheManagers = Collections.synchronizedList(new ArrayList());
    protected IdentityHashMap<Cache<?, ?>, ReplListener> listeners = new IdentityHashMap();
    protected CacheMode cacheMode;
    protected Boolean transactional;
    protected LockingMode lockingMode;
    protected BiasAcquisition biasAcquisition;
    protected IsolationLevel isolationLevel;
    protected Boolean useTriangle;
    protected StorageType storageType;

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        this.checkFactoryAnnotation();
        if (this.cleanupAfterTest()) {
            this.callCreateCacheManagers();
        }
    }

    private void callCreateCacheManagers() throws Throwable {
        try {
            log.debug((Object)"Creating cache managers");
            this.createCacheManagers();
            log.debug((Object)"Cache managers created, ready to start the test");
        }
        catch (Throwable th) {
            log.error((Object)"Error in test setup: ", th);
            throw th;
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        if (this.cleanupAfterMethod()) {
            this.callCreateCacheManagers();
        }
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        if (this.cleanupAfterTest()) {
            TestingUtil.clearContent(this.cacheManagers);
            TestingUtil.killCacheManagers(this.cacheManagers);
        }
        if (this.cacheManagers != null) {
            for (EmbeddedCacheManager cm : this.cacheManagers) {
                String nodeName = SecurityActions.getCacheManagerConfiguration(cm).transport().nodeName();
                AssertJUnit.assertTrue((String)("Invalid node name for test " + TestResourceTracker.getCurrentTestShortName() + ": " + nodeName), (nodeName != null && nodeName.contains(TestResourceTracker.getCurrentTestShortName()) ? 1 : 0) != 0);
            }
            this.cacheManagers.clear();
        }
        this.listeners.clear();
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        if (this.cleanupAfterTest()) {
            log.debug((Object)"*** Test method complete; clearing contents on all caches.");
            TestingUtil.clearContent(this.cacheManagers);
        } else {
            TestingUtil.clearContent(this.cacheManagers);
            TestingUtil.killCacheManagers(this.cacheManagers);
            TestResourceTracker.cleanUpResources((String)this.getTestName());
            this.cacheManagers.clear();
        }
    }

    protected final void registerCacheManager(CacheContainer ... cacheContainers) {
        for (CacheContainer ecm : cacheContainers) {
            this.cacheManagers.add((EmbeddedCacheManager)ecm);
        }
    }

    protected final void registerCacheManager(List<? extends EmbeddedCacheManager> cacheContainers) {
        for (CacheContainer cacheContainer : cacheContainers) {
            this.cacheManagers.add((EmbeddedCacheManager)cacheContainer);
        }
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager() {
        return this.addClusterEnabledCacheManager(new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(false, this.defaultGlobalConfigurationBuilder(), null, flags);
        this.amendCacheManagerBeforeStart(cm);
        this.cacheManagers.add(cm);
        cm.start();
        return cm;
    }

    protected void amendCacheManagerBeforeStart(EmbeddedCacheManager cm) {
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder defaultConfig) {
        return this.addClusterEnabledCacheManager(defaultConfig, new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(SerializationContextInitializer sci) {
        return this.addClusterEnabledCacheManager(sci, null, new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(SerializationContextInitializer sci, ConfigurationBuilder defaultConfig) {
        return this.addClusterEnabledCacheManager(sci, defaultConfig, new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(SerializationContextInitializer sci, ConfigurationBuilder defaultConfig, TransportFlags flags) {
        GlobalConfigurationBuilder globalBuilder = this.defaultGlobalConfigurationBuilder();
        if (sci != null) {
            globalBuilder.serialization().addContextInitializer(sci);
        }
        return this.addClusterEnabledCacheManager(globalBuilder, defaultConfig, flags);
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder defaultConfig) {
        return this.addClusterEnabledCacheManager(globalBuilder, defaultConfig, new TransportFlags());
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilder builder, TransportFlags flags) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(false, this.defaultGlobalConfigurationBuilder(), builder, flags);
        this.amendCacheManagerBeforeStart(cm);
        this.cacheManagers.add(cm);
        cm.start();
        return cm;
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(ConfigurationBuilderHolder builderHolder) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(false, builderHolder);
        this.amendCacheManagerBeforeStart(cm);
        this.cacheManagers.add(cm);
        cm.start();
        return cm;
    }

    protected EmbeddedCacheManager addClusterEnabledCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder, TransportFlags flags) {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(false, globalBuilder, builder, flags);
        this.amendCacheManagerBeforeStart(cm);
        this.cacheManagers.add(cm);
        cm.start();
        return cm;
    }

    protected GlobalConfigurationBuilder defaultGlobalConfigurationBuilder() {
        return GlobalConfigurationBuilder.defaultClusteredBuilder();
    }

    protected void createCluster(int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager();
        }
    }

    protected void createCluster(ConfigurationBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager(builder);
        }
    }

    protected void createCluster(SerializationContextInitializer sci, ConfigurationBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager(sci, builder);
        }
    }

    protected void createCluster(Consumer<ConfigurationBuilderHolder> consumer, int count) {
        for (int i = 0; i < count; ++i) {
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder();
            holder.getGlobalConfigurationBuilder().clusteredDefault();
            consumer.accept(holder);
            this.addClusterEnabledCacheManager(holder);
        }
        this.waitForClusterToForm();
    }

    protected void createCluster(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder, int count) {
        for (int i = 0; i < count; ++i) {
            this.addClusterEnabledCacheManager(new GlobalConfigurationBuilder().read(globalBuilder.build()), builder);
        }
    }

    protected void defineConfigurationOnAllManagers(String cacheName, ConfigurationBuilder b) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            cm.defineConfiguration(cacheName, b.build());
        }
    }

    protected <K, V> List<Cache<K, V>> getCaches(String cacheName) {
        ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>();
        ArrayList<EmbeddedCacheManager> managers = new ArrayList<EmbeddedCacheManager>(this.cacheManagers);
        for (EmbeddedCacheManager cm : managers) {
            Cache c = cacheName == null ? cm.getCache() : cm.getCache(cacheName);
            caches.add(c);
        }
        return caches;
    }

    protected void waitForClusterToForm(String cacheName) {
        List caches = this.getCaches(cacheName);
        Cache cache = caches.get(0);
        TestingUtil.blockUntilViewsReceived(30000, caches);
        if (cache.getCacheConfiguration().clustering().cacheMode().isClustered()) {
            TestingUtil.waitForNoRebalance(caches);
        }
    }

    protected void waitForClusterToForm() {
        this.waitForClusterToForm((String)null);
    }

    protected void waitForClusterToForm(String ... names) {
        if (names != null && names.length != 0) {
            for (String name : names) {
                this.waitForClusterToForm(name);
            }
        } else {
            this.waitForClusterToForm();
        }
    }

    protected TransactionManager tm(Cache<?, ?> c) {
        return c.getAdvancedCache().getTransactionManager();
    }

    protected TransactionManager tm(int i, String cacheName) {
        return this.cache(i, cacheName).getAdvancedCache().getTransactionManager();
    }

    protected TransactionManager tm(int i) {
        return this.cache(i).getAdvancedCache().getTransactionManager();
    }

    protected Transaction tx(int i) {
        try {
            return this.cache(i).getAdvancedCache().getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    protected void createClusteredCaches(int numMembersInCluster, String cacheName, ConfigurationBuilder builder) {
        this.createClusteredCaches(numMembersInCluster, cacheName, null, builder);
    }

    protected void createClusteredCaches(int numMembersInCluster, String cacheName, SerializationContextInitializer sci, ConfigurationBuilder builder) {
        this.createClusteredCaches(numMembersInCluster, cacheName, sci, builder, new TransportFlags());
    }

    protected void createClusteredCaches(int numMembersInCluster, String cacheName, ConfigurationBuilder builder, TransportFlags flags) {
        this.createClusteredCaches(numMembersInCluster, null, builder, flags, cacheName);
    }

    protected void createClusteredCaches(int numMembersInCluster, String cacheName, SerializationContextInitializer sci, ConfigurationBuilder builder, TransportFlags flags) {
        this.createClusteredCaches(numMembersInCluster, sci, builder, flags, cacheName);
    }

    protected void createClusteredCaches(int numMembersInCluster, SerializationContextInitializer sci, ConfigurationBuilder defaultConfigBuilder) {
        this.createClusteredCaches(numMembersInCluster, sci, defaultConfigBuilder, new TransportFlags(), new String[0]);
    }

    protected void createClusteredCaches(int numMembersInCluster, SerializationContextInitializer sci, ConfigurationBuilder configBuilder, TransportFlags flags, String ... cacheNames) {
        GlobalConfigurationBuilder globalBuilder = this.defaultGlobalConfigurationBuilder();
        if (sci != null) {
            globalBuilder.serialization().addContextInitializer(sci);
        }
        this.createClusteredCaches(numMembersInCluster, globalBuilder, configBuilder, false, flags, cacheNames);
    }

    protected void createClusteredCaches(int numMembersInCluster, GlobalConfigurationBuilder globalConfigurationBuilder, ConfigurationBuilder defaultConfigBuilder, boolean serverMode, String ... cacheNames) {
        this.createClusteredCaches(numMembersInCluster, globalConfigurationBuilder, defaultConfigBuilder, serverMode, new TransportFlags(), cacheNames);
    }

    protected void createClusteredCaches(int numMembersInCluster, GlobalConfigurationBuilder globalConfigurationBuilder, ConfigurationBuilder configBuilder, boolean serverMode, TransportFlags flags, String ... cacheNames) {
        for (int i = 0; i < numMembersInCluster; ++i) {
            GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
            global.read(globalConfigurationBuilder.build());
            if (serverMode) {
                ((PrivateGlobalConfigurationBuilder)global.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
                global.transport().defaultTransport();
            }
            ConfigurationBuilder defaultBuilder = null;
            if (cacheNames.length == 0 || global.defaultCacheName().isPresent()) {
                defaultBuilder = configBuilder;
            }
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(global, defaultBuilder, flags);
            if (cacheNames.length == 0) {
                cm.getCache();
                continue;
            }
            for (String cacheName : cacheNames) {
                if (global.defaultCacheName().orElse("").equals(cacheName)) continue;
                cm.defineConfiguration(cacheName, configBuilder.build());
            }
        }
        this.waitForClusterToForm(cacheNames);
    }

    protected void createClusteredCaches(int numMembersInCluster, ConfigurationBuilder defaultConfigBuilder, boolean serverMode, String ... cacheNames) {
        this.createClusteredCaches(numMembersInCluster, this.defaultGlobalConfigurationBuilder(), defaultConfigBuilder, serverMode, cacheNames);
    }

    protected void createClusteredCaches(int numMembersInCluster, ConfigurationBuilder defaultConfigBuilder) {
        this.createClusteredCaches(numMembersInCluster, defaultConfigBuilder, false, new String[0]);
    }

    protected void createClusteredCaches(int numMembersInCluster, ConfigurationBuilder defaultConfig, TransportFlags flags) {
        for (int i = 0; i < numMembersInCluster; ++i) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(defaultConfig, flags);
            cm.getCache();
        }
        this.waitForClusterToForm();
    }

    protected void createClusteredCaches(int numMembersInCluster, ConfigurationBuilder defaultConfigBuilder, String ... cacheNames) {
        this.createClusteredCaches(numMembersInCluster, defaultConfigBuilder, new TransportFlags(), cacheNames);
    }

    protected void createClusteredCaches(int numMembersInCluster, ConfigurationBuilder configBuilder, TransportFlags transportFlags, String ... cacheNames) {
        for (int i = 0; i < numMembersInCluster; ++i) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(null, transportFlags);
            for (String cacheName : cacheNames) {
                cm.defineConfiguration(cacheName, configBuilder.build());
                cm.getCache(cacheName);
            }
        }
        this.waitForClusterToForm(cacheNames);
    }

    protected ReplListener replListener(Cache<?, ?> cache) {
        return this.listeners.computeIfAbsent(cache, k -> new ReplListener(cache));
    }

    protected EmbeddedCacheManager[] managers() {
        return this.cacheManagers.toArray(new EmbeddedCacheManager[0]);
    }

    protected EmbeddedCacheManager manager(int i) {
        return this.cacheManagers.get(i);
    }

    public EmbeddedCacheManager manager(Address a) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            if (!cm.getAddress().equals(a)) continue;
            return cm;
        }
        throw new IllegalArgumentException(a + " is not a valid cache manager address!");
    }

    public int managerIndex(Address a) {
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            EmbeddedCacheManager cm = this.cacheManagers.get(i);
            if (!cm.getAddress().equals(a)) continue;
            return i;
        }
        throw new IllegalArgumentException(a + " is not a valid cache manager address!");
    }

    protected <K, V> Cache<K, V> cache(int managerIndex, String cacheName) {
        return this.manager(managerIndex).getCache(cacheName);
    }

    protected void assertClusterSize(String message, int size) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            assert (cm.getMembers() != null && cm.getMembers().size() == size) : message;
        }
    }

    protected void removeCacheFromCluster(String cacheName) {
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            TestingUtil.killCaches(cm.getCache(cacheName));
        }
    }

    protected <A, B> Cache<A, B> cache(int index) {
        return this.manager(index).getCache();
    }

    protected <K, V> DataContainer<K, V> dataContainer(int index) {
        return this.advancedCache(index).getDataContainer();
    }

    public Object[] factory() {
        throw new IllegalStateException("Only overridden methods should be called!");
    }

    @Factory
    public Object[] defaultFactory() {
        Constructor<?> ctor;
        List<Consumer[]> allModifiers;
        try {
            Method factory = this.getClass().getMethod("factory", new Class[0]);
            if (factory.getDeclaringClass() == this.getClass()) {
                if (this.getClass().getAnnotation(InCacheMode.class) != null || this.getClass().getAnnotation(InTransactionMode.class) != null) {
                    return new Object[]{new TestFrameworkFailure(this.getClass(), new IllegalStateException("Tests with factory() methods ignore @InCacheMode and @InTransactionMode annotations, please remove them."))};
                }
                Object[] instances = this.factory();
                for (int i = 0; i < instances.length; ++i) {
                    if (instances[i].getClass() == this.getClass()) continue;
                    instances[i] = new TestFrameworkFailure(this.getClass(), "%s.factory() creates instances of %s", this.getClass().getName(), instances[i].getClass().getName());
                }
                return instances;
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Every class should have factory method, at least inherited", e);
        }
        try {
            Consumer<MultipleCacheManagersTest>[] cacheModeModifiers = this.getModifiers(InCacheMode.class, InCacheMode::value, MultipleCacheManagersTest::cacheMode);
            Consumer<MultipleCacheManagersTest>[] transactionModifiers = this.getModifiers(InTransactionMode.class, InTransactionMode::value, (t, m) -> t.transactional(m.isTransactional()));
            allModifiers = Arrays.asList(cacheModeModifiers, transactionModifiers);
        }
        catch (Exception e) {
            return new Object[]{new TestFrameworkFailure(this.getClass(), e)};
        }
        int numTests = allModifiers.stream().mapToInt(m -> ((Consumer[])m).length).reduce(1, (m1, m2) -> m1 * m2);
        Object[] tests = new Object[numTests];
        tests[0] = this;
        try {
            ctor = this.getClass().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return new Object[]{new TestFrameworkFailure(this.getClass(), "Missing no-arg constructor in %s", this.getClass().getName())};
        }
        for (int i = 1; i < tests.length; ++i) {
            try {
                tests[i] = ctor.newInstance(new Object[0]);
                continue;
            }
            catch (Exception e) {
                return new Object[]{new TestFrameworkFailure(this.getClass(), e)};
            }
        }
        int stride = 1;
        for (Consumer[] modifiers : allModifiers) {
            this.applyModifiers(tests, modifiers, stride);
            stride *= modifiers.length;
        }
        return tests;
    }

    private void checkFactoryAnnotation() {
        for (Method m : this.getClass().getMethods()) {
            if (m.getAnnotation(Factory.class) == null || m.getDeclaringClass() == MultipleCacheManagersTest.class) continue;
            throw new IllegalStateException("Test " + this.getClass().getName() + " extends MultipleCacheManagersTest and declares its own @Factory method: " + m.getName());
        }
    }

    private void applyModifiers(Object[] tests, Consumer<MultipleCacheManagersTest>[] modifiers, int stride) {
        int mi = 0;
        for (int i = 0; i < tests.length; i += stride) {
            for (int j = 0; j < stride; ++j) {
                modifiers[mi].accept((MultipleCacheManagersTest)tests[i + j]);
            }
            mi = (mi + 1) % modifiers.length;
        }
    }

    private <Mode, A extends Annotation> Consumer<MultipleCacheManagersTest>[] getModifiers(Class<A> annotationClass, Function<A, Mode[]> methodRetriever, BiConsumer<MultipleCacheManagersTest, Mode> applier) {
        Mode[] classModes = this.classModes(annotationClass, methodRetriever);
        Set<Mode> methodModes = this.methodModes(annotationClass, methodRetriever);
        if (classModes == null && methodModes == null) {
            return new Consumer[]{t -> {}};
        }
        HashSet<Mode> allModes = new HashSet<Mode>();
        if (classModes != null) {
            allModes.addAll(Arrays.asList(classModes));
        }
        if (methodModes != null && !allModes.containsAll(methodModes)) {
            throw new IllegalStateException("Test methods cannot declare cache mode/transaction filters that the test class hasn't declared");
        }
        return (Consumer[])allModes.stream().map(mode -> t -> applier.accept((MultipleCacheManagersTest)t, (Object)mode)).toArray(Consumer[]::new);
    }

    protected <Mode, A extends Annotation> Set<Mode> methodModes(Class<A> annotationClass, Function<A, Mode[]> modeRetriever) {
        HashSet modes = null;
        for (Method m : this.getClass().getMethods()) {
            A annotation = m.getAnnotation(annotationClass);
            if (annotation == null) continue;
            if (modes == null) {
                modes = new HashSet();
            }
            Collections.addAll(modes, modeRetriever.apply(annotation));
        }
        return modes;
    }

    protected <Mode, A extends Annotation> Mode[] classModes(Class<A> annotationClass, Function<A, Mode[]> modeRetriever) {
        A annotation = this.getClass().getDeclaredAnnotation(annotationClass);
        if (annotation == null) {
            return null;
        }
        return modeRetriever.apply(annotation);
    }

    public MultipleCacheManagersTest cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public MultipleCacheManagersTest transactional(boolean transactional) {
        this.transactional = transactional;
        return this;
    }

    public MultipleCacheManagersTest lockingMode(LockingMode lockingMode) {
        this.lockingMode = lockingMode;
        return this;
    }

    public MultipleCacheManagersTest isolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    public MultipleCacheManagersTest biasAcquisition(BiasAcquisition biasAcquisition) {
        this.biasAcquisition = biasAcquisition;
        return this;
    }

    public TransactionMode transactionMode() {
        return this.transactional != false ? TransactionMode.TRANSACTIONAL : TransactionMode.NON_TRANSACTIONAL;
    }

    public MultipleCacheManagersTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @Override
    protected String parameters() {
        return MultipleCacheManagersTest.defaultParametersString(this.parameterNames(), this.parameterValues());
    }

    protected String[] parameterNames() {
        return new String[]{null, "tx", "locking", "isolation", "bias", "triangle", null};
    }

    protected Object[] parameterValues() {
        return new Object[]{this.cacheMode, this.transactional, this.lockingMode, this.isolationLevel, this.biasAcquisition, this.useTriangle, this.storageType};
    }

    @SafeVarargs
    protected static <T> T[] concat(T[] a1, T ... a2) {
        T[] na = Arrays.copyOf(a1, a1.length + a2.length);
        System.arraycopy(a2, 0, na, a1.length, a2.length);
        return na;
    }

    protected abstract void createCacheManagers() throws Throwable;

    protected Address address(int cacheIndex) {
        return this.manager(cacheIndex).getAddress();
    }

    protected <A, B> AdvancedCache<A, B> advancedCache(int i) {
        return this.cache(i).getAdvancedCache();
    }

    protected <A, B> AdvancedCache<A, B> advancedCache(int i, String cacheName) {
        return this.cache(i, cacheName).getAdvancedCache();
    }

    protected <K, V> List<Cache<K, V>> caches(String name) {
        return this.getCaches(name);
    }

    protected <K, V> List<Cache<K, V>> caches() {
        return this.caches(null);
    }

    protected Address address(Cache<?, ?> c) {
        return c.getAdvancedCache().getRpcManager().getAddress();
    }

    protected LockManager lockManager(int i) {
        return TestingUtil.extractLockManager(this.cache(i));
    }

    protected LockManager lockManager(int i, String cacheName) {
        return TestingUtil.extractLockManager(this.getCache(i, cacheName));
    }

    protected LocalizedCacheTopology cacheTopology(int i) {
        return TestingUtil.extractCacheTopology(this.cache(i));
    }

    protected LocalizedCacheTopology cacheTopology(int i, String cacheName) {
        return TestingUtil.extractCacheTopology(this.cache(i, cacheName));
    }

    public List<EmbeddedCacheManager> getCacheManagers() {
        return this.cacheManagers;
    }

    protected void killMember(int cacheIndex) {
        this.killMember(cacheIndex, null);
    }

    protected void killMember(int cacheIndex, String cacheName) {
        this.killMember(cacheIndex, cacheName, true);
    }

    protected void killMember(int cacheIndex, String cacheName, boolean awaitRehash) {
        List caches = this.caches(cacheName);
        caches.remove(cacheIndex);
        this.manager(cacheIndex).stop();
        this.cacheManagers.remove(cacheIndex);
        if (awaitRehash && caches.size() > 0) {
            TestingUtil.blockUntilViewsReceived(60000, false, caches);
            TestingUtil.waitForNoRebalance(caches);
        }
    }

    protected Object getKeyForCache(int nodeIndex) {
        Cache cache = this.cache(nodeIndex);
        return this.getKeyForCache(cache);
    }

    protected Object getKeyForCache(int nodeIndex, String cacheName) {
        Cache cache = this.cache(nodeIndex, cacheName);
        return this.getKeyForCache(cache);
    }

    protected <K> Supplier<K> supplyKeyForCache(int nodeIndex, String cacheName) {
        return () -> this.getKeyForCache(nodeIndex, cacheName);
    }

    protected MagicKey getKeyForCache(Cache<?, ?> cache) {
        return new MagicKey(cache);
    }

    protected MagicKey getKeyForCache(Cache<?, ?> primary, Cache<?, ?> ... backup) {
        if (this.cacheMode == null || !this.cacheMode.isScattered()) {
            return new MagicKey(primary, backup);
        }
        return new MagicKey(primary);
    }

    protected void assertNotLocked(String cacheName, Object key) {
        this.eventually(() -> {
            boolean aNodeIsLocked = false;
            for (int i = 0; i < this.caches(cacheName).size(); ++i) {
                boolean isLocked = this.lockManager(i, cacheName).isLocked(key);
                if (isLocked) {
                    log.trace((Object)(key + " is locked on cache index " + i + " by " + this.lockManager(i, cacheName).getOwner(key)));
                }
                aNodeIsLocked = aNodeIsLocked || isLocked;
            }
            return !aNodeIsLocked;
        });
    }

    protected void assertNotLocked(Object key) {
        this.assertNotLocked((String)null, key);
    }

    protected boolean checkTxCount(int cacheIndex, int localTx, int remoteTx) {
        int localTxCount = this.getLocalTxCount(cacheIndex);
        int remoteTxCount = this.getRemoteTxCount(cacheIndex);
        log.tracef("Cache index %s, local tx %4s, remote tx %4s \n", cacheIndex, localTxCount, remoteTxCount);
        return localTxCount == localTx && remoteTxCount == remoteTx;
    }

    protected int getRemoteTxCount(int cacheIndex) {
        return TestingUtil.getTransactionTable(this.cache(cacheIndex)).getRemoteTxCount();
    }

    protected int getLocalTxCount(int cacheIndex) {
        return TestingUtil.getTransactionTable(this.cache(cacheIndex)).getLocalTxCount();
    }

    protected void assertNotLocked(int cacheIndex, Object key) {
        this.assertEventuallyNotLocked(this.cache(cacheIndex), key);
    }

    protected void assertLocked(int cacheIndex, Object key) {
        this.assertLocked(this.cache(cacheIndex), key);
    }

    protected boolean checkLocked(int index, Object key) {
        return this.checkLocked(this.cache(index), key);
    }

    protected <K, V> Cache<K, V> getLockOwner(Object key) {
        return this.getLockOwner(key, null);
    }

    protected <K, V> Cache<K, V> getLockOwner(Object key, String cacheName) {
        Configuration c = this.getCache(0, cacheName).getCacheConfiguration();
        if (c.clustering().cacheMode().isInvalidation()) {
            return this.getCache(0, cacheName);
        }
        if (!c.clustering().cacheMode().isClustered()) {
            throw new IllegalStateException("This is not a clustered cache!");
        }
        Address address = this.getCache(0, cacheName).getAdvancedCache().getDistributionManager().getCacheTopology().getDistribution(key).primary();
        for (Cache<K, V> cache : this.caches(cacheName)) {
            if (!cache.getAdvancedCache().getRpcManager().getTransport().getAddress().equals(address)) continue;
            return cache;
        }
        throw new IllegalStateException();
    }

    protected void assertKeyLockedCorrectly(Object key) {
        this.assertKeyLockedCorrectly(key, null);
    }

    protected void assertKeyLockedCorrectly(Object key, String cacheName) {
        Cache lockOwner = this.getLockOwner(key, cacheName);
        for (Cache c : this.caches(cacheName)) {
            if (c != lockOwner) {
                this.assertNotLocked(c, key);
                continue;
            }
            this.assertLocked(c, key);
        }
    }

    private <K, V> Cache<K, V> getCache(int index, String name) {
        return name == null ? this.cache(index) : this.cache(index, name);
    }

    protected void forceTwoPhase(int cacheIndex) throws SystemException, RollbackException {
        TransactionManager tm = this.tm(cacheIndex);
        Transaction tx = tm.getTransaction();
        tx.enlistResource((XAResource)new XAResourceAdapter());
    }

    protected void assertNoTransactions() {
        this.assertNoTransactions(null);
    }

    protected void assertNoTransactions(String cacheName) {
        this.eventually("There are pending transactions!", () -> {
            for (Cache cache : this.caches(cacheName)) {
                TransactionTable transactionTable = TestingUtil.extractComponent(cache, TransactionTable.class);
                int localTxCount = transactionTable.getLocalTxCount();
                int remoteTxCount = transactionTable.getRemoteTxCount();
                if (localTxCount == 0 && remoteTxCount == 0) continue;
                log.tracef("Local tx=%s, remote tx=%s, for cache %s ", (Object)transactionTable.getLocalGlobalTransaction(), (Object)transactionTable.getRemoteGlobalTransaction(), (Object)this.address(cache));
                return false;
            }
            return true;
        });
    }

    protected TransactionTable transactionTable(int cacheIndex) {
        return TestingUtil.extractComponent(this.cache(cacheIndex), TransactionTable.class);
    }

    protected void assertEventuallyEquals(int cacheIndex, Object key, Object value) {
        this.eventually(() -> value == null ? null == this.cache(cacheIndex).get(key) : value.equals(this.cache(cacheIndex).get(key)));
    }

    public MultipleCacheManagersTest useTriangle(boolean useTriangle) {
        this.useTriangle = useTriangle;
        return this;
    }

    public static class IsolationLevelFilter
    extends FilterByProperty<IsolationLevel> {
        public IsolationLevelFilter() {
            super("test.infinispan.isolationLevel", test -> test.isolationLevel);
        }
    }

    public static class LockingModeFilter
    extends FilterByProperty<LockingMode> {
        public LockingModeFilter() {
            super("test.infinispan.lockingMode", test -> test.lockingMode);
        }
    }

    protected static abstract class FilterByProperty<T>
    implements Predicate<IMethodInstance> {
        private final String property;
        private final Function<MultipleCacheManagersTest, T> getMode;

        public FilterByProperty(String property, Function<MultipleCacheManagersTest, T> getMode) {
            this.property = System.getProperty(property);
            this.getMode = getMode;
        }

        @Override
        public boolean test(IMethodInstance method) {
            if (this.property == null) {
                return true;
            }
            T mode = this.getMode.apply((MultipleCacheManagersTest)method.getInstance());
            return mode == null || mode.toString().equalsIgnoreCase(this.property);
        }
    }

    public static class TransactionalModeFilter
    extends AnnotationFilter<InTransactionMode, TransactionMode, Boolean>
    implements Predicate<IMethodInstance> {
        private final String txModeString = System.getProperty("test.infinispan.transactional");

        public TransactionalModeFilter() {
            super(InTransactionMode.class, InTransactionMode::value, (m, b) -> b == Boolean.valueOf(m.isTransactional()));
        }

        @Override
        public boolean test(IMethodInstance method) {
            Boolean transactional = ((MultipleCacheManagersTest)method.getInstance()).transactional;
            if (this.txModeString != null && transactional != null && !transactional.toString().equalsIgnoreCase(this.txModeString)) {
                return false;
            }
            return this.test(transactional, method);
        }
    }

    public static class CacheModeFilter
    extends AnnotationFilter<InCacheMode, CacheMode, CacheMode>
    implements Predicate<IMethodInstance> {
        private final String cacheModeString = System.getProperty("test.infinispan.cacheMode");

        public CacheModeFilter() {
            super(InCacheMode.class, InCacheMode::value, (m1, m2) -> m1 == m2);
        }

        @Override
        public boolean test(IMethodInstance method) {
            CacheMode cacheMode = ((MultipleCacheManagersTest)method.getInstance()).cacheMode;
            if (this.cacheModeString != null && cacheMode != null && !cacheMode.friendlyCacheModeString().equalsIgnoreCase(this.cacheModeString)) {
                return false;
            }
            return this.test(cacheMode, method);
        }
    }

    protected static abstract class AnnotationFilter<A extends Annotation, AM, CM> {
        private final Class<A> annotationClazz;
        private final Function<A, AM[]> modesRetriever;
        private final BiPredicate<AM, CM> modeChecker;

        protected AnnotationFilter(Class<A> annotationClazz, Function<A, AM[]> modesRetriever, BiPredicate<AM, CM> modeChecker) {
            this.annotationClazz = annotationClazz;
            this.modesRetriever = modesRetriever;
            this.modeChecker = modeChecker;
        }

        public boolean test(CM mode, IMethodInstance method) {
            A methodAnnotation = method.getMethod().getConstructorOrMethod().getMethod().getAnnotation(this.annotationClazz);
            if (methodAnnotation != null) {
                return Stream.of(this.modesRetriever.apply(methodAnnotation)).anyMatch(m -> this.modeChecker.test(m, mode));
            }
            return true;
        }
    }
}

