/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheManagerConfigurationAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;

final class SecurityActions {
    SecurityActions() {
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static void stopManager(EmbeddedCacheManager cacheManager) {
        SecurityActions.doPrivileged(() -> {
            cacheManager.stop();
            return null;
        });
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(new GetGlobalComponentRegistryAction(cacheManager));
    }

    static ComponentRegistry getComponentRegistry(Cache cache) {
        return SecurityActions.doPrivileged(() -> cache.getAdvancedCache().getComponentRegistry());
    }

    static GlobalConfiguration getCacheManagerConfiguration(EmbeddedCacheManager cacheManager) {
        return (GlobalConfiguration)SecurityActions.doPrivileged(new GetCacheManagerConfigurationAction(cacheManager));
    }
}

