/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SecurityActions;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class SingleCacheManagerTest
extends AbstractCacheTest {
    protected EmbeddedCacheManager cacheManager;
    protected Cache<Object, Object> cache;

    protected void setup() throws Exception {
        this.cacheManager = this.createCacheManager();
        if (this.cache == null && SecurityActions.getCacheManagerConfiguration(this.cacheManager).defaultCacheName().isPresent()) {
            this.cache = this.cacheManager.getCache();
        }
    }

    protected void teardown() {
        TestingUtil.clearContent(this.cacheManager);
        TestingUtil.killCacheManagers(this.cacheManager);
        this.cache = null;
        this.cacheManager = null;
    }

    protected void clearCacheManager() {
        TestingUtil.clearContent(this.cacheManager);
    }

    @BeforeClass(alwaysRun=true)
    protected void createBeforeClass() throws Exception {
        try {
            if (this.cleanupAfterTest()) {
                this.setup();
            } else assert (this.cleanupAfterMethod()) : "you must either cleanup after test or after method";
        }
        catch (Exception e) {
            log.error((Object)"Unexpected!", (Throwable)e);
            throw e;
        }
    }

    @BeforeMethod(alwaysRun=true)
    protected void createBeforeMethod() throws Exception {
        try {
            if (this.cleanupAfterMethod()) {
                this.setup();
            } else assert (this.cleanupAfterTest()) : "you must either cleanup after test or after method";
        }
        catch (Exception e) {
            log.error((Object)"Unexpected!", (Throwable)e);
            throw e;
        }
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        try {
            if (this.cleanupAfterTest()) {
                this.teardown();
            }
        }
        catch (Exception e) {
            log.error((Object)"Unexpected!", (Throwable)e);
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void destroyAfterMethod() {
        if (this.cleanupAfterMethod()) {
            this.teardown();
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() {
        if (this.cleanupAfterTest()) {
            this.clearCacheManager();
        }
    }

    protected ConfigurationBuilder getDefaultStandaloneCacheConfig(boolean transactional) {
        return TestCacheManagerFactory.getDefaultCacheConfiguration(transactional);
    }

    protected TransactionManager tm() {
        return this.cache.getAdvancedCache().getTransactionManager();
    }

    protected Transaction tx() {
        try {
            return this.cache.getAdvancedCache().getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    protected LockManager lockManager(String cacheName) {
        return TestingUtil.extractLockManager(this.cacheManager.getCache(cacheName));
    }

    protected LockManager lockManager() {
        return TestingUtil.extractLockManager(this.cache);
    }

    protected abstract EmbeddedCacheManager createCacheManager() throws Exception;

    protected <K, V> Cache<K, V> cache() {
        return this.cache;
    }

    protected <K, V> Cache<K, V> cache(String name) {
        return this.cacheManager.getCache(name);
    }

    protected void assertNoTransactions() {
        this.assertNoTransactions(this.cache);
    }

    protected void assertNoTransactions(Cache<?, ?> cache) {
        this.eventually(() -> {
            int localTxCount = TestingUtil.extractComponent(cache, TransactionTable.class).getLocalTxCount();
            if (localTxCount != 0) {
                log.tracef("Local tx=%s", localTxCount);
                return false;
            }
            return true;
        });
    }
}

