/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.testng.Assert;

@Listener(observation=Listener.Observation.POST)
public class TopologyChangeListener {
    private final CountDownLatch latch = new CountDownLatch(1);

    public static TopologyChangeListener install(Cache cache) {
        TopologyChangeListener listener = new TopologyChangeListener();
        cache.addListener((Object)listener);
        return listener;
    }

    @TopologyChanged
    public void onTopologyChange(TopologyChangedEvent event) {
        this.latch.countDown();
    }

    public void await() throws InterruptedException {
        this.await(10L, TimeUnit.SECONDS);
    }

    public void await(long time, TimeUnit unit) throws InterruptedException {
        Assert.assertTrue((boolean)this.latch.await(time, unit), (String)("View change not seen after " + time + " " + (Object)((Object)unit)));
    }
}

