/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.test.concurrent.CommandMatcher;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;

public class InterceptorSequencerAction {
    private final StateSequencer stateSequencer;
    private final Cache<?, ?> cache;
    private final Class<? extends AsyncInterceptor> interceptorClass;
    private CommandMatcher matcher;
    private SequencerInterceptor ourInterceptor;

    public InterceptorSequencerAction(StateSequencer stateSequencer, Cache<?, ?> cache, Class<? extends AsyncInterceptor> interceptorClass, CommandMatcher matcher) {
        this.stateSequencer = stateSequencer;
        this.cache = cache;
        this.interceptorClass = interceptorClass;
        this.matcher = matcher;
    }

    public InterceptorSequencerAction before(String state1, String ... additionalStates) {
        this.initOurInterceptor();
        this.ourInterceptor.beforeStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    private void initOurInterceptor() {
        if (this.ourInterceptor == null) {
            this.ourInterceptor = SequencerInterceptor.createUniqueInterceptor(this.cache.getAdvancedCache().getAsyncInterceptorChain());
            this.ourInterceptor.init(this.stateSequencer, this.matcher);
            this.cache.getAdvancedCache().getAsyncInterceptorChain().addInterceptorBefore((AsyncInterceptor)this.ourInterceptor, this.interceptorClass);
        }
    }

    public InterceptorSequencerAction after(String state1, String ... additionalStates) {
        this.initOurInterceptor();
        this.ourInterceptor.afterStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    public static class SequencerInterceptor
    extends BaseAsyncInterceptor {
        private static final Class[] uniqueInterceptorClasses = new Class[]{U1.class, U2.class, U3.class, U4.class, U5.class, U6.class, U7.class, U8.class, U9.class};
        private StateSequencer stateSequencer;
        private CommandMatcher matcher;
        private volatile List<String> statesBefore;
        private volatile List<String> statesAfter;

        public static SequencerInterceptor createUniqueInterceptor(AsyncInterceptorChain chain) {
            Class<?> uniqueClass = SequencerInterceptor.findUniqueClass(chain);
            try {
                return (SequencerInterceptor)((Object)uniqueClass.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot instantiate unique interceptor", e);
            }
        }

        public static Class<?> findUniqueClass(AsyncInterceptorChain chain) {
            for (Class clazz : uniqueInterceptorClasses) {
                if (chain.containsInterceptorType(clazz)) continue;
                return clazz;
            }
            throw new IllegalStateException("Too many sequencer interceptors added to the same chain");
        }

        public void init(StateSequencer stateSequencer, CommandMatcher matcher) {
            this.stateSequencer = stateSequencer;
            this.matcher = matcher;
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            boolean commandAccepted = this.matcher.accept((ReplicableCommand)command);
            StateSequencerUtil.advanceMultiple(this.stateSequencer, commandAccepted, this.statesBefore);
            return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> StateSequencerUtil.advanceMultiple(this.stateSequencer, commandAccepted, this.statesAfter));
        }

        public void beforeStates(List<String> states) {
            this.statesBefore = StateSequencerUtil.listCopy(states);
        }

        public void afterStates(List<String> states) {
            this.statesAfter = StateSequencerUtil.listCopy(states);
        }

        public static class U9
        extends SequencerInterceptor {
        }

        public static class U8
        extends SequencerInterceptor {
        }

        public static class U7
        extends SequencerInterceptor {
        }

        public static class U6
        extends SequencerInterceptor {
        }

        public static class U5
        extends SequencerInterceptor {
        }

        public static class U4
        extends SequencerInterceptor {
        }

        public static class U3
        extends SequencerInterceptor {
        }

        public static class U2
        extends SequencerInterceptor {
        }

        public static class U1
        extends SequencerInterceptor {
        }
    }
}

