/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.concurrent.CommandMatcher;
import org.infinispan.test.concurrent.StateSequencer;
import org.infinispan.test.concurrent.StateSequencerUtil;
import org.infinispan.util.AbstractDelegatingRpcManager;

public class OutboundRpcSequencerAction {
    private final StateSequencer stateSequencer;
    private final Cache<?, ?> cache;
    private final CommandMatcher matcher;
    private SequencerRpcManager ourRpcManager;

    public OutboundRpcSequencerAction(StateSequencer stateSequencer, Cache<?, ?> cache, CommandMatcher matcher) {
        this.stateSequencer = stateSequencer;
        this.cache = cache;
        this.matcher = matcher;
    }

    public OutboundRpcSequencerAction before(String state1, String ... additionalStates) {
        this.replaceRpcManager();
        this.ourRpcManager.beforeStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    private void replaceRpcManager() {
        if (this.ourRpcManager == null) {
            ComponentRegistry componentRegistry = this.cache.getAdvancedCache().getComponentRegistry();
            RpcManager rpcManager = (RpcManager)componentRegistry.getComponent(RpcManager.class);
            this.ourRpcManager = new SequencerRpcManager(rpcManager, this.stateSequencer, this.matcher);
            TestingUtil.replaceComponent(this.cache, RpcManager.class, this.ourRpcManager, true);
        }
    }

    public OutboundRpcSequencerAction after(String state1, String ... additionalStates) {
        this.replaceRpcManager();
        this.ourRpcManager.afterStates(StateSequencerUtil.concat(state1, additionalStates));
        return this;
    }

    public static class SequencerRpcManager
    extends AbstractDelegatingRpcManager {
        private final StateSequencer stateSequencer;
        private final CommandMatcher matcher;
        private volatile List<String> statesBefore;
        private volatile List<String> statesAfter;

        public SequencerRpcManager(RpcManager rpcManager, StateSequencer stateSequencer, CommandMatcher matcher) {
            super(rpcManager);
            this.stateSequencer = stateSequencer;
            this.matcher = matcher;
        }

        @Override
        protected <T> CompletionStage<T> performRequest(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, Function<ResponseCollector<T>, CompletionStage<T>> invoker, RpcOptions rpcOptions) {
            boolean accept;
            try {
                accept = this.matcher.accept(command);
                StateSequencerUtil.advanceMultiple(this.stateSequencer, accept, this.statesBefore);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            CompletionStage<Object> stage = super.performRequest(targets, command, collector, invoker, rpcOptions);
            if (stage != null) {
                return stage.whenComplete((result, throwable) -> this.advanceNoThrow(accept));
            }
            this.advanceNoThrow(accept);
            return null;
        }

        private void advanceNoThrow(boolean accept) {
            try {
                StateSequencerUtil.advanceMultiple(this.stateSequencer, accept, this.statesAfter);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void beforeStates(List<String> states) {
            this.statesBefore = StateSequencerUtil.listCopy(states);
        }

        public void afterStates(List<String> states) {
            this.statesAfter = StateSequencerUtil.listCopy(states);
        }
    }
}

