/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateSequencer {
    private static final Log log = LogFactory.getLog(StateSequencer.class);
    private final Map<String, LogicalThread> logicalThreads = new HashMap<String, LogicalThread>();
    private final Map<String, State> stateMap = new HashMap<String, State>();
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final long defaultTimeoutNanos;
    private boolean running = true;

    public StateSequencer() {
        this(30L, TimeUnit.SECONDS);
    }

    public StateSequencer(long defaultTimeout, TimeUnit unit) {
        this.defaultTimeoutNanos = unit.toNanos(defaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateSequencer logicalThread(String threadName, String initialState, String ... additionalStates) {
        this.lock.lock();
        try {
            List<String> states;
            if (this.logicalThreads.containsKey(threadName)) {
                throw new IllegalArgumentException("Logical thread " + threadName + " already exists");
            }
            if (additionalStates == null) {
                states = Collections.singletonList(initialState);
            } else {
                states = new ArrayList<String>(additionalStates.length + 1);
                states.add(initialState);
                states.addAll(Arrays.asList(additionalStates));
            }
            LogicalThread thread = new LogicalThread(threadName, states);
            this.logicalThreads.put(threadName, thread);
            for (String stateName : states) {
                if (this.stateMap.containsKey(stateName)) {
                    throw new IllegalArgumentException("State " + stateName + " already exists");
                }
                State state = new State(threadName, stateName);
                this.stateMap.put(stateName, state);
            }
            this.doOrder(states);
            log.tracef("Added logical thread %s, with states %s", (Object)threadName, states);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOrder(List<String> orderedStates) {
        this.lock.lock();
        try {
            for (int i = 0; i < orderedStates.size(); ++i) {
                State state = this.stateMap.get(orderedStates.get(i));
                if (state == null) {
                    throw new IllegalArgumentException("Cannot order a non-existing state: " + orderedStates.get(i));
                }
                if (i <= 0) continue;
                state.dependencies.add(orderedStates.get(i - 1));
            }
            this.verifyCycles();
            log.tracef("Order changed: %s", (Object)this.getOrderString());
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void verifyCycles() {
        this.visitInOrder(new StatesVisitor(){

            @Override
            public void visitStates(List<String> visitedStates) {
            }

            @Override
            public void visitCycle(Collection<String> remainingStates) {
                throw new IllegalStateException("Cycle detected: " + remainingStates);
            }
        });
    }

    private String getOrderString() {
        final StringBuilder sb = new StringBuilder();
        this.visitInOrder(new StatesVisitor(){

            @Override
            public void visitStates(List<String> visitedStates) {
                if (sb.length() > 1) {
                    sb.append(" < ");
                }
                if (visitedStates.size() == 1) {
                    sb.append(visitedStates.get(0));
                } else {
                    sb.append(visitedStates);
                }
            }

            @Override
            public void visitCycle(Collection<String> remainingStates) {
                sb.append("cycle: ").append(remainingStates);
            }
        });
        return sb.toString();
    }

    @GuardedBy(value="lock")
    private void visitInOrder(StatesVisitor visitor) {
        HashSet<String> visitedStates = new HashSet<String>();
        HashSet<String> remainingStates = new HashSet<String>(this.stateMap.keySet());
        while (!remainingStates.isEmpty()) {
            ArrayList<String> freeStates = new ArrayList<String>();
            Iterator it = remainingStates.iterator();
            while (it.hasNext()) {
                State s = this.stateMap.get(it.next());
                if (!visitedStates.containsAll(s.dependencies)) continue;
                freeStates.add(s.name);
                it.remove();
            }
            visitedStates.addAll(freeStates);
            if (freeStates.size() != 0) {
                visitor.visitStates(freeStates);
                continue;
            }
            visitor.visitCycle(remainingStates);
        }
    }

    public StateSequencer order(String state1, String state2, String ... additionalStates) {
        ArrayList<String> allStates;
        if (additionalStates == null) {
            allStates = new ArrayList<String>(Arrays.asList(state1, state2));
        } else {
            allStates = new ArrayList<String>(additionalStates.length + 2);
            allStates.add(state1);
            allStates.add(state2);
            allStates.addAll(Arrays.asList(additionalStates));
        }
        this.doOrder(allStates);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateSequencer action(String stateName, Callable<Object> action) {
        this.lock.lock();
        try {
            State state = this.stateMap.get(stateName);
            if (state == null) {
                throw new IllegalArgumentException("Trying to add an action for an invalid state: " + stateName);
            }
            if (state.action != null) {
                throw new IllegalStateException("Trying to overwrite an existing action for state " + stateName);
            }
            state.action = action;
            log.tracef("Action added for state %s", (Object)stateName);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public void advance(String state, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        this.enter(state, timeout, unit);
        this.exit(state);
    }

    public void enter(String stateName, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        this.doEnter(stateName, unit.toNanos(timeout));
    }

    public void exit(String stateName) {
        log.tracef("Exiting state %s", (Object)stateName);
        this.lock.lock();
        try {
            if (!this.running) {
                return;
            }
            State state = this.stateMap.get(stateName);
            if (state.signalled) {
                throw new IllegalStateException(String.format("State %s exited twice", stateName));
            }
            state.signalled = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEnter(String stateName, long nanos) throws InterruptedException, TimeoutException {
        block9: {
            this.lock.lock();
            try {
                State state = this.stateMap.get(stateName);
                if (state == null) {
                    throw new IllegalArgumentException("Trying to advance to a non-existing state: " + stateName);
                }
                if (!this.running) {
                    log.tracef("Sequencer stopped, not entering state %s", (Object)stateName);
                    return;
                }
                log.tracef("Waiting for states %s to enter %s", state.dependencies, (Object)stateName);
                for (String dependency : state.dependencies) {
                    State depState = this.stateMap.get(dependency);
                    nanos = this.waitForState(depState, nanos);
                    if (nanos > 0L || depState.signalled) continue;
                    this.reportTimeout(state);
                }
                log.tracef("Entering state %s", (Object)stateName);
                this.logicalThreads.get(state.threadName).setCurrentState(stateName);
                if (state.action == null) break block9;
                try {
                    state.action.call();
                }
                catch (Exception e) {
                    throw new RuntimeException("Action failed for state " + stateName, e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @GuardedBy(value="lock")
    private long waitForState(State state, long nanos) throws InterruptedException {
        while (this.running && !state.signalled && nanos > 0L) {
            nanos = this.condition.awaitNanos(nanos);
        }
        return nanos;
    }

    @GuardedBy(value="lock")
    private void reportTimeout(State state) throws TimeoutException {
        ArrayList<String> timedOutStates = new ArrayList<String>(1);
        for (String dependencyName : state.dependencies) {
            State dependency = this.stateMap.get(dependencyName);
            if (dependency.signalled) continue;
            timedOutStates.add(dependencyName);
        }
        String errorMessage = String.format("Timed out waiting to enter state %s. Dependencies not satisfied are %s", state.name, timedOutStates);
        log.trace((Object)errorMessage);
        throw new TimeoutException(errorMessage);
    }

    public void advance(String state) throws TimeoutException, InterruptedException {
        this.enter(state);
        this.exit(state);
    }

    public void enter(String stateName) throws TimeoutException, InterruptedException {
        this.doEnter(stateName, this.defaultTimeoutNanos);
    }

    public void stop() {
        this.lock.lock();
        try {
            log.tracef("Stopping sequencer %s", (Object)this.toString());
            this.running = false;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("Sequencer{ ");
            for (LogicalThread thread : this.logicalThreads.values()) {
                sb.append(thread);
                sb.append("; ");
            }
            sb.append("global order: ").append(this.getOrderString());
            sb.append("}");
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInState(String stateName) {
        this.lock.lock();
        try {
            State state = this.stateMap.get(stateName);
            LogicalThread logicalThread = this.logicalThreads.get(state.threadName);
            boolean bl = stateName.equals(logicalThread.currentState);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAfterState(String stateName) {
        this.lock.lock();
        try {
            State state = this.stateMap.get(stateName);
            boolean bl = state.signalled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInOrAfterState(String stateName) {
        this.lock.lock();
        try {
            State state = this.stateMap.get(stateName);
            if (state.signalled) {
                boolean bl = true;
                return bl;
            }
            LogicalThread logicalThread = this.logicalThreads.get(state.threadName);
            boolean bl = stateName.equals(logicalThread.currentState);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class LogicalThread {
        final String name;
        final List<String> states;
        String currentState;

        public LogicalThread(String name, List<String> states) {
            this.name = name;
            this.states = states;
        }

        public void setCurrentState(String state) {
            this.currentState = state;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append(": ");
            for (int i = 0; i < this.states.size(); ++i) {
                String state = this.states.get(i);
                if (i > 0) {
                    sb.append(" < ");
                }
                if (state.equals(this.currentState)) {
                    sb.append("*");
                }
                sb.append(state);
            }
            return sb.toString();
        }
    }

    private static class State {
        final String threadName;
        final String name;
        final List<String> dependencies;
        Callable<Object> action;
        boolean signalled;

        public State(String threadName, String name) {
            this.threadName = threadName;
            this.name = name;
            this.dependencies = new ArrayList<String>();
        }
    }

    private static interface StatesVisitor {
        public void visitStates(List<String> var1);

        public void visitCycle(Collection<String> var1);
    }
}

