/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.data;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CountMarshallingPojo {
    private static final Log log = LogFactory.getLog(CountMarshallingPojo.class);
    private static final Map<String, Integer> marshallCount = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> unmarshallCount = new ConcurrentHashMap<String, Integer>();
    private String name;
    private int value;

    public static void reset(String name) {
        marshallCount.put(name, 0);
        unmarshallCount.put(name, 0);
    }

    public static int getMarshallCount(String name) {
        return marshallCount.getOrDefault(name, 0);
    }

    public static int getUnmarshallCount(String name) {
        return unmarshallCount.getOrDefault(name, 0);
    }

    CountMarshallingPojo() {
    }

    public CountMarshallingPojo(String name, int value) {
        this.name = name;
        this.value = value;
    }

    @ProtoField(number=1, defaultValue="0")
    int getValue() {
        return this.value;
    }

    void setValue(int i) {
        this.value = i;
    }

    @ProtoField(number=2)
    String getName() {
        int serCount = marshallCount.merge(this.name, 1, Integer::sum);
        log.trace((Object)("marshallCount=" + serCount));
        return this.name;
    }

    void setName(String name) {
        this.name = name;
        int deserCount = unmarshallCount.merge(this.name, 1, Integer::sum);
        log.trace((Object)("unmarshallCount=" + deserCount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountMarshallingPojo that = (CountMarshallingPojo)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "CountMarshallingPojo{name=" + this.name + ", value=" + this.value + '}';
    }
}

