/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.util.Util;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Sex;

public class Person
implements Serializable,
JsonSerialization {
    String name;
    Address address;
    byte[] picture;
    Sex sex;
    Date birthDate;

    public Person() {
        this.birthDate = new Date(0L);
    }

    public Person(String name) {
        this(name, null, null, null, null);
    }

    @ProtoFactory
    public Person(String name, Address address, byte[] picture, Sex sex, Date birthDate) {
        this.name = name;
        this.address = address;
        this.picture = picture;
        this.sex = sex;
        this.birthDate = birthDate == null ? new Date(0L) : birthDate;
    }

    @ProtoField(value=1)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ProtoField(value=2)
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    @ProtoField(value=3)
    public byte[] getPicture() {
        return this.picture;
    }

    public void setPicture(byte[] picture) {
        this.picture = picture;
    }

    @ProtoField(value=4)
    public Sex getSex() {
        return this.sex;
    }

    public void setSex(Sex sex) {
        this.sex = sex;
    }

    @ProtoField(value=5, defaultValue="0")
    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public String toString() {
        return "Person{name='" + this.name + '\'' + ", address=" + this.address + ", picture=" + Util.toHexString((byte[])this.picture) + ", sex=" + (Object)((Object)this.sex) + ", birthDate=" + this.birthDate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person person = (Person)o;
        if (this.address != null ? !this.address.equals(person.address) : person.address != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(person.name) : person.name != null) {
            return false;
        }
        if (this.picture != null ? !Arrays.equals(this.picture, person.picture) : person.picture != null) {
            return false;
        }
        if (this.sex != null ? !this.sex.equals((Object)person.sex) : person.sex != null) {
            return false;
        }
        return !(this.birthDate != null ? !this.birthDate.equals(person.birthDate) : person.birthDate != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 29 * result + (this.picture != null ? Arrays.hashCode(this.picture) : 0);
        result = 29 * result + (this.sex != null ? this.sex.hashCode() : 0);
        result = 29 * result + (this.birthDate != null ? this.birthDate.hashCode() : 0);
        return result;
    }

    public Json toJson() {
        return Json.object().set("name", (Object)this.name).set("address", Json.make((Object)this.address)).set("picture", (Object)this.picture).set("sex", (Object)this.sex).set("birthDate", (Object)(this.birthDate == null ? 0L : this.birthDate.getTime()));
    }
}

