/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.test.fwk.FakeTestClass;
import org.infinispan.test.fwk.TestSelector;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.TestNGException;
import org.testng.internal.MethodInstance;

public class ChainMethodInterceptor
implements IMethodInterceptor {
    private static final Log log = LogFactory.getLog(ChainMethodInterceptor.class);

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        try {
            HashSet<Class<? extends IMethodInterceptor>> interceptorSet = new HashSet<Class<? extends IMethodInterceptor>>();
            ArrayList<Class<? extends IMethodInterceptor>> interceptorList = new ArrayList<Class<? extends IMethodInterceptor>>();
            HashSet<Class<? extends Predicate<IMethodInstance>>> filters = new HashSet<Class<? extends Predicate<IMethodInstance>>>();
            for (IMethodInstance iMethodInstance : methods) {
                this.findInterceptors(iMethodInstance.getInstance().getClass(), interceptorSet, interceptorList, filters);
            }
            if (!filters.isEmpty()) {
                List filterInstances = filters.stream().map(clazz -> {
                    try {
                        return (Predicate)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot construct filter", e);
                    }
                }).collect(Collectors.toList());
                ArrayList<IMethodInstance> arrayList = new ArrayList<IMethodInstance>(methods.size());
                block3: for (IMethodInstance m : methods) {
                    for (Predicate filter : filterInstances) {
                        if (!this.hasFilter(m.getInstance().getClass(), filter.getClass()) || filter.test(m)) continue;
                        continue block3;
                    }
                    arrayList.add(m);
                }
                methods = arrayList;
            }
            for (Class clazz2 : interceptorList) {
                methods = ((IMethodInterceptor)clazz2.getConstructor(new Class[0]).newInstance(new Object[0])).intercept((List)methods, context);
            }
            return methods;
        }
        catch (Throwable t) {
            MethodInstance methodInstance = FakeTestClass.newFailureMethodInstance((Exception)new TestNGException(t), context.getCurrentXmlTest(), context, ((IMethodInstance)methods.get(0)).getInstance());
            return Collections.singletonList(methodInstance);
        }
    }

    private boolean hasFilter(Class<?> clazz, Class<? extends Predicate> filter) {
        if (clazz == null || clazz == Object.class) {
            return false;
        }
        TestSelector annotation = clazz.getAnnotation(TestSelector.class);
        if (annotation != null) {
            for (Class<? extends Predicate<IMethodInstance>> f : annotation.filters()) {
                if (f != filter) continue;
                return true;
            }
        }
        return this.hasFilter(clazz.getSuperclass(), filter);
    }

    private void findInterceptors(Class<?> clazz, Set<Class<? extends IMethodInterceptor>> interceptorSet, List<Class<? extends IMethodInterceptor>> interceptorList, Set<Class<? extends Predicate<IMethodInstance>>> filters) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        this.findInterceptors(clazz.getSuperclass(), interceptorSet, interceptorList, filters);
        TestSelector annotation = clazz.getAnnotation(TestSelector.class);
        if (annotation != null) {
            for (Class<? extends IMethodInterceptor> interceptor : annotation.interceptors()) {
                if (!interceptorSet.add(interceptor)) continue;
                interceptorList.add(interceptor);
            }
            Collections.addAll(filters, annotation.filters());
        }
    }
}

