/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CheckPoint {
    private static final Log log = LogFactory.getLog(CheckPoint.class);
    public static final int INFINITE = 999999999;
    private final String id;
    private final Lock lock = new ReentrantLock();
    private final Condition unblockCondition = this.lock.newCondition();
    private final Map<String, EventStatus> events = new HashMap<String, EventStatus>();

    public CheckPoint() {
        this.id = "";
    }

    public CheckPoint(String name) {
        this.id = "[" + name + "] ";
    }

    public void awaitStrict(String event, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.awaitStrict(event, 1, timeout, unit);
    }

    private boolean await(String event, long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(event, 1, timeout, unit);
    }

    public void awaitStrict(String event, int count, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this.await(event, count, timeout, unit)) {
            throw new TimeoutException(this.id + "Timed out waiting for event " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await(String event, int count, long timeout, TimeUnit unit) throws InterruptedException {
        log.tracef("%sWaiting for event %s * %d", (Object)this.id, (Object)event, (Object)count);
        this.lock.lock();
        try {
            EventStatus status = this.events.computeIfAbsent(event, k -> new EventStatus());
            long waitNanos = unit.toNanos(timeout);
            while (waitNanos > 0L) {
                if (status.available >= count) {
                    status.available -= count;
                    break;
                }
                waitNanos = this.unblockCondition.awaitNanos(waitNanos);
            }
            if (waitNanos <= 0L) {
                log.errorf("%sTimed out waiting for event %s * %d (available = %d, total = %d)", new Object[]{this.id, event, count, status.available, status.total});
                status.available = -1;
                boolean bl = false;
                return bl;
            }
            log.tracef("%sReceived event %s * %d (available = %d, total = %d)", new Object[]{this.id, event, count, status.available, status.total});
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String peek(long timeout, TimeUnit unit, String ... expectedEvents) throws InterruptedException {
        log.tracef("%sWaiting for any one of events %s", (Object)this.id, (Object)Arrays.toString(expectedEvents));
        String found = null;
        this.lock.lock();
        try {
            long waitNanos = unit.toNanos(timeout);
            while (waitNanos > 0L) {
                for (String event : expectedEvents) {
                    EventStatus status = this.events.get(event);
                    if (status == null || status.available < 1) continue;
                    found = event;
                    break;
                }
                if (found != null) break;
                waitNanos = this.unblockCondition.awaitNanos(waitNanos);
            }
            if (waitNanos <= 0L) {
                log.tracef("%sPeek did not receive any of %s", (Object)this.id, (Object)Arrays.toString(expectedEvents));
                String[] stringArray = null;
                return stringArray;
            }
            EventStatus status = this.events.get(found);
            log.tracef("%sReceived event %s (available = %d, total = %d)", new Object[]{this.id, found, status.available, status.total});
            String string = found;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public CompletableFuture<Void> future(String event, long timeout, TimeUnit unit, Executor executor) {
        return this.future(event, 1, timeout, unit, executor);
    }

    public CompletableFuture<Void> future(String event, int count, long timeout, TimeUnit unit, Executor executor) {
        return TestingUtil.orTimeout(this.future0(event, count), timeout, unit, executor).thenRunAsync(() -> log.tracef("Received event %s * %d", (Object)event, (Object)count), executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> future0(String event, int count) {
        log.tracef("%sWaiting for event %s * %d", (Object)this.id, (Object)event, (Object)count);
        this.lock.lock();
        try {
            EventStatus status = this.events.get(event);
            if (status == null) {
                status = new EventStatus();
                this.events.put(event, status);
            }
            if (status.available >= count) {
                status.available -= count;
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            if (status.requests == null) {
                status.requests = new ArrayList();
            }
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            status.requests.add(new Request(f, count));
            CompletableFuture<Void> completableFuture = f;
            return completableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void trigger(String event) {
        this.trigger(event, 1);
    }

    public void triggerForever(String event) {
        this.trigger(event, 999999999);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(String event, int count) {
        this.lock.lock();
        try {
            EventStatus status = this.events.get(event);
            if (status == null) {
                status = new EventStatus();
                this.events.put(event, status);
            } else if (status.available < 0) {
                throw new IllegalStateException(this.id + "Thread already timed out waiting for event " + event);
            }
            status.available = count != 999999999 ? status.available + count : 999999999;
            status.total = count != 999999999 ? status.total + count : 999999999;
            log.tracef("%sTriggering event %s * %d (available = %d, total = %d)", new Object[]{this.id, event, count, status.available, status.total});
            this.unblockCondition.signalAll();
            if (status.requests != null) {
                if (count == 999999999) {
                    status.requests.forEach(request -> request.future.complete(null));
                } else {
                    Iterator<Request> iterator = status.requests.iterator();
                    while (status.available > 0 && iterator.hasNext()) {
                        Request request2 = iterator.next();
                        if (request2.count > status.available) continue;
                        request2.future.complete(null);
                        status.available -= request2.count;
                        iterator.remove();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "CheckPoint(" + this.id + ")" + this.events;
    }

    private static class Request {
        final CompletableFuture<Void> future;
        final int count;

        private Request(CompletableFuture<Void> future, int count) {
            this.future = future;
            this.count = count;
        }

        public String toString() {
            return "(" + this.count + ")";
        }
    }

    private static class EventStatus {
        int available;
        int total;
        public ArrayList<Request> requests;

        private EventStatus() {
        }

        public String toString() {
            return "" + this.available + "/" + this.total + ", requests=" + this.requests;
        }
    }
}

