/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.PlatformMBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.LegacyKeySupportSystemProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.factories.threads.CoreExecutorFactory;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.security.Security;
import org.infinispan.test.fwk.JGroupsConfigBuilder;
import org.infinispan.test.fwk.MetricsCollectorTestHelper;
import org.infinispan.test.fwk.TransactionSetup;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TestCacheManagerFactory {
    public static final String DEFAULT_CACHE_NAME = "defaultcache";
    public static final int NAMED_EXECUTORS_THREADS_NO_QUEUE = 6;
    private static final int NAMED_EXECUTORS_THREADS_WITH_QUEUE = 6;
    private static final int NAMED_EXECUTORS_QUEUE_SIZE = 20;
    private static final int NAMED_EXECUTORS_KEEP_ALIVE = 30000;
    private static final String MARSHALLER = LegacyKeySupportSystemProperties.getProperty((String)"infinispan.test.marshaller.class", (String)"infinispan.marshaller.class");
    private static final Log log = LogFactory.getLog(TestCacheManagerFactory.class);

    public static EmbeddedCacheManager newDefaultCacheManager(boolean start, GlobalConfigurationBuilder gcb, ConfigurationBuilder c) {
        DefaultCacheManager defaultCacheManager;
        TestCacheManagerFactory.setNodeName(gcb);
        MetricsCollectorTestHelper.replace(gcb);
        GlobalConfiguration globalConfiguration = gcb.build();
        TestCacheManagerFactory.checkJmx(globalConfiguration);
        if (c != null) {
            TestCacheManagerFactory.amendDefaultCache(gcb);
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder(Thread.currentThread().getContextClassLoader(), gcb);
            holder.getNamedConfigurationBuilders().put((String)gcb.defaultCacheName().get(), c);
            defaultCacheManager = new DefaultCacheManager(holder, start);
        } else {
            defaultCacheManager = new DefaultCacheManager(gcb.build(), start);
        }
        TestResourceTracker.addResource((TestResourceTracker.Cleaner)new CacheManagerCleaner((EmbeddedCacheManager)defaultCacheManager));
        return defaultCacheManager;
    }

    public static DefaultCacheManager newDefaultCacheManager(boolean start, ConfigurationBuilderHolder holder) {
        GlobalConfigurationBuilder gcb = holder.getGlobalConfigurationBuilder();
        if (holder.getDefaultConfigurationBuilder() != null) {
            TestCacheManagerFactory.amendDefaultCache(gcb);
        }
        TestCacheManagerFactory.setNodeName(gcb);
        MetricsCollectorTestHelper.replace(gcb);
        TestCacheManagerFactory.checkJmx(gcb.build());
        DefaultCacheManager defaultCacheManager = new DefaultCacheManager(holder, start);
        TestResourceTracker.addResource((TestResourceTracker.Cleaner)new CacheManagerCleaner((EmbeddedCacheManager)defaultCacheManager));
        return defaultCacheManager;
    }

    public static EmbeddedCacheManager fromXml(String xmlFile) throws IOException {
        return TestCacheManagerFactory.fromXml(xmlFile, false);
    }

    public static EmbeddedCacheManager fromXml(String xmlFile, boolean defaultParserOnly) throws IOException {
        return TestCacheManagerFactory.fromXml(xmlFile, defaultParserOnly, true);
    }

    public static EmbeddedCacheManager fromXml(String xmlFile, boolean defaultParserOnly, boolean start) throws IOException {
        return TestCacheManagerFactory.fromXml(xmlFile, defaultParserOnly, start, new TransportFlags());
    }

    public static EmbeddedCacheManager fromXml(String xmlFile, boolean defaultParserOnly, boolean start, TransportFlags transportFlags) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = FileLookupFactory.newInstance().lookupFileLocation(xmlFile, classLoader);
        ConfigurationBuilderHolder holder = TestCacheManagerFactory.parseURL(url, defaultParserOnly);
        return TestCacheManagerFactory.createClusteredCacheManager(start, holder, transportFlags);
    }

    public static EmbeddedCacheManager fromStream(InputStream is) {
        return TestCacheManagerFactory.fromStream(is, true);
    }

    public static EmbeddedCacheManager fromStream(InputStream is, boolean defaultParsersOnly) {
        return TestCacheManagerFactory.fromStream(is, defaultParsersOnly, true);
    }

    public static EmbeddedCacheManager fromStream(InputStream is, boolean defaultParsersOnly, boolean start) {
        return TestCacheManagerFactory.createClusteredCacheManager(start, TestCacheManagerFactory.parseStream(is, defaultParsersOnly), new TransportFlags());
    }

    public static ConfigurationBuilderHolder parseFile(String xmlFile, boolean defaultParserOnly) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try (InputStream is = FileLookupFactory.newInstance().lookupFileStrict(xmlFile, classLoader);){
            ConfigurationBuilderHolder configurationBuilderHolder = TestCacheManagerFactory.parseStream(is, defaultParserOnly);
            return configurationBuilderHolder;
        }
    }

    public static ConfigurationBuilderHolder parseURL(URL url, boolean defaultParsersOnly) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ParserRegistry parserRegistry = new ParserRegistry(classLoader, defaultParsersOnly, System.getProperties());
        ConfigurationBuilderHolder holder = parserRegistry.parse(url);
        return TestCacheManagerFactory.updateTestName(holder);
    }

    public static ConfigurationBuilderHolder parseStream(InputStream is, boolean defaultParsersOnly) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ParserRegistry parserRegistry = new ParserRegistry(classLoader, defaultParsersOnly, System.getProperties());
        ConfigurationBuilderHolder holder = parserRegistry.parse(is, null, MediaType.APPLICATION_XML);
        return TestCacheManagerFactory.updateTestName(holder);
    }

    private static ConfigurationBuilderHolder updateTestName(ConfigurationBuilderHolder holder) {
        String testShortName = TestResourceTracker.getCurrentTestShortName();
        GlobalConfiguration gc = holder.getGlobalConfigurationBuilder().build();
        TestCacheManagerFactory.updateNodeName(testShortName, gc.listenerThreadPool());
        TestCacheManagerFactory.updateNodeName(testShortName, gc.expirationThreadPool());
        TestCacheManagerFactory.updateNodeName(testShortName, gc.persistenceThreadPool());
        TestCacheManagerFactory.updateNodeName(testShortName, gc.stateTransferThreadPool());
        TestCacheManagerFactory.updateNodeName(testShortName, gc.asyncThreadPool());
        TestCacheManagerFactory.updateNodeName(testShortName, gc.transport().transportThreadPool());
        return holder;
    }

    private static void updateNodeName(String nodeName, ThreadPoolConfiguration threadPoolConfiguration) {
        if (threadPoolConfiguration.threadFactory() instanceof DefaultThreadFactory) {
            ((DefaultThreadFactory)threadPoolConfiguration.threadFactory()).setNode(nodeName);
        }
    }

    public static EmbeddedCacheManager fromString(String config) {
        return TestCacheManagerFactory.fromStream(new ByteArrayInputStream(config.getBytes()));
    }

    private static void markAsTransactional(boolean transactional, ConfigurationBuilder builder) {
        if (!transactional) {
            builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        } else {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
            builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)TransactionSetup.getManagerLookup(), (ClassLoader)TestCacheManagerFactory.class.getClassLoader()));
        }
    }

    private static void updateTransactionSupport(boolean transactional, ConfigurationBuilder builder) {
        if (transactional) {
            TestCacheManagerFactory.amendJTA(builder);
        }
    }

    private static void amendJTA(ConfigurationBuilder builder) {
        if (builder.transaction().transactionMode() == TransactionMode.TRANSACTIONAL && builder.transaction().transactionManagerLookup() == null) {
            builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance((String)TransactionSetup.getManagerLookup(), (ClassLoader)TestCacheManagerFactory.class.getClassLoader()));
        }
    }

    public static EmbeddedCacheManager createClusteredCacheManager() {
        return TestCacheManagerFactory.createClusteredCacheManager(new ConfigurationBuilder(), new TransportFlags());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(ConfigurationBuilder defaultCacheConfig, TransportFlags flags) {
        return TestCacheManagerFactory.createClusteredCacheManager(GlobalConfigurationBuilder.defaultClusteredBuilder(), defaultCacheConfig, flags);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(SerializationContextInitializer sci) {
        return TestCacheManagerFactory.createClusteredCacheManager(sci, new ConfigurationBuilder());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(SerializationContextInitializer sci, ConfigurationBuilder defaultCacheConfig) {
        GlobalConfigurationBuilder globalBuilder = GlobalConfigurationBuilder.defaultClusteredBuilder();
        if (sci != null) {
            globalBuilder.serialization().addContextInitializer(sci);
        }
        return TestCacheManagerFactory.createClusteredCacheManager(globalBuilder, defaultCacheConfig, new TransportFlags());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(GlobalConfigurationBuilder gcb, ConfigurationBuilder defaultCacheConfig) {
        return TestCacheManagerFactory.createClusteredCacheManager(gcb, defaultCacheConfig, new TransportFlags());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(ConfigurationBuilder defaultCacheConfig) {
        return TestCacheManagerFactory.createClusteredCacheManager(GlobalConfigurationBuilder.defaultClusteredBuilder(), defaultCacheConfig);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(ConfigurationBuilderHolder holder) {
        return TestCacheManagerFactory.createClusteredCacheManager(true, holder);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(boolean start, ConfigurationBuilderHolder holder) {
        return TestCacheManagerFactory.createClusteredCacheManager(start, holder, new TransportFlags());
    }

    public static EmbeddedCacheManager createClusteredCacheManager(boolean start, ConfigurationBuilderHolder holder, TransportFlags flags) {
        TestCacheManagerFactory.amendGlobalConfiguration(holder.getGlobalConfigurationBuilder(), flags);
        for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
            TestCacheManagerFactory.amendJTA(builder);
        }
        return TestCacheManagerFactory.newDefaultCacheManager(start, holder);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(GlobalConfigurationBuilder gcb, ConfigurationBuilder defaultCacheConfig, TransportFlags flags) {
        return TestCacheManagerFactory.createClusteredCacheManager(true, gcb, defaultCacheConfig, flags);
    }

    public static EmbeddedCacheManager createClusteredCacheManager(boolean start, GlobalConfigurationBuilder gcb, ConfigurationBuilder defaultCacheConfig, TransportFlags flags) {
        TestCacheManagerFactory.amendGlobalConfiguration(gcb, flags);
        if (defaultCacheConfig != null) {
            TestCacheManagerFactory.amendJTA(defaultCacheConfig);
        }
        return TestCacheManagerFactory.newDefaultCacheManager(start, gcb, defaultCacheConfig);
    }

    public static void amendGlobalConfiguration(GlobalConfigurationBuilder gcb, TransportFlags flags) {
        TestCacheManagerFactory.amendMarshaller(gcb);
        TestCacheManagerFactory.minimizeThreads(gcb);
        TestCacheManagerFactory.amendTransport(gcb, flags);
    }

    public static EmbeddedCacheManager createCacheManager(ConfigurationBuilder builder) {
        return TestCacheManagerFactory.createCacheManager(new GlobalConfigurationBuilder().nonClusteredDefault(), builder);
    }

    public static EmbeddedCacheManager createCacheManager(SerializationContextInitializer sci, ConfigurationBuilder builder) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        if (sci != null) {
            globalBuilder.serialization().addContextInitializer(sci);
        }
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder);
    }

    public static EmbeddedCacheManager createCacheManager() {
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)null);
    }

    public static EmbeddedCacheManager createServerModeCacheManager() {
        return TestCacheManagerFactory.createServerModeCacheManager((ConfigurationBuilder)null);
    }

    public static EmbeddedCacheManager createServerModeCacheManager(ConfigurationBuilder builder) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        ((PrivateGlobalConfigurationBuilder)globalBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder);
    }

    public static EmbeddedCacheManager createServerModeCacheManager(SerializationContextInitializer sci, ConfigurationBuilder builder) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        globalBuilder.serialization().addContextInitializer(sci);
        return TestCacheManagerFactory.createServerModeCacheManager(globalBuilder, builder);
    }

    public static EmbeddedCacheManager createServerModeCacheManager(GlobalConfigurationBuilder gcb) {
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        return TestCacheManagerFactory.createCacheManager(gcb, new ConfigurationBuilder());
    }

    public static EmbeddedCacheManager createServerModeCacheManager(GlobalConfigurationBuilder gcb, ConfigurationBuilder builder) {
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        return TestCacheManagerFactory.createCacheManager(gcb, builder);
    }

    public static EmbeddedCacheManager createCacheManager(boolean start) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        TestCacheManagerFactory.amendGlobalConfiguration(globalBuilder, new TransportFlags());
        return TestCacheManagerFactory.newDefaultCacheManager(start, globalBuilder, new ConfigurationBuilder());
    }

    public static EmbeddedCacheManager createCacheManager(SerializationContextInitializer sci) {
        return TestCacheManagerFactory.createCacheManager(true, sci);
    }

    public static EmbeddedCacheManager createCacheManager(boolean start, SerializationContextInitializer sci) {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
        TestCacheManagerFactory.amendGlobalConfiguration(globalBuilder, new TransportFlags());
        if (sci != null) {
            globalBuilder.serialization().addContextInitializer(sci);
        }
        return TestCacheManagerFactory.newDefaultCacheManager(start, globalBuilder, null);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder) {
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder, true);
    }

    public static EmbeddedCacheManager createCacheManager(GlobalConfigurationBuilder globalBuilder, ConfigurationBuilder builder, boolean start) {
        if (globalBuilder.transport().build().transport().transport() != null) {
            throw new IllegalArgumentException("Use TestCacheManagerFactory.createClusteredCacheManager(...) for clustered cache managers");
        }
        TestCacheManagerFactory.amendTransport(globalBuilder);
        return TestCacheManagerFactory.newDefaultCacheManager(start, globalBuilder, builder);
    }

    public static EmbeddedCacheManager createCacheManager(CacheMode mode, boolean indexing) {
        return TestCacheManagerFactory.createCacheManager(null, mode, indexing);
    }

    public static EmbeddedCacheManager createCacheManager(SerializationContextInitializer sci, CacheMode mode, boolean indexing) {
        GlobalConfigurationBuilder globalBuilder;
        GlobalConfigurationBuilder globalConfigurationBuilder = globalBuilder = mode.isClustered() ? new GlobalConfigurationBuilder().clusteredDefault() : new GlobalConfigurationBuilder().nonClusteredDefault();
        if (sci != null) {
            globalBuilder.serialization().addContextInitializer(sci);
        }
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(mode);
        if (indexing) {
            builder.indexing().enabled(true);
        }
        if (mode.isClustered()) {
            return TestCacheManagerFactory.createClusteredCacheManager(globalBuilder, builder);
        }
        return TestCacheManagerFactory.createCacheManager(globalBuilder, builder);
    }

    public static void configureJmx(GlobalConfigurationBuilder builder, String jmxDomain, MBeanServerLookup mBeanServerLookup) {
        builder.jmx().enabled(true).domain(jmxDomain).mBeanServerLookup(mBeanServerLookup);
    }

    public static ConfigurationBuilder getDefaultCacheConfiguration(boolean transactional) {
        return TestCacheManagerFactory.getDefaultCacheConfiguration(transactional, false);
    }

    public static ConfigurationBuilder getDefaultCacheConfiguration(boolean transactional, boolean useCustomTxLookup) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        TestCacheManagerFactory.markAsTransactional(transactional, builder);
        if (useCustomTxLookup) {
            TestCacheManagerFactory.updateTransactionSupport(transactional, builder);
        }
        return builder;
    }

    public static void amendTransport(GlobalConfigurationBuilder cfg) {
        TestCacheManagerFactory.amendTransport(cfg, new TransportFlags());
    }

    private static void amendTransport(GlobalConfigurationBuilder builder, TransportFlags flags) {
        String testName = TestResourceTracker.getCurrentTestName();
        GlobalConfiguration gc = builder.build();
        if (!flags.isPreserveConfig() && gc.transport().transport() != null) {
            if (flags.isRelayRequired()) {
                builder.transport().clusterName(flags.siteName() + "-" + testName);
            } else if (gc.transport().attributes().attribute(TransportConfiguration.CLUSTER_NAME).isModified()) {
                builder.transport().clusterName(gc.transport().clusterName() + "-" + testName);
            } else {
                builder.transport().clusterName(testName);
            }
            builder.transport().removeProperty("configurationFile");
            builder.transport().removeProperty("channelConfigurator");
            builder.transport().addProperty("configurationString", (Object)JGroupsConfigBuilder.getJGroupsConfig(testName, flags));
        }
    }

    public static void setNodeName(GlobalConfigurationBuilder builder) {
        if (builder.build().transport().nodeName() != null) {
            return;
        }
        String nextNodeName = TestResourceTracker.getNextNodeName();
        builder.transport().nodeName(nextNodeName);
    }

    public static void minimizeThreads(GlobalConfigurationBuilder builder) {
        ThreadPoolExecutorFactory executorFactoryWithQueue = CoreExecutorFactory.executorFactory((int)6, (int)6, (int)20, (long)30000L, (boolean)false);
        ThreadPoolExecutorFactory nonBlockingExecutorFactoryWithQueue = CoreExecutorFactory.executorFactory((int)6, (int)6, (int)20, (long)30000L, (boolean)true);
        builder.blockingThreadPool().threadPoolFactory(executorFactoryWithQueue);
        builder.nonBlockingThreadPool().threadPoolFactory(nonBlockingExecutorFactoryWithQueue);
    }

    public static void amendDefaultCache(GlobalConfigurationBuilder builder) {
        if (!builder.defaultCacheName().isPresent()) {
            builder.defaultCacheName(DEFAULT_CACHE_NAME);
        }
    }

    public static void amendMarshaller(GlobalConfigurationBuilder builder) {
        if (MARSHALLER != null) {
            try {
                Marshaller marshaller = (Marshaller)Util.getInstanceStrict((String)MARSHALLER, (ClassLoader)Thread.currentThread().getContextClassLoader());
                builder.serialization().marshaller(marshaller);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private static void checkJmx(GlobalConfiguration gc) {
        assert (!gc.jmx().enabled() || !(gc.jmx().mbeanServerLookup() instanceof PlatformMBeanServerLookup)) : "Tests must configure a MBeanServerLookup other than the default PlatformMBeanServerLookup or not enable JMX";
    }

    public static class CacheManagerCleaner
    extends TestResourceTracker.Cleaner<EmbeddedCacheManager> {
        protected CacheManagerCleaner(EmbeddedCacheManager ref) {
            super((Object)ref);
        }

        public void close() {
            PrivilegedAction<Object> action = () -> {
                if (!((EmbeddedCacheManager)this.ref).getStatus().isTerminated()) {
                    log.debugf("Stopping cache manager %s", this.ref);
                    ((EmbeddedCacheManager)this.ref).stop();
                }
                return null;
            };
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(action);
            } else {
                Security.doPrivileged(action);
            }
        }
    }
}

