/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.fwk;

import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.container.entries.MortalCacheValue;
import org.infinispan.container.entries.TransientCacheValue;
import org.infinispan.container.entries.TransientMortalCacheValue;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;

public class TestInternalCacheEntryFactory {
    private static final InternalEntryFactory FACTORY = new InternalEntryFactoryImpl();

    public static InternalCacheEntry create(Object key, Object value) {
        return new ImmortalCacheEntry(key, value);
    }

    public static InternalCacheValue create(Object value) {
        return new ImmortalCacheValue(value);
    }

    public static InternalCacheEntry create(Object key, Object value, long lifespan) {
        return TestInternalCacheEntryFactory.create(FACTORY, key, value, lifespan);
    }

    public static <K, V> InternalCacheEntry<K, V> create(InternalEntryFactory factory, K key, V value, long lifespan) {
        return factory.create(key, value, null, lifespan, -1L);
    }

    public static InternalCacheEntry create(Object key, Object value, long lifespan, long maxIdle) {
        return TestInternalCacheEntryFactory.create(FACTORY, key, value, lifespan, maxIdle);
    }

    public static <K, V> InternalCacheEntry<K, V> create(InternalEntryFactory factory, K key, V value, long lifespan, long maxIdle) {
        return factory.create(key, value, null, lifespan, maxIdle);
    }

    public static InternalCacheEntry create(Object key, Object value, long created, long lifespan, long lastUsed, long maxIdle) {
        return FACTORY.create(key, value, new EmbeddedMetadata.Builder().build(), created, lifespan, lastUsed, maxIdle);
    }

    public static InternalCacheValue createValue(Object v, long created, long lifespan, long lastUsed, long maxIdle) {
        if (lifespan < 0L && maxIdle < 0L) {
            return new ImmortalCacheValue(v);
        }
        if (lifespan > -1L && maxIdle < 0L) {
            return new MortalCacheValue(v, created, lifespan);
        }
        if (lifespan < 0L && maxIdle > -1L) {
            return new TransientCacheValue(v, maxIdle, lastUsed);
        }
        return new TransientMortalCacheValue(v, created, lifespan, maxIdle, lastUsed);
    }

    static {
        TestingUtil.inject(FACTORY, AbstractInfinispanTest.TIME_SERVICE);
    }
}

