/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.op;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.FunctionalTestUtils;
import org.infinispan.functional.MetaParam;
import org.infinispan.functional.decorators.FunctionalAdvancedCache;
import org.infinispan.test.op.TestOperation;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializableConsumer;

public enum TestFunctionalWriteOperation implements TestOperation
{
    PUT_CREATE_FUNCTIONAL(ReadWriteKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_ALWAYS, null, null, null),
    PUT_OVERWRITE_FUNCTIONAL(ReadWriteKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_ALWAYS, "v0", "v0", "v0"),
    PUT_IF_ABSENT_FUNCTIONAL(ReadWriteKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_EXPECTED, null, null, null),
    REPLACE_FUNCTIONAL(ReadWriteKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_NON_NULL, "v0", "v0", "v0"),
    REMOVE_FUNCTIONAL(ReadWriteKeyCommand.class, BackupWriteCommand.class, null, ValueMatcher.MATCH_NON_NULL, "v0", "v0", null),
    REPLACE_EXACT_FUNCTIONAL(ReadWriteKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_EXPECTED, "v0", true, true),
    REMOVE_EXACT_FUNCTIONAL(ReadWriteKeyValueCommand.class, BackupWriteCommand.class, null, ValueMatcher.MATCH_EXPECTED, "v0", true, true),
    REPLACE_META_FUNCTIONAL(ReadWriteKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_EXPECTED, "v0", true, true);

    private final Class<? extends VisitableCommand> commandClass;
    private final Class<? extends ReplicableCommand> backupCommandClass;
    private final Object value;
    private final ValueMatcher valueMatcher;
    private final Object previousValue;
    private final Object returnValue;
    private final Object returnValueWithRetry;

    private TestFunctionalWriteOperation(Class<? extends VisitableCommand> commandClass, Class<? extends ReplicableCommand> backupCommandClass, Object value, ValueMatcher valueMatcher, Object previousValue, Object returnValue, Object returnValueWithRetry) {
        this.commandClass = commandClass;
        this.backupCommandClass = backupCommandClass;
        this.value = value;
        this.valueMatcher = valueMatcher;
        this.previousValue = previousValue;
        this.returnValue = returnValue;
        this.returnValueWithRetry = returnValueWithRetry;
    }

    @Override
    public Class<? extends VisitableCommand> getCommandClass() {
        return this.commandClass;
    }

    @Override
    public Class<? extends ReplicableCommand> getBackupCommandClass() {
        return this.backupCommandClass;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getPreviousValue() {
        return this.previousValue;
    }

    @Override
    public Object getReturnValue() {
        return this.returnValue;
    }

    @Override
    public void insertPreviousValue(AdvancedCache<Object, Object> cache, Object key) {
        switch (this) {
            case REPLACE_META_FUNCTIONAL: {
                FunctionalMap.WriteOnlyMap<Object, Object> woMap = FunctionalTestUtils.wo(cache);
                FunctionalTestUtils.await(woMap.eval(key, (SerializableConsumer & Serializable)wo -> wo.set((Object)"v0", new MetaParam.Writable[]{new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(1L))})));
                break;
            }
            default: {
                if (this.previousValue == null) break;
                cache.withFlags(Flag.IGNORE_RETURN_VALUES).put(key, this.previousValue);
            }
        }
    }

    @Override
    public Object perform(AdvancedCache<Object, Object> cache, Object key) {
        AdvancedCache<Object, Object> functionalCache = FunctionalAdvancedCache.create(cache);
        switch (this) {
            case PUT_CREATE_FUNCTIONAL: {
                return functionalCache.put(key, this.value);
            }
            case PUT_OVERWRITE_FUNCTIONAL: {
                return functionalCache.put(key, this.value);
            }
            case PUT_IF_ABSENT_FUNCTIONAL: {
                return functionalCache.putIfAbsent(key, this.value);
            }
            case REPLACE_FUNCTIONAL: {
                return functionalCache.replace(key, this.value);
            }
            case REPLACE_EXACT_FUNCTIONAL: {
                return functionalCache.replace(key, this.previousValue, this.value);
            }
            case REMOVE_FUNCTIONAL: {
                return functionalCache.remove(key);
            }
            case REMOVE_EXACT_FUNCTIONAL: {
                return functionalCache.remove(key, this.previousValue);
            }
            case REPLACE_META_FUNCTIONAL: {
                return FunctionalTestUtils.await(FunctionalTestUtils.rw(cache).eval(key, (Object)"v1", (SerializableBiFunction & Serializable)(v, rw) -> rw.findMetaParam(MetaParam.MetaEntryVersion.class).filter(ver -> ver.get().compareTo((EntryVersion)new NumericVersion(1L)) == InequalVersionComparisonResult.EQUAL).map(ver -> {
                    rw.set(v, new MetaParam.Writable[]{new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(2L))});
                    return true;
                }).orElse(false)));
            }
        }
        throw new IllegalArgumentException("Unsupported operation: " + this);
    }

    @Override
    public CompletionStage<?> performAsync(AdvancedCache<Object, Object> cache, Object key) {
        AdvancedCache<Object, Object> functionalCache = FunctionalAdvancedCache.create(cache);
        switch (this) {
            case PUT_CREATE_FUNCTIONAL: 
            case PUT_OVERWRITE_FUNCTIONAL: {
                return functionalCache.putAsync(key, this.value);
            }
            case PUT_IF_ABSENT_FUNCTIONAL: {
                return functionalCache.putIfAbsentAsync(key, this.value);
            }
            case REPLACE_FUNCTIONAL: {
                return functionalCache.replaceAsync(key, this.value);
            }
            case REPLACE_EXACT_FUNCTIONAL: {
                return functionalCache.replaceAsync(key, this.previousValue, this.value);
            }
            case REMOVE_FUNCTIONAL: {
                return functionalCache.removeAsync(key);
            }
            case REMOVE_EXACT_FUNCTIONAL: {
                return functionalCache.removeAsync(key, this.previousValue);
            }
            case REPLACE_META_FUNCTIONAL: {
                return FunctionalTestUtils.rw(cache).eval(key, (Object)"v1", (SerializableBiFunction & Serializable)(v, rw) -> rw.findMetaParam(MetaParam.MetaEntryVersion.class).filter(ver -> ver.get().compareTo((EntryVersion)new NumericVersion(1L)) == InequalVersionComparisonResult.EQUAL).map(ver -> {
                    rw.set(v, new MetaParam.Writable[]{new MetaParam.MetaEntryVersion((EntryVersion)new NumericVersion(2L))});
                    return true;
                }).orElse(false));
            }
        }
        throw new IllegalArgumentException("Unsupported operation: " + this);
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public Object getReturnValueWithRetry() {
        return this.returnValueWithRetry;
    }
}

