/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.op;

import java.util.Collections;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.triangle.BackupWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.context.Flag;
import org.infinispan.test.op.TestOperation;

public enum TestWriteOperation implements TestOperation
{
    PUT_CREATE(PutKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_ALWAYS, null, null, "v1"),
    PUT_OVERWRITE(PutKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_ALWAYS, "v0", "v0", "v1"),
    PUT_IF_ABSENT(PutKeyValueCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_EXPECTED, null, null, null),
    REPLACE(ReplaceCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_NON_NULL, "v0", "v0", "v1"),
    REPLACE_EXACT(ReplaceCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_EXPECTED, "v0", true, true),
    REMOVE(RemoveCommand.class, BackupWriteCommand.class, null, ValueMatcher.MATCH_NON_NULL, "v0", "v0", null),
    REMOVE_EXACT(RemoveCommand.class, BackupWriteCommand.class, null, ValueMatcher.MATCH_EXPECTED, "v0", true, true),
    PUT_MAP_CREATE(PutMapCommand.class, BackupWriteCommand.class, "v1", ValueMatcher.MATCH_EXPECTED, null, null, null);

    private final Class<? extends VisitableCommand> commandClass;
    private final Class<? extends ReplicableCommand> backupCommandClass;
    private final Object value;
    private final ValueMatcher valueMatcher;
    private final Object previousValue;
    private final Object returnValue;
    private final Object returnValueWithRetry;

    private TestWriteOperation(Class<? extends VisitableCommand> commandClass, Class<? extends ReplicableCommand> backupCommandClass, Object value, ValueMatcher valueMatcher, Object previousValue, Object returnValue, Object returnValueWithRetry) {
        this.commandClass = commandClass;
        this.backupCommandClass = backupCommandClass;
        this.value = value;
        this.valueMatcher = valueMatcher;
        this.previousValue = previousValue;
        this.returnValue = returnValue;
        this.returnValueWithRetry = returnValueWithRetry;
    }

    @Override
    public Class<? extends VisitableCommand> getCommandClass() {
        return this.commandClass;
    }

    @Override
    public Class<? extends ReplicableCommand> getBackupCommandClass() {
        return this.backupCommandClass;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getPreviousValue() {
        return this.previousValue;
    }

    @Override
    public Object getReturnValue() {
        return this.returnValue;
    }

    @Override
    public void insertPreviousValue(AdvancedCache<Object, Object> cache, Object key) {
        if (this.previousValue != null) {
            cache.withFlags(Flag.IGNORE_RETURN_VALUES).put(key, this.previousValue);
        }
    }

    @Override
    public Object perform(AdvancedCache<Object, Object> cache, Object key) {
        switch (this) {
            case PUT_CREATE: 
            case PUT_OVERWRITE: {
                return cache.put(key, this.value);
            }
            case PUT_IF_ABSENT: {
                return cache.putIfAbsent(key, this.value);
            }
            case REPLACE: {
                return cache.replace(key, this.value);
            }
            case REPLACE_EXACT: {
                return cache.replace(key, this.previousValue, this.value);
            }
            case REMOVE: {
                return cache.remove(key);
            }
            case REMOVE_EXACT: {
                return cache.remove(key, this.previousValue);
            }
            case PUT_MAP_CREATE: {
                cache.putAll(Collections.singletonMap(key, this.value));
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported operation: " + this);
    }

    @Override
    public CompletionStage<?> performAsync(AdvancedCache<Object, Object> cache, Object key) {
        switch (this) {
            case PUT_CREATE: 
            case PUT_OVERWRITE: {
                return cache.putAsync(key, this.value);
            }
            case PUT_IF_ABSENT: {
                return cache.putIfAbsentAsync(key, this.value);
            }
            case REPLACE: {
                return cache.replaceAsync(key, this.value);
            }
            case REPLACE_EXACT: {
                return cache.replaceAsync(key, this.previousValue, this.value);
            }
            case REMOVE: {
                return cache.removeAsync(key);
            }
            case REMOVE_EXACT: {
                return cache.removeAsync(key, this.previousValue);
            }
            case PUT_MAP_CREATE: {
                return cache.putAllAsync(Collections.singletonMap(key, this.value));
            }
        }
        throw new IllegalArgumentException("Unsupported operation: " + this);
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public Object getReturnValueWithRetry() {
        return this.returnValueWithRetry;
    }
}

