/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.transport;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.View;

public final class DelayedViewJGroupsTransport
extends JGroupsTransport {
    private static Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final CountDownLatch waitLatch;
    private boolean unblocked;

    public DelayedViewJGroupsTransport(CountDownLatch waitLatch) {
        this.waitLatch = waitLatch;
    }

    public void receiveClusterView(View newView) {
        if (this.waitLatch != null && this.getMembers().size() > newView.getMembers().size()) {
            try {
                log.debugf("Delaying view %s", (Object)newView);
                this.unblocked = this.waitLatch.await(10L, TimeUnit.SECONDS);
                if (this.unblocked) {
                    log.debugf("Unblocking view %s", (Object)newView);
                } else {
                    log.errorf("Timed out waiting for view to be unblocked: %s", (Object)newView);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        super.receiveClusterView(newView);
    }

    public void assertUnblocked() {
        assert (this.unblocked);
    }
}

