/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TransportFlags;
import org.jgroups.protocols.DISCARD;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="topology.AsymmetricClusterTest")
@CleanupAfterMethod
public class AsymmetricClusterTest
extends MultipleCacheManagersTest {
    public static final String CACHE_NAME = "testCache";
    private ConfigurationBuilder localConfig;
    private ConfigurationBuilder clusteredConfig;
    DISCARD d1;
    DISCARD d2;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.localConfig = new ConfigurationBuilder();
        this.clusteredConfig = new ConfigurationBuilder();
        this.clusteredConfig.clustering().cacheMode(CacheMode.REPL_SYNC).stateTransfer().timeout(30L, TimeUnit.SECONDS);
        for (int i = 0; i < 2; ++i) {
            this.addClusterEnabledCacheManager(this.localConfig, new TransportFlags().withFD(true));
        }
        this.d1 = TestingUtil.getDiscardForCache(this.manager(0));
        this.d2 = TestingUtil.getDiscardForCache(this.manager(1));
    }

    public void testCrashAndRestartOnlyMember() throws Exception {
        this.testRestartOnlyMember(true);
    }

    public void testStopAndRestartOnlyMember() throws Exception {
        this.testRestartOnlyMember(false);
    }

    private void testRestartOnlyMember(boolean crash) {
        this.manager(1).defineConfiguration(CACHE_NAME, this.clusteredConfig.build());
        this.manager(1).getCache(CACHE_NAME);
        if (crash) {
            this.d2.setDiscardAll(true);
        }
        this.manager(1).stop();
        TestingUtil.blockUntilViewsReceived(30000L, false, new CacheContainer[]{this.manager(0)});
        this.addClusterEnabledCacheManager(new TransportFlags().withFD(true));
        this.manager(2).defineConfiguration(CACHE_NAME, this.clusteredConfig.build());
        this.manager(2).getCache(CACHE_NAME);
    }

    public void testCoordinatorCrashesDuringJoin() {
        this.d2.setDiscardAll(true);
        this.manager(1).defineConfiguration(CACHE_NAME, this.clusteredConfig.build());
        this.fork(() -> this.cache(1, CACHE_NAME));
        TestingUtil.blockUntilViewsReceived(30000L, false, new CacheContainer[]{this.manager(0)});
        TestingUtil.blockUntilViewsReceived(30000L, false, new CacheContainer[]{this.manager(1)});
        TestingUtil.waitForNoRebalance(this.cache(1, CACHE_NAME));
    }
}

