/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.TestAddress;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHashFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.PreferAvailabilityStrategy;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.statetransfer.RebalanceType;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterCacheStatus;
import org.infinispan.topology.ClusterTopologyManagerImpl;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.PersistentUUIDManager;
import org.infinispan.topology.PersistentUUIDManagerImpl;
import org.infinispan.topology.TestClusterCacheStatus;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.impl.EventLogManagerImpl;
import org.mockito.Mockito;
import org.mockito.MockitoSession;
import org.mockito.quality.Strictness;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="topology.ClusterCacheStatusTest")
public class ClusterCacheStatusTest
extends AbstractInfinispanTest {
    private static final String CACHE_NAME = "test";
    private static final CacheJoinInfo JOIN_INFO = new CacheJoinInfo((ConsistentHashFactory)new DefaultConsistentHashFactory(), 8, 2, 1000L, CacheMode.DIST_SYNC, 1.0f, null, Optional.empty());
    private static final Address A = new TestAddress(1, "A");
    private static final Address B = new TestAddress(2, "B");
    private static final Address C = new TestAddress(3, "C");
    private ClusterCacheStatus status;
    private ClusterTopologyManagerImpl topologyManager;
    private MockitoSession mockitoSession;
    private Transport transport;

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.mockitoSession = Mockito.mockitoSession().strictness(Strictness.STRICT_STUBS).startMocking();
        EventLogManagerImpl eventLogManager = new EventLogManagerImpl();
        PersistentUUIDManagerImpl persistentUUIDManager = new PersistentUUIDManagerImpl();
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        this.topologyManager = (ClusterTopologyManagerImpl)Mockito.mock(ClusterTopologyManagerImpl.class);
        this.transport = (Transport)Mockito.mock(Transport.class);
        PreferAvailabilityStrategy availabilityStrategy = new PreferAvailabilityStrategy((EventLogManager)eventLogManager, (PersistentUUIDManager)persistentUUIDManager, ClusterTopologyManagerImpl::distLostDataCheck);
        this.status = new ClusterCacheStatus(cacheManager, CACHE_NAME, (AvailabilityStrategy)availabilityStrategy, RebalanceType.FOUR_PHASE, this.topologyManager, this.transport, (PersistentUUIDManager)persistentUUIDManager, (EventLogManager)eventLogManager, Optional.empty(), false);
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        this.mockitoSession.finishMocking();
    }

    @Test
    public void testQueueRebalanceSingleNode() throws Exception {
        Mockito.when((Object)this.topologyManager.isRebalancingEnabled()).thenReturn((Object)true);
        this.status.doJoin(A, this.makeJoinInfo(A));
        this.verifyStableTopologyUpdate();
        this.status.doJoin(B, this.makeJoinInfo(B));
        this.verifyRebalanceStart();
        this.completeRebalance(this.status);
        this.verifyStableTopologyUpdate();
        this.status.doJoin(C, this.makeJoinInfo(C));
        this.verifyRebalanceStart();
        this.completeRebalance(this.status);
        this.verifyStableTopologyUpdate();
        Mockito.when((Object)this.transport.getMembers()).thenReturn(Collections.singletonList(C));
        Mockito.when((Object)this.transport.getViewId()).thenReturn((Object)1);
        this.status.doHandleClusterView(1);
        TestClusterCacheStatus cache = TestClusterCacheStatus.start(JOIN_INFO, C);
        cache.incrementIds(9, 2);
        cache.incrementStableIds(9, 2);
        AssertJUnit.assertEquals((Object)cache.topology(), (Object)this.status.getCurrentTopology());
        AssertJUnit.assertEquals((Object)cache.stableTopology(), (Object)this.status.getStableTopology());
        this.verifyTopologyUpdate();
        this.verifyStableTopologyUpdate();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.topologyManager});
    }

    private void verifyRebalanceStart() {
        ((ClusterTopologyManagerImpl)Mockito.verify((Object)this.topologyManager)).broadcastRebalanceStart(CACHE_NAME, this.status.getCurrentTopology());
    }

    private void verifyStableTopologyUpdate() {
        ((ClusterTopologyManagerImpl)Mockito.verify((Object)this.topologyManager)).broadcastStableTopologyUpdate(CACHE_NAME, this.status.getStableTopology());
    }

    private void verifyTopologyUpdate() {
        ((ClusterTopologyManagerImpl)Mockito.verify((Object)this.topologyManager)).broadcastTopologyUpdate(CACHE_NAME, this.status.getCurrentTopology(), AvailabilityMode.AVAILABLE);
    }

    private void completeRebalance(ClusterCacheStatus status) throws Exception {
        this.advanceRebalance(status, CacheTopology.Phase.READ_OLD_WRITE_ALL, CacheTopology.Phase.READ_ALL_WRITE_ALL, CacheTopology.Phase.READ_NEW_WRITE_ALL, CacheTopology.Phase.NO_REBALANCE);
    }

    private void advanceRebalance(ClusterCacheStatus status, CacheTopology.Phase initialPhase, CacheTopology.Phase ... phases) throws Exception {
        AssertJUnit.assertEquals((Object)initialPhase, (Object)status.getCurrentTopology().getPhase());
        for (CacheTopology.Phase phase : phases) {
            this.confirmRebalancePhase(status, status.getCurrentTopology().getMembers());
            AssertJUnit.assertEquals((Object)phase, (Object)status.getCurrentTopology().getPhase());
            this.verifyTopologyUpdate();
        }
    }

    private void confirmRebalancePhase(ClusterCacheStatus status, List<Address> members) throws Exception {
        int topologyId = status.getCurrentTopology().getTopologyId();
        for (Address a : members) {
            status.confirmRebalancePhase(a, topologyId);
        }
        AssertJUnit.assertEquals((int)(topologyId + 1), (int)status.getCurrentTopology().getTopologyId());
    }

    private CacheJoinInfo makeJoinInfo(Address a) {
        PersistentUUID persistentUUID = new PersistentUUID((long)a.hashCode(), (long)a.hashCode());
        return new CacheJoinInfo(JOIN_INFO.getConsistentHashFactory(), JOIN_INFO.getNumSegments(), JOIN_INFO.getNumOwners(), JOIN_INFO.getTimeout(), JOIN_INFO.getCacheMode(), JOIN_INFO.getCapacityFactor(), persistentUUID, Optional.empty());
    }
}

