/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.EmbeddedTransactionTest")
public class EmbeddedTransactionTest
extends SingleCacheManagerTest {
    private static final String SYNC_CACHE_NAME = "sync-cache";
    private static final String XA_CACHE_NAME = "xa-cache";
    private static final String KEY = "key";
    private static final String VALUE = "value";

    public void testFailBeforeWithMarkRollbackFirstSync() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterFailSynchronization(FailMode.BEFORE_MARK_ROLLBACK), new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testFailBeforeWithExceptionFirstSync() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterFailSynchronization(FailMode.BEFORE_THROW_EXCEPTION), new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testFailBeforeWithMarkRollbackSecondSync() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterFailSynchronization(FailMode.BEFORE_MARK_ROLLBACK), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testFailBeforeWithExceptionSecondSync() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterFailSynchronization(FailMode.BEFORE_THROW_EXCEPTION), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testEndFailFirstXa() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_END), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testEndFailSecondXa() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_END)));
    }

    public void testPrepareFailFirstXa() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_PREPARE), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testPrepareFailSecondXa() throws Exception {
        this.doCommitWithRollbackExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_PREPARE)));
    }

    public void testCommitFailFirstXa() throws Exception {
        this.doCommitWithExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_COMMIT), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))), HeuristicMixedException.class, true);
    }

    public void testCommitFailSecondXa() throws Exception {
        this.doCommitWithExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_COMMIT)), HeuristicMixedException.class, true);
    }

    public void testRollbackFailFirstXa() throws Exception {
        this.doRollbackWithHeuristicExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_ROLLBACK), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testRollbackFailSecondXa() throws Exception {
        this.doRollbackWithHeuristicExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_ROLLBACK)));
    }

    public void testFailAfterFirstSync() throws Exception {
        this.doAfterCompletionFailTest(Arrays.asList(new RegisterFailSynchronization(FailMode.AFTER_THROW_EXCEPTION), new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testFailAfterSecondSync() throws Exception {
        this.doAfterCompletionFailTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterFailSynchronization(FailMode.AFTER_THROW_EXCEPTION), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME))));
    }

    public void testReadOnlyResource() throws Exception {
        EmbeddedTransactionManager transactionManager = EmbeddedTransactionManager.getInstance();
        transactionManager.begin();
        this.cacheManager.getCache(SYNC_CACHE_NAME).put((Object)KEY, (Object)VALUE);
        this.cacheManager.getCache(XA_CACHE_NAME).put((Object)KEY, (Object)VALUE);
        transactionManager.getTransaction().enlistResource((XAResource)new ReadOnlyXaResource());
        transactionManager.commit();
        this.assertData();
        this.assertNoTxInAllCaches();
        AssertJUnit.assertNull((Object)transactionManager.getTransaction());
    }

    public void testNoTransactionAtCommitAlone() throws Exception {
        this.doCommitWithExceptionTest(Collections.singletonList(new RegisterFailXaResource(FailMode.XA_COMMIT_WITH_NOTX)), HeuristicRollbackException.class, false);
    }

    public void testNoTransactionAtCommitWithOtherResources() throws Exception {
        this.doCommitWithExceptionTest(Arrays.asList(new RegisterCacheTransaction(this.cacheManager.getCache(SYNC_CACHE_NAME)), new RegisterCacheTransaction(this.cacheManager.getCache(XA_CACHE_NAME)), new RegisterFailXaResource(FailMode.XA_COMMIT_WITH_NOTX)), HeuristicMixedException.class, true);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager(this.getDefaultStandaloneCacheConfig(true));
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.transaction().useSynchronization(true);
        builder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cacheManager.defineConfiguration(SYNC_CACHE_NAME, builder.build());
        builder = this.getDefaultStandaloneCacheConfig(true);
        builder.transaction().useSynchronization(false);
        builder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cacheManager.defineConfiguration(XA_CACHE_NAME, builder.build());
        return cacheManager;
    }

    private void doCommitWithRollbackExceptionTest(Collection<RegisterTransaction> registerTransactionCollection) throws Exception {
        EmbeddedTransactionManager transactionManager = EmbeddedTransactionManager.getInstance();
        transactionManager.begin();
        for (RegisterTransaction registerTransaction : registerTransactionCollection) {
            registerTransaction.register((TransactionManager)transactionManager);
        }
        try {
            transactionManager.commit();
            AssertJUnit.fail((String)"RollbackException expected!");
        }
        catch (RollbackException rollbackException) {
            // empty catch block
        }
        this.assertEmpty();
        this.assertNoTxInAllCaches();
        AssertJUnit.assertNull((Object)transactionManager.getTransaction());
    }

    private void doCommitWithExceptionTest(Collection<RegisterTransaction> registerTransactionCollection, Class<? extends Exception> exceptionClass, boolean checkData) throws Exception {
        EmbeddedTransactionManager transactionManager = EmbeddedTransactionManager.getInstance();
        transactionManager.begin();
        for (RegisterTransaction registerTransaction : registerTransactionCollection) {
            registerTransaction.register((TransactionManager)transactionManager);
        }
        Exceptions.expectException(exceptionClass, () -> ((EmbeddedTransactionManager)transactionManager).commit());
        if (checkData) {
            this.assertData();
        } else {
            this.assertEmpty();
        }
        this.assertNoTxInAllCaches();
        AssertJUnit.assertNull((Object)transactionManager.getTransaction());
    }

    private void doRollbackWithHeuristicExceptionTest(Collection<RegisterTransaction> registerTransactionCollection) throws Exception {
        EmbeddedTransactionManager transactionManager = EmbeddedTransactionManager.getInstance();
        transactionManager.begin();
        for (RegisterTransaction registerTransaction : registerTransactionCollection) {
            registerTransaction.register((TransactionManager)transactionManager);
        }
        try {
            transactionManager.rollback();
            AssertJUnit.fail((String)"SystemException expected!");
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        this.assertEmpty();
        this.assertNoTxInAllCaches();
        AssertJUnit.assertNull((Object)transactionManager.getTransaction());
    }

    private void doAfterCompletionFailTest(Collection<RegisterTransaction> registerTransactionCollection) throws Exception {
        EmbeddedTransactionManager transactionManager = EmbeddedTransactionManager.getInstance();
        transactionManager.begin();
        for (RegisterTransaction registerTransaction : registerTransactionCollection) {
            registerTransaction.register((TransactionManager)transactionManager);
        }
        transactionManager.commit();
        this.assertData();
        this.assertNoTxInAllCaches();
        AssertJUnit.assertNull((Object)transactionManager.getTransaction());
    }

    private void assertEmpty() {
        AssertJUnit.assertTrue((boolean)this.cacheManager.getCache(SYNC_CACHE_NAME).isEmpty());
        AssertJUnit.assertTrue((boolean)this.cacheManager.getCache(XA_CACHE_NAME).isEmpty());
    }

    private void assertData() {
        AssertJUnit.assertEquals((Object)VALUE, (Object)this.cacheManager.getCache(SYNC_CACHE_NAME).get((Object)KEY));
        AssertJUnit.assertEquals((Object)VALUE, (Object)this.cacheManager.getCache(XA_CACHE_NAME).get((Object)KEY));
    }

    private void assertNoTxInAllCaches() {
        this.assertNoTransactions(this.cacheManager.getCache(XA_CACHE_NAME));
        this.assertNoTransactions(this.cacheManager.getCache(SYNC_CACHE_NAME));
    }

    private static class RegisterFailXaResource
    implements RegisterTransaction {
        private final FailMode failMode;

        private RegisterFailXaResource(FailMode failMode) {
            this.failMode = failMode;
        }

        @Override
        public void register(TransactionManager transactionManager) throws Exception {
            Transaction transaction = transactionManager.getTransaction();
            transaction.enlistResource((XAResource)new FailXaResource(this.failMode));
        }
    }

    private static class RegisterFailSynchronization
    implements RegisterTransaction {
        private final FailMode failMode;

        private RegisterFailSynchronization(FailMode failMode) {
            this.failMode = failMode;
        }

        @Override
        public void register(TransactionManager transactionManager) throws Exception {
            Transaction transaction = transactionManager.getTransaction();
            FailSynchronization failSynchronization = new FailSynchronization(transaction, this.failMode);
            transaction.registerSynchronization((Synchronization)failSynchronization);
        }
    }

    private static class RegisterCacheTransaction
    implements RegisterTransaction {
        private final Cache<String, String> cache;

        private RegisterCacheTransaction(Cache<String, String> cache) {
            this.cache = cache;
        }

        @Override
        public void register(TransactionManager transactionManager) {
            this.cache.put((Object)EmbeddedTransactionTest.KEY, (Object)EmbeddedTransactionTest.VALUE);
        }
    }

    private static class FailSynchronization
    implements Synchronization {
        private final Transaction transaction;
        private final FailMode failMode;

        private FailSynchronization(Transaction transaction, FailMode failMode) {
            this.transaction = transaction;
            this.failMode = failMode;
        }

        public void beforeCompletion() {
            switch (this.failMode) {
                case BEFORE_MARK_ROLLBACK: {
                    try {
                        this.transaction.setRollbackOnly();
                    }
                    catch (SystemException systemException) {}
                    break;
                }
                case BEFORE_THROW_EXCEPTION: {
                    throw new RuntimeException("induced!");
                }
            }
        }

        public void afterCompletion(int status) {
            if (this.failMode == FailMode.AFTER_THROW_EXCEPTION) {
                throw new RuntimeException("induced!");
            }
        }
    }

    private static class FailXaResource
    implements XAResource {
        private final FailMode failMode;

        private FailXaResource(FailMode failMode) {
            this.failMode = failMode;
        }

        @Override
        public void commit(Xid xid, boolean b) throws XAException {
            switch (this.failMode) {
                case XA_COMMIT: {
                    throw new XAException(7);
                }
                case XA_COMMIT_WITH_NOTX: {
                    throw new XAException(-4);
                }
            }
        }

        @Override
        public void end(Xid xid, int i) throws XAException {
            if (this.failMode == FailMode.XA_END) {
                throw new XAException();
            }
        }

        @Override
        public void forget(Xid xid) {
        }

        @Override
        public int getTransactionTimeout() {
            return 0;
        }

        @Override
        public boolean isSameRM(XAResource xaResource) {
            return xaResource instanceof FailSynchronization && ((FailSynchronization)((Object)xaResource)).failMode == this.failMode;
        }

        @Override
        public int prepare(Xid xid) throws XAException {
            if (this.failMode == FailMode.XA_PREPARE) {
                throw new XAException();
            }
            return 0;
        }

        @Override
        public Xid[] recover(int i) {
            return new Xid[0];
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            if (this.failMode == FailMode.XA_ROLLBACK) {
                throw new XAException();
            }
        }

        @Override
        public boolean setTransactionTimeout(int i) {
            return false;
        }

        @Override
        public void start(Xid xid, int i) throws XAException {
        }
    }

    private static class ReadOnlyXaResource
    extends FailXaResource {
        private boolean finished;

        private ReadOnlyXaResource() {
            super(null);
        }

        @Override
        public int prepare(Xid xid) {
            this.finished = true;
            return 3;
        }

        @Override
        public void commit(Xid xid, boolean b) throws XAException {
            if (this.finished) {
                throw new XAException(-4);
            }
        }

        @Override
        public void rollback(Xid xid) throws XAException {
            if (this.finished) {
                throw new XAException(-4);
            }
        }
    }

    private static interface RegisterTransaction {
        public void register(TransactionManager var1) throws Exception;
    }

    private static enum FailMode {
        BEFORE_MARK_ROLLBACK,
        BEFORE_THROW_EXCEPTION,
        AFTER_THROW_EXCEPTION,
        XA_PREPARE,
        XA_COMMIT,
        XA_COMMIT_WITH_NOTX,
        XA_ROLLBACK,
        XA_END;

    }
}

