/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseAsyncInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ExceptionDuringGetTest")
public class ExceptionDuringGetTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = ExceptionDuringGetTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        dcc.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createCluster(dcc, 2);
        this.waitForClusterToForm();
        this.cache(0).put((Object)"k", (Object)"v");
        assert (this.cache(1).get((Object)"k").equals("v"));
    }

    @Test(expectedExceptions={CacheException.class}, expectedExceptionsMessageRegExp="java.lang.RuntimeException: Induced!")
    public void testExceptionDuringGet() {
        this.advancedCache(0).getAsyncInterceptorChain().addInterceptorAfter((AsyncInterceptor)new ExceptionInterceptor(), PessimisticLockingInterceptor.class);
        this.cache(0).get((Object)"k");
        assert (false);
    }

    static class ExceptionInterceptor
    extends BaseAsyncInterceptor {
        ExceptionInterceptor() {
        }

        public Object visitCommand(InvocationContext ctx, VisitableCommand command) throws Throwable {
            throw new RuntimeException("Induced!");
        }
    }
}

