/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(testName="tx.LargeTransactionTest", groups={"functional"})
public class LargeTransactionTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(LargeTransactionTest.class);
    public static final String TEST_CACHE = "TestCache";

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.REPL_SYNC).remoteTimeout(30000L).transaction().transactionMode(TransactionMode.TRANSACTIONAL).invocationBatching().enable().locking().lockAcquisitionTimeout(60000L).useLockStriping(false);
        EmbeddedCacheManager container = TestCacheManagerFactory.createClusteredCacheManager(c);
        container.start();
        this.registerCacheManager(new CacheContainer[]{container});
        container.defineConfiguration(TEST_CACHE, c.build());
        container.startCaches(new String[]{TEST_CACHE});
        Cache cache1 = container.getCache(TEST_CACHE);
        assert (cache1.getCacheConfiguration().clustering().cacheMode().equals((Object)CacheMode.REPL_SYNC));
        cache1.start();
        container = TestCacheManagerFactory.createClusteredCacheManager(c);
        container.start();
        this.registerCacheManager(new CacheContainer[]{container});
        container.defineConfiguration(TEST_CACHE, c.build());
        container.startCaches(new String[]{TEST_CACHE});
        Cache cache2 = container.getCache(TEST_CACHE);
        assert (cache2.getCacheConfiguration().clustering().cacheMode().equals((Object)CacheMode.REPL_SYNC));
    }

    public void testLargeTx() throws Exception {
        int i;
        Cache cache1 = this.cache(0, TEST_CACHE);
        Cache cache2 = this.cache(1, TEST_CACHE);
        TransactionManager tm = TestingUtil.getTransactionManager(cache1);
        tm.begin();
        for (i = 0; i < 200; ++i) {
            cache1.put((Object)("key" + i), (Object)("value" + i));
        }
        log.trace((Object)"___________ before commit");
        tm.commit();
        for (i = 0; i < 200; ++i) {
            assert (cache2.get((Object)("key" + i)).equals("value" + i));
        }
    }

    public void testSinglePutInTx() throws Exception {
        Cache cache1 = this.cache(0, TEST_CACHE);
        Cache cache2 = this.cache(1, TEST_CACHE);
        TransactionManager tm = TestingUtil.getTransactionManager(cache1);
        tm.begin();
        cache1.put((Object)"key", (Object)"val");
        log.trace((Object)"___________ before commit");
        tm.commit();
        assert (cache2.get((Object)"key").equals("val"));
    }

    public void testSimplePutNoTx() {
        Cache cache1 = this.cache(0, TEST_CACHE);
        Cache cache2 = this.cache(1, TEST_CACHE);
        cache1.put((Object)"key", (Object)"val");
        assert (cache2.get((Object)"key").equals("val"));
    }
}

