/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.LockAfterNodesLeftTest")
public class LockAfterNodesLeftTest
extends MultipleCacheManagersTest {
    private final int INITIAL_CLUSTER_SIZE = 6;
    private final int NUM_NODES_TO_STOP_FOR_TEST = 3;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheConfig = LockAfterNodesLeftTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        cacheConfig.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.createClusteredCaches(6, cacheConfig);
        this.waitForClusterToForm();
    }

    public void test() throws Exception {
        int i;
        log.debug((Object)"Adding test key");
        this.cache(0).put((Object)"k", (Object)"v");
        for (i = 0; i < 6; ++i) {
            final TransactionTable transactionTable = TestingUtil.getTransactionTable(this.cache(i));
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return transactionTable.getLocalTransactions().isEmpty();
                }
            });
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() throws Exception {
                    return transactionTable.getRemoteTransactions().isEmpty();
                }
            });
        }
        TestingUtil.sleepThread(2000L);
        log.debug((Object)"Shutting down some nodes ..");
        for (i = 0; i < 3; ++i) {
            ((EmbeddedCacheManager)this.cacheManagers.get(5 - i)).stop();
        }
        log.debug((Object)"Shutdown completed");
        int remainingNodesCount = 3;
        TestingUtil.sleepThread(2000L);
        String key = "key";
        final AtomicInteger errorCount = new AtomicInteger();
        final AtomicInteger rolledBack = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1);
        Thread[] threads = new Thread[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            final int nodeIndex = i2;
            threads[i2] = new Thread("LockAfterNodesLeftTest.Putter-" + i2){

                @Override
                public void run() {
                    try {
                        latch.await();
                        log.debug((Object)"about to begin transaction...");
                        LockAfterNodesLeftTest.this.tm(nodeIndex).begin();
                        try {
                            log.debug((Object)"Getting lock on cache key");
                            LockAfterNodesLeftTest.this.cache(nodeIndex).getAdvancedCache().lock(new Object[]{"key"});
                            log.debug((Object)"Got lock");
                            LockAfterNodesLeftTest.this.cache(nodeIndex).put((Object)"key", (Object)"value");
                            log.debug((Object)"Done with put");
                            TestingUtil.sleepRandom(200);
                            LockAfterNodesLeftTest.this.tm(nodeIndex).commit();
                        }
                        catch (Throwable e) {
                            if (e instanceof RollbackException) {
                                rolledBack.incrementAndGet();
                            } else if (LockAfterNodesLeftTest.this.tm(nodeIndex).getTransaction() != null) {
                                try {
                                    LockAfterNodesLeftTest.this.tm(nodeIndex).rollback();
                                    rolledBack.incrementAndGet();
                                }
                                catch (SystemException e1) {
                                    log.error((Object)"Failed to rollback", (Throwable)e1);
                                }
                            }
                            throw e;
                        }
                    }
                    catch (Throwable e) {
                        errorCount.incrementAndGet();
                        log.error((Object)e);
                    }
                }
            };
            threads[i2].start();
        }
        latch.countDown();
        for (Thread t : threads) {
            t.join();
        }
        log.trace((Object)("Got errors: " + errorCount.get()));
        Assert.assertEquals((int)0, (int)errorCount.get());
    }
}

