/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.HashSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.LockCleanupStateTransferTest")
@CleanupAfterMethod
public class LockCleanupStateTransferTest
extends MultipleCacheManagersTest {
    private static final int KEY_SET_SIZE = 10;
    private ConfigurationBuilder dcc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dcc = LockCleanupStateTransferTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.dcc.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        this.dcc.clustering().hash().numOwners(1);
        this.dcc.clustering().stateTransfer().fetchInMemoryState(true);
        this.createCluster(TestDataSCI.INSTANCE, this.dcc, 2);
        this.waitForClusterToForm();
    }

    public void testBelatedCommit() throws Throwable {
        this.testLockReleasedCorrectly(VersionedCommitCommand.class);
    }

    public void testBelatedTxCompletionNotificationCommand() throws Throwable {
        this.testLockReleasedCorrectly(TxCompletionNotificationCommand.class);
    }

    private void testLockReleasedCorrectly(Class<? extends ReplicableCommand> toBlock) throws Throwable {
        ControlledCommandFactory ccf = ControlledCommandFactory.registerControlledCommandFactory(this.advancedCache(1), toBlock);
        ccf.gate.close();
        HashSet keys = new HashSet(10);
        Future<Object> future = this.fork(() -> {
            this.tm(0).begin();
            for (int i = 0; i < 10; ++i) {
                Object k = this.getKeyForCache(1);
                keys.add(k);
                this.cache(0).put(k, k);
            }
            this.tm(0).commit();
            return null;
        });
        this.eventuallyEquals(1, ccf.blockTypeCommandsReceived::get);
        if (toBlock == TxCompletionNotificationCommand.class) {
            DataContainer dc = this.advancedCache(1).getDataContainer();
            for (Object k : keys) {
                AssertJUnit.assertEquals(k, (Object)dc.get(k).getValue());
            }
        }
        log.trace((Object)"Before state transfer");
        this.addClusterEnabledCacheManager(TestDataSCI.INSTANCE, this.dcc);
        this.waitForClusterToForm();
        log.trace((Object)"After state transfer");
        HashSet migratedKeys = new HashSet(10);
        for (Object key : keys) {
            if (!this.keyMapsToNode(key)) continue;
            migratedKeys.add(key);
        }
        log.tracef("Number of migrated keys is %s", migratedKeys.size());
        if (migratedKeys.size() == 0) {
            return;
        }
        this.eventuallyEquals(1, () -> TestingUtil.getTransactionTable(this.cache(2)).getRemoteTxCount());
        log.trace((Object)"Releasing the gate");
        ccf.gate.open();
        future.get(10L, TimeUnit.SECONDS);
        for (int i = 0; i < 3; ++i) {
            TransactionTable tt = TestingUtil.getTransactionTable(this.cache(i));
            AssertJUnit.assertEquals((String)("For cache " + i), (int)0, (int)tt.getLocalTxCount());
        }
        this.eventually(() -> {
            boolean success = true;
            for (int i = 0; i < 3; ++i) {
                TransactionTable tt = TestingUtil.getTransactionTable(this.cache(i));
                int remoteTxCount = tt.getRemoteTxCount();
                log.tracef("For cache %s, remoteTxCount==%d", this.cache(i), (Object)remoteTxCount);
                success &= remoteTxCount == 0;
            }
            return success;
        });
        for (Object key : keys) {
            this.assertNotLocked(key);
            AssertJUnit.assertEquals(key, (Object)this.cache(0).get(key));
        }
        for (Object k : migratedKeys) {
            AssertJUnit.assertFalse((boolean)this.advancedCache(0).getDataContainer().containsKey(k));
            AssertJUnit.assertFalse((boolean)this.advancedCache(1).getDataContainer().containsKey(k));
            AssertJUnit.assertTrue((boolean)this.advancedCache(2).getDataContainer().containsKey(k));
        }
    }

    private boolean keyMapsToNode(Object key) {
        Address owner = this.owner(key);
        return owner.equals(this.address(2));
    }

    private Address owner(Object key) {
        return this.advancedCache(0).getDistributionManager().getCacheTopology().getDistribution(key).primary();
    }
}

