/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CheckTransactionRpcCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.MagicKey;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.NoLockLostOnLongTxTest")
public class NoLockLostOnLongTxTest
extends MultipleCacheManagersTest {
    private static final long COMPLETED_TX_TIMEOUT = 10000L;
    private ControlledTimeService timeService;

    private static Method extractCleanupMethod() throws NoSuchMethodException {
        Method m = TransactionTable.class.getDeclaredMethod("cleanupTimedOutTransactions", null);
        m.setAccessible(true);
        return m;
    }

    @DataProvider(name="long-tx-test")
    public static Object[][] longTxDataProvider() {
        return new Object[][]{{TestLockMode.PESSIMISTIC}, {TestLockMode.OPTIMISTIC}};
    }

    @Test(dataProvider="long-tx-test")
    public void testLongTx(LongTxTestParameter testParameter) throws Exception {
        String cacheName = testParameter.cacheName();
        this.defineConfigurationOnAllManagers(cacheName, testParameter.config());
        AdvancedCache cache = this.cache(0, cacheName).getAdvancedCache();
        AdvancedCache owner = this.cache(1, cacheName).getAdvancedCache();
        TransactionTable ownerTxTable = owner.getComponentRegistry().getTransactionTable();
        TransactionTable cacheTxTable = cache.getComponentRegistry().getTransactionTable();
        Method cleanupMethod = NoLockLostOnLongTxTest.extractCleanupMethod();
        MagicKey key = new MagicKey("key", (Cache<?, ?>)owner);
        EmbeddedTransactionManager tm = (EmbeddedTransactionManager)cache.getTransactionManager();
        tm.begin();
        cache.put((Object)key, (Object)"a");
        testParameter.beforeAdvanceTime(tm);
        GlobalTransaction gtx = cacheTxTable.getGlobalTransaction((Transaction)tm.getTransaction());
        AssertJUnit.assertTrue((String)"RemoteTransaction must exists after key is locked!", (boolean)ownerTxTable.containRemoteTx(gtx));
        this.timeService.advance(11000L);
        RemoteTransaction rtx = ownerTxTable.getRemoteTransaction(gtx);
        AssertJUnit.assertNotNull((String)"RemoteTransaction must exists after key is locked!", (Object)rtx);
        AssertJUnit.assertTrue((String)"RemoteTransaction is not eligible for timeout.", (rtx.getCreationTime() - this.getCreationTimeCutoff() < 0L ? 1 : 0) != 0);
        cleanupMethod.invoke((Object)ownerTxTable, new Object[0]);
        AssertJUnit.assertTrue((String)"RemoteTransaction should be live after cleanup.", (boolean)ownerTxTable.containRemoteTx(gtx));
        testParameter.afterAdvanceTime(tm);
        AssertJUnit.assertEquals((String)"Wrong value in originator", (String)"a", (String)((String)cache.get((Object)key)));
        AssertJUnit.assertEquals((String)"Wrong value in owner", (String)"a", (String)((String)owner.get((Object)key)));
    }

    public void testCheckTransactionRpcCommand() throws Exception {
        Cache cache0 = this.cache(0);
        Cache cache1 = this.cache(1);
        CommandsFactory factory = cache0.getAdvancedCache().getComponentRegistry().getCommandsFactory();
        RpcManager rpcManager = cache0.getAdvancedCache().getRpcManager();
        RpcOptions rpcOptions = rpcManager.getSyncRpcOptions();
        ResponseCollector collector = CheckTransactionRpcCommand.responseCollector();
        Address remoteAddress = cache1.getAdvancedCache().getRpcManager().getAddress();
        TransactionTable transactionTable = cache1.getAdvancedCache().getComponentRegistry().getTransactionTable();
        CheckTransactionRpcCommand rpcCommand = factory.buildCheckTransactionRpcCommand(Collections.emptyList());
        Collection result = (Collection)rpcManager.invokeCommand(remoteAddress, (ReplicableCommand)rpcCommand, collector, rpcOptions).toCompletableFuture().join();
        AssertJUnit.assertTrue((String)("Expected an empty collection but got: " + result), (boolean)result.isEmpty());
        TransactionManager tm = cache1.getAdvancedCache().getTransactionManager();
        tm.begin();
        cache1.put((Object)"k", (Object)"v");
        rpcCommand = factory.buildCheckTransactionRpcCommand(transactionTable.getLocalGlobalTransaction());
        result = (Collection)rpcManager.invokeCommand(remoteAddress, (ReplicableCommand)rpcCommand, collector, rpcOptions).toCompletableFuture().join();
        AssertJUnit.assertTrue((String)("Expected an empty collection but got: " + result), (boolean)result.isEmpty());
        tm.commit();
        GlobalTransaction nonExistingGtx = new GlobalTransaction(remoteAddress, false);
        nonExistingGtx.setId(-1L);
        List<GlobalTransaction> list = Collections.singletonList(nonExistingGtx);
        rpcCommand = factory.buildCheckTransactionRpcCommand(list);
        result = (Collection)rpcManager.invokeCommand(remoteAddress, (ReplicableCommand)rpcCommand, collector, rpcOptions).toCompletableFuture().join();
        AssertJUnit.assertEquals((String)"Wrong list returned.", list, (Object)result);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = NoLockLostOnLongTxTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.createClusteredCaches(2, TestDataSCI.INSTANCE, builder);
        this.timeService = new ControlledTimeService();
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, this.timeService, true);
        }
    }

    private long getCreationTimeCutoff() {
        long beginning = this.timeService.time();
        return beginning - TimeUnit.MILLISECONDS.toNanos(10000L);
    }

    private static interface LongTxTestParameter {
        public String cacheName();

        public ConfigurationBuilder config();

        public void beforeAdvanceTime(EmbeddedTransactionManager var1);

        public void afterAdvanceTime(EmbeddedTransactionManager var1) throws Exception;
    }

    private static enum TestLockMode implements LongTxTestParameter
    {
        PESSIMISTIC{

            @Override
            public String cacheName() {
                return "p_cache";
            }

            @Override
            public ConfigurationBuilder config() {
                ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
                builder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.PESSIMISTIC).completedTxTimeout(10000L);
                return builder;
            }

            @Override
            public void beforeAdvanceTime(EmbeddedTransactionManager tm) {
            }

            @Override
            public void afterAdvanceTime(EmbeddedTransactionManager tm) throws Exception {
                tm.commit();
            }
        }
        ,
        OPTIMISTIC{

            @Override
            public String cacheName() {
                return "o_cache";
            }

            @Override
            public ConfigurationBuilder config() {
                ConfigurationBuilder builder = AbstractCacheTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
                builder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).lockingMode(LockingMode.OPTIMISTIC).completedTxTimeout(10000L);
                return builder;
            }

            @Override
            public void beforeAdvanceTime(EmbeddedTransactionManager tm) {
                tm.getTransaction().runPrepare();
            }

            @Override
            public void afterAdvanceTime(EmbeddedTransactionManager tm) throws Exception {
                tm.getTransaction().runCommit(false);
                EmbeddedTransactionManager.dissociateTransaction();
            }
        };

    }
}

