/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.NoRpcOnReadonlyTransactionsTest")
@CleanupAfterMethod
public class NoRpcOnReadonlyTransactionsTest
extends MultipleCacheManagersTest {
    private TxCheckInterceptor i0;
    private TxCheckInterceptor i2;
    private TxCheckInterceptor i1;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = NoRpcOnReadonlyTransactionsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        config.clustering().hash().numOwners(1);
        this.createCluster(TestDataSCI.INSTANCE, config, 3);
        this.waitForClusterToForm();
        this.i0 = new TxCheckInterceptor();
        this.i1 = new TxCheckInterceptor();
        this.i2 = new TxCheckInterceptor();
        TestingUtil.extractInterceptorChain(this.advancedCache(0)).addInterceptor((AsyncInterceptor)this.i0, 1);
        TestingUtil.extractInterceptorChain(this.advancedCache(1)).addInterceptor((AsyncInterceptor)this.i1, 1);
        TestingUtil.extractInterceptorChain(this.advancedCache(2)).addInterceptor((AsyncInterceptor)this.i2, 1);
    }

    public void testReadOnlyTxNoNetworkCallAtCommit() throws Exception {
        Object k0 = this.getKeyForCache(0);
        log.tracef("On address %s adding key %s", (Object)this.address(0), k0);
        this.cache(0).put(k0, (Object)"v");
        AssertJUnit.assertEquals((int)0, (int)this.i0.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i0.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remoteCommits);
        log.trace((Object)"Here is where the r-o tx happens.");
        this.tm(1).begin();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get(k0));
        this.tm(1).commit();
        AssertJUnit.assertEquals((int)0, (int)this.i0.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i0.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remoteCommits);
        this.tm(1).begin();
        this.cache(1).put(this.getKeyForCache(2), (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get(k0));
        this.tm(1).commit();
        AssertJUnit.assertEquals((int)0, (int)this.i0.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i0.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remoteCommits);
        AssertJUnit.assertEquals((int)1, (int)this.i2.remotePrepares);
        AssertJUnit.assertEquals((int)1, (int)this.i2.remoteCommits);
    }

    public void testReadOnlyTxNoNetworkCallMultipleCaches() throws Exception {
        this.defineConfigurationOnAllManagers("a", new ConfigurationBuilder().read(this.manager(0).getDefaultCacheConfiguration()));
        this.cache(0, "a");
        this.cache(1, "a");
        this.cache(2, "a");
        this.waitForClusterToForm("a");
        this.cache(0, "a").put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((int)0, (int)this.i0.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i0.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remoteCommits);
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(0, "a").get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1, "a").get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(2, "a").get((Object)"k"));
        Object k0 = this.getKeyForCache(0);
        this.cache(0).put(k0, (Object)"v0");
        Object k1 = this.getKeyForCache(1);
        this.cache(1).put(k1, (Object)"v0");
        Object k2 = this.getKeyForCache(2);
        this.cache(2).put(k2, (Object)"v0");
        this.tm(1).begin();
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1, "a").put((Object)"k", (Object)"v2"));
        AssertJUnit.assertEquals((Object)"v0", (Object)this.cache(1).get(k0));
        AssertJUnit.assertEquals((Object)"v0", (Object)this.cache(1).get(k1));
        AssertJUnit.assertEquals((Object)"v0", (Object)this.cache(1).get(k2));
        this.tm(1).commit();
        AssertJUnit.assertEquals((int)0, (int)this.i0.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i0.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i1.remoteCommits);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remotePrepares);
        AssertJUnit.assertEquals((int)0, (int)this.i2.remoteCommits);
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(0, "a").get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(1, "a").get((Object)"k"));
        AssertJUnit.assertEquals((Object)"v2", (Object)this.cache(2, "a").get((Object)"k"));
    }

    static class TxCheckInterceptor
    extends DDAsyncInterceptor {
        private volatile int remotePrepares;
        private volatile int remoteCommits;

        TxCheckInterceptor() {
        }

        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                ++this.remotePrepares;
            }
            return super.visitPrepareCommand(ctx, command);
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                ++this.remoteCommits;
            }
            return super.visitCommitCommand(ctx, command);
        }

        void reset() {
            this.remoteCommits = 0;
            this.remotePrepares = 0;
        }
    }
}

