/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.OnePhaseXATest", description="See ISPN-156 for details.")
public class OnePhaseXATest
extends AbstractInfinispanTest {
    private List<Cache> caches;
    private List<EmbeddedCacheManager> cacheContainers;
    public static final int CACHES_NUM = 2;

    public void testMultipleCaches() throws Exception {
        int i = 0;
        for (Cache c : this.caches) {
            TransactionManager tm = TestingUtil.getTransactionManager(c);
            tm.begin();
            c.put((Object)("key" + i), (Object)"value");
            tm.commit();
            ++i;
        }
        i = 0;
        for (Cache c : this.caches) {
            assert ("value".equals(c.get((Object)"key0"))) : "Failed getting value for key0 on cache " + i;
            assert ("value".equals(c.get((Object)"key1"))) : "Failed getting value for key1 on cache " + i;
            ++i;
        }
    }

    @BeforeClass
    public void setUp() throws Exception {
        this.caches = new ArrayList<Cache>();
        this.cacheContainers = new ArrayList<EmbeddedCacheManager>();
        for (int i = 0; i < 2; ++i) {
            this.caches.add(this.getCache());
        }
    }

    @AfterClass
    public void tearDown() {
        if (this.caches != null) {
            TestingUtil.killCacheManagers(this.cacheContainers);
        }
    }

    private Cache getCache() {
        GlobalConfigurationBuilder gc = GlobalConfigurationBuilder.defaultClusteredBuilder();
        ConfigurationBuilder c = new ConfigurationBuilder();
        c.clustering().cacheMode(CacheMode.REPL_SYNC).remoteTimeout(30000L).transaction().invocationBatching().enable().locking().lockAcquisitionTimeout(60000L).useLockStriping(false);
        EmbeddedCacheManager container = TestCacheManagerFactory.createClusteredCacheManager(gc, c);
        this.cacheContainers.add(container);
        container.defineConfiguration("TestCache", c.build());
        return container.getCache("TestCache");
    }
}

