/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.Transaction;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.ReadOnlyTxTest")
@CleanupAfterMethod
public class ReadOnlyTxTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder configuration = ReadOnlyTxTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, true);
        configuration.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.configure(configuration);
        return TestCacheManagerFactory.createCacheManager(configuration);
    }

    protected void configure(ConfigurationBuilder builder) {
        builder.transaction().useSynchronization(false);
    }

    public void testSimpleReadOnlTx() throws Exception {
        this.tm().begin();
        assert (this.cache.get((Object)"k") == null);
        Transaction transaction = this.tm().suspend();
        LocalXaTransaction localTransaction = (LocalXaTransaction)this.txTable().getLocalTransaction(transaction);
        assert (localTransaction != null && localTransaction.isReadOnly());
    }

    public void testNotROWhenHasWrites() throws Exception {
        this.tm().begin();
        this.cache.put((Object)"k", (Object)"v");
        assert (TestingUtil.extractLockManager(this.cache).isLocked((Object)"k"));
        Transaction transaction = this.tm().suspend();
        LocalXaTransaction localTransaction = (LocalXaTransaction)this.txTable().getLocalTransaction(transaction);
        assert (localTransaction != null && !localTransaction.isReadOnly());
    }

    public void testROWhenHasOnlyLocksAndReleasedProperly() throws Exception {
        this.cache.put((Object)"k", (Object)"v");
        this.tm().begin();
        this.cache.getAdvancedCache().withFlags(Flag.FORCE_WRITE_LOCK).get((Object)"k");
        assert (TestingUtil.extractLockManager(this.cache).isLocked((Object)"k"));
        Transaction transaction = this.tm().suspend();
        LocalXaTransaction localTransaction = (LocalXaTransaction)this.txTable().getLocalTransaction(transaction);
        assert (localTransaction != null && localTransaction.isReadOnly());
        this.tm().resume(transaction);
        this.tm().commit();
        assert (!TestingUtil.extractLockManager(this.cache).isLocked((Object)"k"));
    }

    public void testSingleCommitCommand() throws Exception {
        this.cache.put((Object)"k", (Object)"v");
        CommitCommandCounterInterceptor counterInterceptor = new CommitCommandCounterInterceptor();
        TestingUtil.extractInterceptorChain(this.cache).addInterceptor((AsyncInterceptor)counterInterceptor, 0);
        try {
            this.tm().begin();
            AssertJUnit.assertEquals((String)"Wrong value for key k.", (Object)"v", (Object)this.cache.get((Object)"k"));
            this.tm().commit();
        }
        finally {
            TestingUtil.extractInterceptorChain(this.cache).removeInterceptor(((Object)((Object)counterInterceptor)).getClass());
        }
        AssertJUnit.assertEquals((String)"Wrong number of CommitCommand.", (int)this.numberCommitCommand(), (int)counterInterceptor.counter.get());
    }

    protected int numberCommitCommand() {
        return 0;
    }

    private TransactionTable txTable() {
        return TestingUtil.getTransactionTable(this.cache);
    }

    class CommitCommandCounterInterceptor
    extends DDAsyncInterceptor {
        public final AtomicInteger counter = new AtomicInteger(0);

        CommitCommandCounterInterceptor() {
        }

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            this.counter.incrementAndGet();
            return this.invokeNext((InvocationContext)ctx, (VisitableCommand)command);
        }
    }
}

