/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.RemoteLockCleanupTest")
public class RemoteLockCleanupTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder config = RemoteLockCleanupTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        config.transaction().lockingMode(LockingMode.PESSIMISTIC);
        super.createClusteredCaches(2, TestDataSCI.INSTANCE, config);
    }

    public void testLockCleanup() throws Exception {
        DelayInterceptor interceptor = new DelayInterceptor();
        TestingUtil.extractInterceptorChain(this.advancedCache(0)).addInterceptor((AsyncInterceptor)interceptor, 1);
        Object k = this.getKeyForCache(0);
        this.fork(() -> {
            try {
                this.tm(1).begin();
                this.advancedCache(1).lock(new Object[]{k});
                this.tm(1).suspend();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        });
        this.eventually(() -> interceptor.receivedReplRequest);
        TestingUtil.killCacheManagers(this.manager(1));
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0));
        TestingUtil.waitForNoRebalance(this.cache(0));
        this.eventually(() -> interceptor.lockAcquired);
        this.assertEventuallyNotLocked(this.cache(0), "k");
    }

    public static class DelayInterceptor
    extends DDAsyncInterceptor {
        volatile boolean receivedReplRequest = false;
        volatile boolean lockAcquired = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
            if (!ctx.isOriginLocal()) {
                this.receivedReplRequest = true;
                Thread.sleep(5000L);
                try {
                    Object object = super.visitLockControlCommand(ctx, command);
                    return object;
                }
                finally {
                    this.lockAcquired = true;
                }
            }
            return super.visitLockControlCommand(ctx, command);
        }

        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            return super.visitRollbackCommand(ctx, command);
        }
    }
}

