/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.RemoteException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.TimeoutException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.StaleLockRecoveryTest")
public class StaleLockRecoveryTest
extends MultipleCacheManagersTest {
    private Cache<String, String> c1;
    private Cache<String, String> c2;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder c = StaleLockRecoveryTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, true);
        c.transaction().lockingMode(LockingMode.PESSIMISTIC).locking().lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis());
        this.createClusteredCaches(2, "tx", c);
        this.c1 = this.cache(0, "tx");
        this.c2 = this.cache(1, "tx");
    }

    public void testStaleLock() throws SystemException, NotSupportedException {
        this.c1.put((Object)"k", (Object)"v");
        assert (((String)this.c1.get((Object)"k")).equals("v"));
        assert (((String)this.c2.get((Object)"k")).equals("v"));
        TransactionManager tm = TestingUtil.getTransactionManager(this.c1);
        tm.begin();
        this.c1.getAdvancedCache().lock((Object[])new String[]{"k"});
        tm.suspend();
        this.assertLocked(this.c1, "k");
        this.assertLocked(this.c2, "k");
        ((EmbeddedCacheManager)this.cacheManagers.get(0)).stop();
        TestingUtil.blockUntilViewReceived(this.c2, 1);
        EmbeddedCacheManager cacheManager = this.c2.getCacheManager();
        assert (cacheManager.getMembers().size() == 1);
        TestingUtil.sleepThread(1000L);
        this.assertNotLocked(this.c2, "k");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertLocked(Cache<String, String> c, String key) throws SystemException, NotSupportedException {
        TransactionManager tm = TestingUtil.getTransactionManager(c);
        tm.begin();
        try {
            c.put((Object)key, (Object)"dummy");
            assert (false) : "Should have been locked!";
        }
        catch (TimeoutException timeoutException) {
        }
        catch (RemoteException e) {
            assert (e.getCause() instanceof TimeoutException);
        }
        finally {
            tm.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNotLocked(Cache<String, String> c, String key) throws SystemException, NotSupportedException {
        TransactionManager tm = TestingUtil.getTransactionManager(c);
        tm.begin();
        try {
            c.put((Object)key, (Object)"dummy");
        }
        catch (TimeoutException e) {
            assert (false) : "Should not have been locked!";
        }
        finally {
            tm.rollback();
        }
    }
}

