/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.tx.TransactionImpl;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.StateTransferTransactionTest")
public class StateTransferTransactionTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(StateTransferTransactionTest.class);

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(2);
    }

    @DataProvider(name="data")
    public static Object[][] configurationFiles() {
        return new Object[][]{{true, true}, {true, false}, {false, false}};
    }

    @Test(dataProvider="data")
    public void testStateTransferTransactionNotEnlisted(boolean useSync, boolean useRegistry) {
        String cacheName = String.format("cache-%s", StateTransferTransactionTest.suffix(useSync, useRegistry));
        String key = String.format("key-%s", StateTransferTransactionTest.suffix(useSync, useRegistry));
        log.debugf("Starting cache in node0", new Object[0]);
        this.manager(0).defineConfiguration(cacheName, StateTransferTransactionTest.configurationBuilder(useSync, useRegistry).build());
        Cache cache0 = this.manager(0).getCache(cacheName);
        cache0.put((Object)key, (Object)"value");
        log.debugf("Starting cache in node1", new Object[0]);
        this.manager(1).defineConfiguration(cacheName, StateTransferTransactionTest.configurationBuilder(useSync, useRegistry).build());
        Cache cache1 = this.manager(1).getCache(cacheName);
        this.waitForClusterToForm(cacheName);
        CollectTxInterceptor interceptor = (CollectTxInterceptor)cache1.getAdvancedCache().getAsyncInterceptorChain().findInterceptorWithClass(CollectTxInterceptor.class);
        AssertJUnit.assertEquals((int)1, (int)interceptor.stateTransferTransactions.size());
        TransactionImpl stateTransferTx = (TransactionImpl)interceptor.stateTransferTransactions.iterator().next();
        AssertJUnit.assertTrue((String)"Found XaResource", (boolean)stateTransferTx.getEnlistedResources().isEmpty());
        AssertJUnit.assertTrue((String)"Found Synchronization", (boolean)stateTransferTx.getEnlistedSynchronization().isEmpty());
        AssertJUnit.assertEquals((String)"Wrong value in cache1", (String)"value", (String)((String)cache1.get((Object)key)));
    }

    private static String suffix(boolean useSync, boolean useRegistry) {
        return String.format("%s-%s", useSync ? "sync" : "xa", useRegistry ? "registry" : "no-registry");
    }

    private static ConfigurationBuilder configurationBuilder(boolean useSync, boolean useRegistry) {
        ConfigurationBuilder builder = StateTransferTransactionTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.transaction().useSynchronization(useSync).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        if (useRegistry) {
            builder.transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new DummyTransactionSynchronizationRegistryLookup());
        }
        builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new CollectTxInterceptor()).after(TxInterceptor.class);
        builder.clustering().hash().numSegments(1);
        return builder;
    }

    private static boolean isStateTransferTransaction(Transaction tx) {
        return tx instanceof TransactionImpl && ((TransactionImpl)tx).getXid().getFormatId() == 2;
    }

    static class DummyTransactionSynchronizationRegistryLookup
    implements TransactionSynchronizationRegistryLookup {
        private static final DummyTransactionSynchronizationRegistry INSTANCE = new DummyTransactionSynchronizationRegistry();

        DummyTransactionSynchronizationRegistryLookup() {
        }

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return INSTANCE;
        }
    }

    static class DummyTransactionSynchronizationRegistry
    implements TransactionSynchronizationRegistry {
        DummyTransactionSynchronizationRegistry() {
        }

        public Object getTransactionKey() {
            return null;
        }

        public int getTransactionStatus() {
            return 0;
        }

        public boolean getRollbackOnly() throws IllegalStateException {
            return false;
        }

        public void setRollbackOnly() throws IllegalStateException {
        }

        public void registerInterposedSynchronization(Synchronization synchronization) throws IllegalStateException {
            EmbeddedTransaction tx = DummyTransactionManagerLookup.INSTANCE.getTransaction();
            if (tx == null) {
                throw new IllegalStateException();
            }
            try {
                tx.registerSynchronization(synchronization);
            }
            catch (RollbackException | SystemException e) {
                throw new IllegalStateException(e);
            }
        }

        public Object getResource(Object o) throws IllegalStateException {
            return null;
        }

        public void putResource(Object o, Object o1) throws IllegalStateException {
        }
    }

    static class DummyTransactionManagerLookup
    implements TransactionManagerLookup {
        private static final DummyTransactionManager INSTANCE = new DummyTransactionManager();

        DummyTransactionManagerLookup() {
        }

        public TransactionManager getTransactionManager() throws Exception {
            return INSTANCE;
        }
    }

    static class DummyTransactionManager
    extends EmbeddedBaseTransactionManager {
        DummyTransactionManager() {
        }

        public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
            if (StateTransferTransactionTest.isStateTransferTransaction(tx)) {
                log.debugf("Resume invoked with invalid transaction %s", (Object)tx);
                throw new InvalidTransactionException("Transaction is not a supported instance");
            }
            super.resume(tx);
        }
    }

    static class CollectTxInterceptor
    extends BaseCustomAsyncInterceptor {
        private final Set<TransactionImpl> stateTransferTransactions = Collections.synchronizedSet(new HashSet());

        CollectTxInterceptor() {
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            LocalTransaction localTx;
            Transaction tx;
            if (ctx.isInTxScope() && ctx.isOriginLocal() && StateTransferTransactionTest.isStateTransferTransaction(tx = (localTx = (LocalTransaction)((LocalTxInvocationContext)ctx).getCacheTransaction()).getTransaction())) {
                log.debugf("collect transaction %s. list=%s", (Object)tx, this.stateTransferTransactions);
                this.stateTransferTransactions.add((TransactionImpl)tx);
            }
            return super.handleDefault(ctx, command);
        }
    }
}

