/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.UUID;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TransactionalInvocationContextFactory;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionOriginatorChecker;
import org.infinispan.transaction.tm.EmbeddedBaseTransactionManager;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.LocalXaTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.util.concurrent.CompletableFutures;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="tx.TransactionXaAdapterTmIntegrationTest")
public class TransactionXaAdapterTmIntegrationTest {
    private LocalXaTransaction localTx;
    private TransactionXaAdapter xaAdapter;
    private XidImpl xid;
    private final UUID uuid = UUID.randomUUID();
    private TransactionCoordinator txCoordinator;

    @BeforeMethod
    public void setUp() throws XAException {
        Configuration configuration = new ConfigurationBuilder().build();
        XaTransactionTable txTable = new XaTransactionTable();
        this.txCoordinator = new TransactionCoordinator();
        TestingUtil.inject(txTable, configuration, this.txCoordinator, TransactionOriginatorChecker.LOCAL);
        txTable.start();
        txTable.startXidMapping();
        TransactionFactory gtf = new TransactionFactory();
        gtf.init(false, false, true, false);
        GlobalTransaction globalTransaction = gtf.newGlobalTransaction(null, false);
        EmbeddedBaseTransactionManager tm = new EmbeddedBaseTransactionManager();
        this.localTx = new LocalXaTransaction((Transaction)new EmbeddedTransaction(tm), globalTransaction, false, 1, 0L);
        this.xid = EmbeddedTransaction.createXid((UUID)this.uuid);
        TransactionalInvocationContextFactory icf = new TransactionalInvocationContextFactory();
        CommandsFactory commandsFactory = (CommandsFactory)Mockito.mock(CommandsFactory.class);
        AsyncInterceptorChain invoker = (AsyncInterceptorChain)Mockito.mock(AsyncInterceptorChain.class);
        Mockito.when((Object)invoker.invokeAsync((InvocationContext)ArgumentMatchers.any(), (VisitableCommand)ArgumentMatchers.any())).thenReturn((Object)CompletableFutures.completedNull());
        TestingUtil.inject(this.txCoordinator, commandsFactory, icf, invoker, txTable, configuration);
        this.xaAdapter = new TransactionXaAdapter(this.localTx, txTable);
        this.xaAdapter.start((Xid)this.xid, 0);
    }

    public void testPrepareOnNonexistentXid() {
        XidImpl xid = EmbeddedTransaction.createXid((UUID)this.uuid);
        try {
            this.xaAdapter.prepare((Xid)xid);
            assert (false);
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)-4, (int)e.errorCode);
        }
    }

    public void testCommitOnNonexistentXid() {
        XidImpl xid = EmbeddedTransaction.createXid((UUID)this.uuid);
        try {
            this.xaAdapter.commit((Xid)xid, false);
            assert (false);
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)-4, (int)e.errorCode);
        }
    }

    public void testRollabckOnNonexistentXid() {
        XidImpl xid = EmbeddedTransaction.createXid((UUID)this.uuid);
        try {
            this.xaAdapter.rollback((Xid)xid);
            assert (false);
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)-4, (int)e.errorCode);
        }
    }

    public void testPrepareTxMarkedForRollback() {
        this.localTx.markForRollback(true);
        try {
            this.xaAdapter.prepare((Xid)this.xid);
            assert (false);
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)100, (int)e.errorCode);
        }
    }

    public void testOnePhaseCommitConfigured() throws XAException {
        Configuration configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.INVALIDATION_ASYNC).build();
        TestingUtil.inject(this.txCoordinator, configuration);
        this.txCoordinator.start();
        assert (0 == this.xaAdapter.prepare((Xid)this.xid));
    }

    public void test1PcAndNonExistentXid() {
        Configuration configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.INVALIDATION_ASYNC).build();
        TestingUtil.inject(this.txCoordinator, configuration);
        try {
            XidImpl doesNotExists = EmbeddedTransaction.createXid((UUID)this.uuid);
            this.xaAdapter.commit((Xid)doesNotExists, false);
            assert (false);
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)-4, (int)e.errorCode);
        }
    }

    public void test1PcAndNonExistentXid2() {
        Configuration configuration = new ConfigurationBuilder().clustering().cacheMode(CacheMode.DIST_SYNC).build();
        TestingUtil.inject(this.txCoordinator, configuration);
        try {
            XidImpl doesNotExists = EmbeddedTransaction.createXid((UUID)this.uuid);
            this.xaAdapter.commit((Xid)doesNotExists, true);
            assert (false);
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)-4, (int)e.errorCode);
        }
    }
}

