/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.exception;

import javax.transaction.TransactionManager;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.CustomInterceptorConfigTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.exception.CustomInterceptorExceptionTest")
public class CustomInterceptorExceptionTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager eCm = TestCacheManagerFactory.createCacheManager(CustomInterceptorExceptionTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, true));
        TestingUtil.extractInterceptorChain(eCm.getCache()).addInterceptor((AsyncInterceptor)new CustomInterceptorConfigTest.DummyInterceptor(){

            public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
                throw new IllegalStateException("Induce failure!");
            }
        }, 4);
        return eCm;
    }

    public void testFailure() throws Exception {
        TransactionManager transactionManager = this.cache.getAdvancedCache().getTransactionManager();
        transactionManager.begin();
        try {
            this.cache.put((Object)"k", (Object)"v");
            assert (false);
        }
        catch (Exception e) {
            log.debug((Object)"Ignoring expected exception during put", (Throwable)e);
            Assert.assertEquals((int)transactionManager.getTransaction().getStatus(), (int)1);
        }
    }
}

