/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.RecoveryConfigTest")
public class RecoveryConfigTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.fromXml("configs/recovery-enabled-config.xml");
    }

    @Test(expectedExceptions={CacheConfigurationException.class})
    public void testRecoveryAndAsyncCaches() {
        Configuration defaultConfig = this.cacheManager.getDefaultCacheConfiguration();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(defaultConfig);
        builder.clustering().cacheMode(CacheMode.REPL_ASYNC);
        builder.transaction().recovery().enable();
        builder.build();
    }

    public void testRecoveryWithCacheConfigured() {
        Configuration withRecoveryAndCache = this.cacheManager.getCache("withRecoveryAndCache").getCacheConfiguration();
        Assert.assertTrue((boolean)withRecoveryAndCache.transaction().recovery().enabled(), (String)"Recovery is supposed to be enabled.");
        Assert.assertEquals((String)withRecoveryAndCache.transaction().recovery().recoveryInfoCacheName(), (String)"noRecovery", (String)"Wrong recovery cache name.");
        RecoveryManagerImpl recoveryManager = RecoveryTestUtil.rm(this.cacheManager.getCache("withRecoveryAndCache"));
        Assert.assertNotNull((Object)recoveryManager, (String)"RecoveryManager should be *not* null when recovery is enabled.");
        Cache preparedTransactions = (Cache)recoveryManager.getInDoubtTransactionsMap();
        Assert.assertEquals((String)preparedTransactions.getName(), (String)"noRecovery", (String)"Wrong recovery cache name.");
    }

    public void testRecoveryWithDefaultCache() {
        Configuration recoveryDefaultCache = this.cacheManager.getCache("withRecoveryDefaultCache").getCacheConfiguration();
        Assert.assertTrue((boolean)recoveryDefaultCache.transaction().recovery().enabled(), (String)"Recovery is supposed to be enabled.");
        Assert.assertEquals((String)recoveryDefaultCache.transaction().recovery().recoveryInfoCacheName(), (String)"__recoveryInfoCacheName__", (String)"Wrong recovery cache name.");
        RecoveryManagerImpl recoveryManager = RecoveryTestUtil.rm(this.cacheManager.getCache("withRecoveryDefaultCache"));
        Assert.assertNotNull((Object)recoveryManager, (String)"RecoveryManager should be *not* null when recovery is enabled.");
        Cache preparedTransactions = (Cache)recoveryManager.getInDoubtTransactionsMap();
        Assert.assertEquals((String)preparedTransactions.getName(), (String)"__recoveryInfoCacheName__", (String)"Wrong recovery cache name.");
    }

    public void testNoRecovery() {
        Configuration noRecovery = this.cacheManager.getCache("noRecovery").getCacheConfiguration();
        Assert.assertFalse((boolean)noRecovery.transaction().recovery().enabled(), (String)"Recovery is supposed to be disabled");
        Assert.assertNull((Object)RecoveryTestUtil.rm(this.cacheManager.getCache("noRecovery")), (String)"RecoveryManager should be null when recovery is disabled");
        Assert.assertEquals((String)noRecovery.transaction().recovery().recoveryInfoCacheName(), (String)"someName", (String)"Wrong recovery cache name.");
    }
}

