/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import java.util.List;
import java.util.Set;
import javax.transaction.xa.Xid;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.RecoveryWithDefaultCacheDistTest")
@CleanupAfterMethod
public class RecoveryWithDefaultCacheDistTest
extends MultipleCacheManagersTest {
    protected ConfigurationBuilder configuration;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.configuration = this.configure();
        this.createCluster(this.configuration, 2);
        this.waitForClusterToForm();
        Assert.assertNotNull((Object)this.manager(0).getCache(this.getRecoveryCacheName(), false));
        Assert.assertNotNull((Object)this.manager(1).getCache(this.getRecoveryCacheName(), false));
    }

    protected ConfigurationBuilder configure() {
        ConfigurationBuilder configuration = RecoveryWithDefaultCacheDistTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        configuration.locking().useLockStriping(false).transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().enable().clustering().stateTransfer().fetchInMemoryState(false);
        return configuration;
    }

    public void testSimpleTx() throws Exception {
        this.tm(0).begin();
        this.cache(0).put((Object)"k", (Object)"v");
        this.tm(0).commit();
        assert (this.cache(1).get((Object)"k").equals("v"));
    }

    public void testLocalAndRemoteTransaction() throws Exception {
        EmbeddedTransaction t0 = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        EmbeddedTransaction t1 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.assertPrepared(0, t0, t1);
        RecoveryTestUtil.prepareTransaction(t0);
        RecoveryTestUtil.assertPrepared(1, t0);
        RecoveryTestUtil.assertPrepared(0, t1);
        RecoveryTestUtil.prepareTransaction(t1);
        RecoveryTestUtil.assertPrepared(1, t0);
        RecoveryTestUtil.assertPrepared(1, t1);
        RecoveryTestUtil.commitTransaction(t0);
        RecoveryTestUtil.assertPrepared(0, t0);
        RecoveryTestUtil.assertPrepared(1, t1);
        RecoveryTestUtil.commitTransaction(t1);
        RecoveryTestUtil.assertPrepared(0, t0);
        RecoveryTestUtil.assertPrepared(0, t1);
        this.eventually(() -> {
            boolean noPrepTxOnFirstNode = this.cache(0, this.getRecoveryCacheName()).size() == 0;
            boolean noPrepTxOnSecondNode = this.cache(1, this.getRecoveryCacheName()).size() == 0;
            return noPrepTxOnFirstNode & noPrepTxOnSecondNode;
        });
        this.eventually(() -> {
            Set inDoubt = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactionInfo();
            return inDoubt.size() == 0;
        });
    }

    public void testNodeCrashesAfterPrepare() throws Exception {
        EmbeddedTransaction t1_1 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_1);
        EmbeddedTransaction t1_2 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_2);
        EmbeddedTransaction t1_3 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_3);
        this.manager(1).stop();
        this.cacheManagers.remove(1);
        TestingUtil.blockUntilViewReceived(this.cache(0), 1, 60000L, false);
        this.eventually(() -> {
            int size = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactionInfo().size();
            return size == 3;
        });
        List inDoubtTransactions = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactions();
        Assert.assertEquals((int)3, (int)inDoubtTransactions.size());
        assert (inDoubtTransactions.contains(t1_1.getXid()));
        assert (inDoubtTransactions.contains(t1_2.getXid()));
        assert (inDoubtTransactions.contains(t1_3.getXid()));
        this.configuration.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        this.startCacheManager();
        TestingUtil.blockUntilViewsReceived(60000L, this.cache(0), this.cache(1));
        EmbeddedTransaction t1_4 = RecoveryTestUtil.beginAndSuspendTx(this.cache(1));
        RecoveryTestUtil.prepareTransaction(t1_4);
        log.trace((Object)"Before main recovery call.");
        RecoveryTestUtil.assertPrepared(4, t1_4);
        RecoveryTestUtil.assertPrepared(1, t1_4);
        RecoveryTestUtil.commitTransaction(t1_4);
        RecoveryTestUtil.assertPrepared(0, t1_4);
        inDoubtTransactions = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactions();
        Assert.assertEquals((int)3, (int)inDoubtTransactions.size());
        assert (inDoubtTransactions.contains(t1_1.getXid()));
        assert (inDoubtTransactions.contains(t1_2.getXid()));
        assert (inDoubtTransactions.contains(t1_3.getXid()));
        t1_4.firstEnlistedResource().forget((Xid)t1_1.getXid());
        log.info((Object)"returned");
        this.eventually(() -> RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactionInfo().size() == 2);
        inDoubtTransactions = RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactions();
        Assert.assertEquals((int)2, (int)inDoubtTransactions.size());
        assert (inDoubtTransactions.contains(t1_2.getXid()));
        assert (inDoubtTransactions.contains(t1_3.getXid()));
        t1_4.firstEnlistedResource().forget((Xid)t1_2.getXid());
        t1_4.firstEnlistedResource().forget((Xid)t1_3.getXid());
        this.eventually(() -> RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactionInfo().size() == 0);
        Assert.assertEquals((int)0, (int)RecoveryTestUtil.rm(this.cache(0)).getInDoubtTransactionInfo().size());
    }

    protected void startCacheManager() {
        this.addClusterEnabledCacheManager(this.configuration);
    }

    protected String getRecoveryCacheName() {
        return "__recoveryInfoCacheName__";
    }
}

