/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.tx.recovery.admin.AbstractRecoveryTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.admin.InDoubtWithCommitFailsTest")
@CleanupAfterMethod
public class InDoubtWithCommitFailsTest
extends AbstractRecoveryTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configuration = InDoubtWithCommitFailsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        configuration.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().enable().locking().useLockStriping(false).clustering().hash().numOwners(2).clustering().l1().disable().stateTransfer().fetchInMemoryState(false);
        this.createCluster(configuration, 2);
        this.waitForClusterToForm();
        this.advancedCache(1).getAsyncInterceptorChain().addInterceptorBefore((AsyncInterceptor)new ForceFailureInterceptor(), InvocationContextInterceptor.class);
    }

    public void testRecoveryInfoListCommit() throws Exception {
        this.test(true);
    }

    public void testRecoveryInfoListRollback() throws Exception {
        this.test(false);
    }

    private void test(boolean commit) {
        assert (this.recoveryOps(0).showInDoubtTransactions().isEmpty());
        TransactionTable tt0 = (TransactionTable)this.cache(0).getAdvancedCache().getComponentRegistry().getComponent(TransactionTable.class);
        EmbeddedTransaction dummyTransaction = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        RecoveryTestUtil.prepareTransaction(dummyTransaction);
        assert (tt0.getLocalTxCount() == 1);
        try {
            if (commit) {
                RecoveryTestUtil.commitTransaction(dummyTransaction);
            } else {
                RecoveryTestUtil.rollbackTransaction(dummyTransaction);
            }
            assert (false) : "exception expected";
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((int)tt0.getLocalTxCount(), (int)1);
        Assert.assertEquals((int)this.countInDoubtTx(this.recoveryOps(0).showInDoubtTransactions()), (int)1);
        Assert.assertEquals((int)this.countInDoubtTx(this.recoveryOps(1).showInDoubtTransactions()), (int)1);
    }

    public static class ForceFailureInterceptor
    extends DDAsyncInterceptor {
        public boolean fail = true;

        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            this.fail();
            return super.visitCommitCommand(ctx, command);
        }

        private void fail() {
            if (this.fail) {
                throw new CacheException("Induced failure");
            }
        }

        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            this.fail();
            return super.visitRollbackCommand(ctx, command);
        }
    }
}

