/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import java.util.List;
import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.tx.recovery.admin.AbstractRecoveryTest;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.admin.SimpleCacheRecoveryAdminTest")
@CleanupAfterMethod
public class SimpleCacheRecoveryAdminTest
extends AbstractRecoveryTest {
    private static final String JMX_DOMAIN = SimpleCacheRecoveryAdminTest.class.getSimpleName();
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private EmbeddedTransaction tx1;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configuration = SimpleCacheRecoveryAdminTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        configuration.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().enable().locking().useLockStriping(false).clustering().hash().numOwners(3).l1().disable();
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager(this.createGlobalConfigurationBuilder(0), configuration, new TransportFlags());
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager(this.createGlobalConfigurationBuilder(1), configuration, new TransportFlags());
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager(this.createGlobalConfigurationBuilder(2), configuration, new TransportFlags());
        this.registerCacheManager(new CacheContainer[]{cm1, cm2, cm3});
        this.defineConfigurationOnAllManagers("test", configuration);
        this.cache(0, "test");
        this.cache(1, "test");
        this.cache(2, "test");
        TestingUtil.waitForNoRebalance(this.caches("test"));
        AssertJUnit.assertTrue((boolean)this.showInDoubtTransactions(0).isEmpty());
        AssertJUnit.assertTrue((boolean)this.showInDoubtTransactions(1).isEmpty());
        AssertJUnit.assertTrue((boolean)this.showInDoubtTransactions(2).isEmpty());
        this.tx1 = RecoveryTestUtil.beginAndSuspendTx(this.cache(2, "test"));
        RecoveryTestUtil.prepareTransaction(this.tx1);
        log.trace((Object)("Shutting down a cache " + this.address(this.cache(2, "test"))));
        TestingUtil.killCacheManagers(this.manager(2));
        TestingUtil.blockUntilViewsReceived(90000L, false, this.cache(0, "test"), this.cache(1, "test"));
    }

    private GlobalConfigurationBuilder createGlobalConfigurationBuilder(int index) {
        GlobalConfigurationBuilder globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalConfiguration.jmx().enabled(true).mBeanServerLookup(this.mBeanServerLookup).domain(JMX_DOMAIN + index);
        return globalConfiguration;
    }

    public void testJmxOperationMetadata() throws Exception {
        TestingUtil.checkMBeanOperationParameterNaming(this.mBeanServerLookup.getMBeanServer(), this.getRecoveryAdminObjectName(0));
    }

    public void testForceCommitOnOtherNode() {
        String inDoubt = this.showInDoubtTransactions(0);
        this.assertInDoubtTxCount(inDoubt, 1);
        this.assertInDoubtTxCount(this.showInDoubtTransactions(1), 1);
        List<Long> ids = this.getInternalIds(inDoubt);
        Assert.assertEquals((int)1, (int)ids.size());
        Assert.assertEquals((int)0, (int)this.cache(0, "test").keySet().size());
        Assert.assertEquals((int)0, (int)this.cache(1, "test").keySet().size());
        if (log.isTraceEnabled()) {
            log.trace((Object)"Before forcing commit!");
        }
        String result = this.invokeForceWithId("forceCommit", 0, ids.get(0));
        this.checkResponse(result, 1);
    }

    public void testForceCommitXid() {
        String s = this.invokeForceWithXid("forceCommit", 0, this.tx1.getXid());
        log.tracef("s = %s", (Object)s);
        this.checkResponse(s, 1);
        s = this.invokeForceWithXid("forceCommit", 0, this.tx1.getXid());
        AssertJUnit.assertTrue((boolean)s.contains("Transaction not found"));
    }

    public void testForceRollbackInternalId() {
        List<Long> ids = this.getInternalIds(this.showInDoubtTransactions(0));
        log.tracef("test:: invoke rollback for %s", ids);
        String result = this.invokeForceWithId("forceRollback", 0, ids.get(0));
        this.checkResponse(result, 0);
        AssertJUnit.assertTrue((boolean)this.invokeForceWithId("forceRollback", 0, ids.get(0)).contains("Transaction not found"));
    }

    public void testForceRollbackXid() {
        String s = this.invokeForceWithXid("forceRollback", 0, this.tx1.getXid());
        this.checkResponse(s, 0);
        s = this.invokeForceWithXid("forceRollback", 0, this.tx1.getXid());
        AssertJUnit.assertTrue((boolean)s.contains("Transaction not found"));
    }

    private void checkResponse(String result, int entryCount) {
        AssertJUnit.assertTrue((String)("Received: " + result), (boolean)this.isSuccess(result));
        Assert.assertEquals((int)this.cache(0, "test").keySet().size(), (int)entryCount);
        Assert.assertEquals((int)this.cache(1, "test").keySet().size(), (int)entryCount);
        this.eventually(() -> this.showInDoubtTransactions(0).isEmpty() && this.showInDoubtTransactions(1).isEmpty());
        this.checkProperlyCleanup(0);
        this.checkProperlyCleanup(1);
    }

    @Override
    protected void checkProperlyCleanup(int managerIndex) {
        this.eventually(() -> TestingUtil.extractLockManager(this.cache(managerIndex, "test")).getNumberOfLocksHeld() == 0);
        TransactionTable tt = TestingUtil.extractComponent(this.cache(managerIndex, "test"), TransactionTable.class);
        this.eventuallyEquals(0, () -> ((TransactionTable)tt).getRemoteTxCount());
        this.eventuallyEquals(0, () -> ((TransactionTable)tt).getLocalTxCount());
        RecoveryManager rm = TestingUtil.extractComponent(this.cache(managerIndex, "test"), RecoveryManager.class);
        this.eventually(() -> rm.getInDoubtTransactions().size() == 0);
        this.eventually(() -> rm.getPreparedTransactionsFromCluster().all().length == 0);
    }

    private String invokeForceWithId(String methodName, int cacheIndex, Long aLong) {
        try {
            ObjectName recoveryAdmin = this.getRecoveryAdminObjectName(cacheIndex);
            return this.mBeanServerLookup.getMBeanServer().invoke(recoveryAdmin, methodName, new Object[]{aLong}, new String[]{Long.TYPE.getName()}).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String invokeForceWithXid(String methodName, int cacheIndex, XidImpl xid) {
        try {
            ObjectName recoveryAdmin = this.getRecoveryAdminObjectName(cacheIndex);
            Object[] params = new Object[]{xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()};
            String[] signature = new String[]{Integer.TYPE.getName(), byte[].class.getName(), byte[].class.getName()};
            return this.mBeanServerLookup.getMBeanServer().invoke(recoveryAdmin, methodName, params, signature).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void assertInDoubtTxCount(String inDoubt, int expectedCount) {
        int count = this.countInDoubtTx(inDoubt);
        Assert.assertEquals((int)expectedCount, (int)count);
    }

    private String showInDoubtTransactions(int cacheIndex) {
        try {
            ObjectName recoveryAdmin = this.getRecoveryAdminObjectName(cacheIndex);
            return (String)this.mBeanServerLookup.getMBeanServer().invoke(recoveryAdmin, "showInDoubtTransactions", new Object[0], new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName getRecoveryAdminObjectName(int cacheIndex) {
        return TestingUtil.getCacheObjectName(JMX_DOMAIN + cacheIndex, "test(dist_sync)", "RecoveryAdmin");
    }
}

